// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworkscm.model



class ListTagsForResourceRequest private constructor(builder: Builder) {
    /**
     * To receive a paginated response, use this parameter to specify the maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a `NextToken` value that you can assign to the `NextToken` request parameter to get the next set of results.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * NextToken is a string that is returned in some command responses. It indicates that not all entries have been returned, and that you must run at least one more request to get remaining items. To get remaining results, call `ListTagsForResource` again, and assign the token from the previous results as the value of the `nextToken` parameter. If there are no more results, the response object's `nextToken` parameter value is `null`. Setting a `nextToken` value that was not returned in your previous results causes an `InvalidNextTokenException` to occur.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * The Amazon Resource Number (ARN) of an AWS OpsWorks for Chef Automate or AWS OpsWorks for Puppet Enterprise server for which you want to show applied tags. For example, `arn:aws:opsworks-cm:us-west-2:123456789012:server/test-owcm-server/EXAMPLE-66b0-4196-8274-d1a2bEXAMPLE`.
     */
    val resourceArn: kotlin.String? = builder.resourceArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworkscm.model.ListTagsForResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListTagsForResourceRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("resourceArn=$resourceArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListTagsForResourceRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (resourceArn != other.resourceArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworkscm.model.ListTagsForResourceRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * To receive a paginated response, use this parameter to specify the maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a `NextToken` value that you can assign to the `NextToken` request parameter to get the next set of results.
         */
        var maxResults: kotlin.Int? = null
        /**
         * NextToken is a string that is returned in some command responses. It indicates that not all entries have been returned, and that you must run at least one more request to get remaining items. To get remaining results, call `ListTagsForResource` again, and assign the token from the previous results as the value of the `nextToken` parameter. If there are no more results, the response object's `nextToken` parameter value is `null`. Setting a `nextToken` value that was not returned in your previous results causes an `InvalidNextTokenException` to occur.
         */
        var nextToken: kotlin.String? = null
        /**
         * The Amazon Resource Number (ARN) of an AWS OpsWorks for Chef Automate or AWS OpsWorks for Puppet Enterprise server for which you want to show applied tags. For example, `arn:aws:opsworks-cm:us-west-2:123456789012:server/test-owcm-server/EXAMPLE-66b0-4196-8274-d1a2bEXAMPLE`.
         */
        var resourceArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworkscm.model.ListTagsForResourceRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.resourceArn = x.resourceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworkscm.model.ListTagsForResourceRequest = ListTagsForResourceRequest(this)
    }
}
