// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworkscm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.opsworkscm.model.DescribeNodeAssociationStatusResponse
import aws.sdk.kotlin.services.opsworkscm.model.EngineAttribute
import aws.sdk.kotlin.services.opsworkscm.model.NodeAssociationStatus
import aws.sdk.kotlin.services.opsworkscm.model.OpsWorksCmException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeNodeAssociationStatusOperationDeserializer: HttpDeserialize<DescribeNodeAssociationStatusResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeNodeAssociationStatusResponse {
        if (!response.status.isSuccess()) {
            throwDescribeNodeAssociationStatusError(context, response)
        }
        val builder = DescribeNodeAssociationStatusResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeNodeAssociationStatusOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeNodeAssociationStatusError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw OpsWorksCmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> OpsWorksCmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeNodeAssociationStatusOperationBody(builder: DescribeNodeAssociationStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENGINEATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("EngineAttributes"))
    val NODEASSOCIATIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NodeAssociationStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENGINEATTRIBUTES_DESCRIPTOR)
        field(NODEASSOCIATIONSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENGINEATTRIBUTES_DESCRIPTOR.index -> builder.engineAttributes =
                    deserializer.deserializeList(ENGINEATTRIBUTES_DESCRIPTOR) {
                        val col0 = mutableListOf<EngineAttribute>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEngineAttributeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NODEASSOCIATIONSTATUS_DESCRIPTOR.index -> builder.nodeAssociationStatus = deserializeString().let { NodeAssociationStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
