// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.outposts

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.outposts.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.outposts.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Web Services Outposts is a fully managed service that extends Amazon Web Services infrastructure, APIs, and tools to customer premises. By providing local access to Amazon Web Services managed infrastructure, Amazon Web Services Outposts enables customers to build and run applications on premises using the same programming interfaces as in Amazon Web Services Regions, while using local compute and storage resources for lower latency and local data processing needs.
 */
interface OutpostsClient : SdkClient {

    override val serviceName: String
        get() = "Outposts"
    /**
     * OutpostsClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): OutpostsClient {
            val config = Config.Builder().apply(block).build()
            return DefaultOutpostsClient(config)
        }

        operator fun invoke(config: Config): OutpostsClient = DefaultOutpostsClient(config)

        /**
         * Construct a [OutpostsClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): OutpostsClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultOutpostsClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Cancels an order for an Outpost.
     */
    suspend fun cancelOrder(input: CancelOrderRequest): CancelOrderResponse

    /**
     * Cancels an order for an Outpost.
     */
    suspend fun cancelOrder(block: CancelOrderRequest.Builder.() -> Unit) = cancelOrder(CancelOrderRequest.Builder().apply(block).build())

    /**
     * Creates an order for an Outpost.
     */
    suspend fun createOrder(input: CreateOrderRequest): CreateOrderResponse

    /**
     * Creates an order for an Outpost.
     */
    suspend fun createOrder(block: CreateOrderRequest.Builder.() -> Unit) = createOrder(CreateOrderRequest.Builder().apply(block).build())

    /**
     * Creates an Outpost.
     *
     * You can specify `AvailabilityZone` or `AvailabilityZoneId`.
     */
    suspend fun createOutpost(input: CreateOutpostRequest): CreateOutpostResponse

    /**
     * Creates an Outpost.
     *
     * You can specify `AvailabilityZone` or `AvailabilityZoneId`.
     */
    suspend fun createOutpost(block: CreateOutpostRequest.Builder.() -> Unit) = createOutpost(CreateOutpostRequest.Builder().apply(block).build())

    /**
     * Creates a site for an Outpost.
     */
    suspend fun createSite(input: CreateSiteRequest): CreateSiteResponse

    /**
     * Creates a site for an Outpost.
     */
    suspend fun createSite(block: CreateSiteRequest.Builder.() -> Unit) = createSite(CreateSiteRequest.Builder().apply(block).build())

    /**
     * Deletes the Outpost.
     */
    suspend fun deleteOutpost(input: DeleteOutpostRequest): DeleteOutpostResponse

    /**
     * Deletes the Outpost.
     */
    suspend fun deleteOutpost(block: DeleteOutpostRequest.Builder.() -> Unit) = deleteOutpost(DeleteOutpostRequest.Builder().apply(block).build())

    /**
     * Deletes the site.
     */
    suspend fun deleteSite(input: DeleteSiteRequest): DeleteSiteResponse

    /**
     * Deletes the site.
     */
    suspend fun deleteSite(block: DeleteSiteRequest.Builder.() -> Unit) = deleteSite(DeleteSiteRequest.Builder().apply(block).build())

    /**
     * Gets information about a catalog item.
     */
    suspend fun getCatalogItem(input: GetCatalogItemRequest): GetCatalogItemResponse

    /**
     * Gets information about a catalog item.
     */
    suspend fun getCatalogItem(block: GetCatalogItemRequest.Builder.() -> Unit) = getCatalogItem(GetCatalogItemRequest.Builder().apply(block).build())

    /**
     * Gets an order.
     */
    suspend fun getOrder(input: GetOrderRequest): GetOrderResponse

    /**
     * Gets an order.
     */
    suspend fun getOrder(block: GetOrderRequest.Builder.() -> Unit) = getOrder(GetOrderRequest.Builder().apply(block).build())

    /**
     * Gets information about the specified Outpost.
     */
    suspend fun getOutpost(input: GetOutpostRequest): GetOutpostResponse

    /**
     * Gets information about the specified Outpost.
     */
    suspend fun getOutpost(block: GetOutpostRequest.Builder.() -> Unit) = getOutpost(GetOutpostRequest.Builder().apply(block).build())

    /**
     * Gets the instance types for the specified Outpost.
     */
    suspend fun getOutpostInstanceTypes(input: GetOutpostInstanceTypesRequest): GetOutpostInstanceTypesResponse

    /**
     * Gets the instance types for the specified Outpost.
     */
    suspend fun getOutpostInstanceTypes(block: GetOutpostInstanceTypesRequest.Builder.() -> Unit) = getOutpostInstanceTypes(GetOutpostInstanceTypesRequest.Builder().apply(block).build())

    /**
     * Gets information about the specified Outpost site.
     */
    suspend fun getSite(input: GetSiteRequest): GetSiteResponse

    /**
     * Gets information about the specified Outpost site.
     */
    suspend fun getSite(block: GetSiteRequest.Builder.() -> Unit) = getSite(GetSiteRequest.Builder().apply(block).build())

    /**
     * Gets the site address.
     */
    suspend fun getSiteAddress(input: GetSiteAddressRequest): GetSiteAddressResponse

    /**
     * Gets the site address.
     */
    suspend fun getSiteAddress(block: GetSiteAddressRequest.Builder.() -> Unit) = getSiteAddress(GetSiteAddressRequest.Builder().apply(block).build())

    /**
     * Lists the hardware assets in an Outpost. If you are using Dedicated Hosts on Amazon Web Services Outposts, you can filter your request by host ID to return a list of hardware assets that allocate resources for Dedicated Hosts.
     */
    suspend fun listAssets(input: ListAssetsRequest): ListAssetsResponse

    /**
     * Lists the hardware assets in an Outpost. If you are using Dedicated Hosts on Amazon Web Services Outposts, you can filter your request by host ID to return a list of hardware assets that allocate resources for Dedicated Hosts.
     */
    suspend fun listAssets(block: ListAssetsRequest.Builder.() -> Unit) = listAssets(ListAssetsRequest.Builder().apply(block).build())

    /**
     * Lists the items in the catalog. Add filters to your request to return a more specific list of results. Use filters to match an item class, storage option, or EC2 family.
     *
     * If you specify multiple filters, the filters are joined with an `AND`, and the request returns only results that match all of the specified filters.
     */
    suspend fun listCatalogItems(input: ListCatalogItemsRequest = ListCatalogItemsRequest {}): ListCatalogItemsResponse

    /**
     * Lists the items in the catalog. Add filters to your request to return a more specific list of results. Use filters to match an item class, storage option, or EC2 family.
     *
     * If you specify multiple filters, the filters are joined with an `AND`, and the request returns only results that match all of the specified filters.
     */
    suspend fun listCatalogItems(block: ListCatalogItemsRequest.Builder.() -> Unit) = listCatalogItems(ListCatalogItemsRequest.Builder().apply(block).build())

    /**
     * Lists the Outpost orders for your Amazon Web Services account. You can filter your request by Outpost to return a more specific list of results.
     */
    suspend fun listOrders(input: ListOrdersRequest = ListOrdersRequest {}): ListOrdersResponse

    /**
     * Lists the Outpost orders for your Amazon Web Services account. You can filter your request by Outpost to return a more specific list of results.
     */
    suspend fun listOrders(block: ListOrdersRequest.Builder.() -> Unit) = listOrders(ListOrdersRequest.Builder().apply(block).build())

    /**
     * Lists the Outposts for your Amazon Web Services account. Add filters to your request to return a more specific list of results. Use filters to match an Outpost lifecycle status, Availability Zone (`us-east-1a`), and AZ ID (`use1-az1`).
     *
     * If you specify multiple filters, the filters are joined with an `AND`, and the request returns only results that match all of the specified filters.
     */
    suspend fun listOutposts(input: ListOutpostsRequest = ListOutpostsRequest {}): ListOutpostsResponse

    /**
     * Lists the Outposts for your Amazon Web Services account. Add filters to your request to return a more specific list of results. Use filters to match an Outpost lifecycle status, Availability Zone (`us-east-1a`), and AZ ID (`use1-az1`).
     *
     * If you specify multiple filters, the filters are joined with an `AND`, and the request returns only results that match all of the specified filters.
     */
    suspend fun listOutposts(block: ListOutpostsRequest.Builder.() -> Unit) = listOutposts(ListOutpostsRequest.Builder().apply(block).build())

    /**
     * Lists the Outpost sites for your Amazon Web Services account. Add operating address filters to your request to return a more specific list of results. Use filters to match site city, country code, or state/region of the operating address.
     *
     * If you specify multiple filters, the filters are joined with an `AND`, and the request returns only results that match all of the specified filters.
     */
    suspend fun listSites(input: ListSitesRequest = ListSitesRequest {}): ListSitesResponse

    /**
     * Lists the Outpost sites for your Amazon Web Services account. Add operating address filters to your request to return a more specific list of results. Use filters to match site city, country code, or state/region of the operating address.
     *
     * If you specify multiple filters, the filters are joined with an `AND`, and the request returns only results that match all of the specified filters.
     */
    suspend fun listSites(block: ListSitesRequest.Builder.() -> Unit) = listSites(ListSitesRequest.Builder().apply(block).build())

    /**
     * Lists the tags for the specified resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags for the specified resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Adds tags to the specified resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds tags to the specified resource.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes tags from the specified resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes tags from the specified resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates an Outpost.
     */
    suspend fun updateOutpost(input: UpdateOutpostRequest): UpdateOutpostResponse

    /**
     * Updates an Outpost.
     */
    suspend fun updateOutpost(block: UpdateOutpostRequest.Builder.() -> Unit) = updateOutpost(UpdateOutpostRequest.Builder().apply(block).build())

    /**
     * Updates the site.
     */
    suspend fun updateSite(input: UpdateSiteRequest): UpdateSiteResponse

    /**
     * Updates the site.
     */
    suspend fun updateSite(block: UpdateSiteRequest.Builder.() -> Unit) = updateSite(UpdateSiteRequest.Builder().apply(block).build())

    /**
     * Updates the site address.
     *
     *  To update a site address with an order `IN_PROGRESS`, you must wait for the order to complete or cancel the order.
     *
     * You can update the operating address before you place an order at the site, or after all Outposts that belong to the site have been deactivated.
     */
    suspend fun updateSiteAddress(input: UpdateSiteAddressRequest): UpdateSiteAddressResponse

    /**
     * Updates the site address.
     *
     *  To update a site address with an order `IN_PROGRESS`, you must wait for the order to complete or cancel the order.
     *
     * You can update the operating address before you place an order at the site, or after all Outposts that belong to the site have been deactivated.
     */
    suspend fun updateSiteAddress(block: UpdateSiteAddressRequest.Builder.() -> Unit) = updateSiteAddress(UpdateSiteAddressRequest.Builder().apply(block).build())

    /**
     * Update the physical and logistical details for a rack at a site. For more information about hardware requirements for racks, see [Network readiness checklist](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist) in the Amazon Web Services Outposts User Guide.
     *
     * To update a rack at a site with an order of `IN_PROGRESS`, you must wait for the order to complete or cancel the order.
     */
    suspend fun updateSiteRackPhysicalProperties(input: UpdateSiteRackPhysicalPropertiesRequest): UpdateSiteRackPhysicalPropertiesResponse

    /**
     * Update the physical and logistical details for a rack at a site. For more information about hardware requirements for racks, see [Network readiness checklist](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist) in the Amazon Web Services Outposts User Guide.
     *
     * To update a rack at a site with an order of `IN_PROGRESS`, you must wait for the order to complete or cancel the order.
     */
    suspend fun updateSiteRackPhysicalProperties(block: UpdateSiteRackPhysicalPropertiesRequest.Builder.() -> Unit) = updateSiteRackPhysicalProperties(UpdateSiteRackPhysicalPropertiesRequest.Builder().apply(block).build())
}
