// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.outposts.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an order.
 */
class Order private constructor(builder: Builder) {
    /**
     * The line items for the order
     */
    val lineItems: List<LineItem>? = builder.lineItems
    /**
     * The fulfillment date of the order.
     */
    val orderFulfilledDate: aws.smithy.kotlin.runtime.time.Instant? = builder.orderFulfilledDate
    /**
     * The ID of the order.
     */
    val orderId: kotlin.String? = builder.orderId
    /**
     * The submission date for the order.
     */
    val orderSubmissionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.orderSubmissionDate
    /**
     * The ID of the Outpost in the order.
     */
    val outpostId: kotlin.String? = builder.outpostId
    /**
     * The payment option for the order.
     */
    val paymentOption: aws.sdk.kotlin.services.outposts.model.PaymentOption? = builder.paymentOption
    /**
     * The status of the order.
     * + `PREPARING` - Order is received and being prepared.
     * + `IN_PROGRESS` - Order is either being built, shipped, or installed. To get more details, see the `LineItem` status.
     * + `COMPLETED` - Order is complete.
     * + `CANCELLED` - Order is cancelled.
     * + `ERROR` - Customer should contact support.
     *
     * The following status are deprecated: `RECEIVED`, `PENDING`, `PROCESSING`, `INSTALLING`, and `FULFILLED`.
     */
    val status: aws.sdk.kotlin.services.outposts.model.OrderStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.outposts.model.Order = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Order(")
        append("lineItems=$lineItems,")
        append("orderFulfilledDate=$orderFulfilledDate,")
        append("orderId=$orderId,")
        append("orderSubmissionDate=$orderSubmissionDate,")
        append("outpostId=$outpostId,")
        append("paymentOption=$paymentOption,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = lineItems?.hashCode() ?: 0
        result = 31 * result + (orderFulfilledDate?.hashCode() ?: 0)
        result = 31 * result + (orderId?.hashCode() ?: 0)
        result = 31 * result + (orderSubmissionDate?.hashCode() ?: 0)
        result = 31 * result + (outpostId?.hashCode() ?: 0)
        result = 31 * result + (paymentOption?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Order

        if (lineItems != other.lineItems) return false
        if (orderFulfilledDate != other.orderFulfilledDate) return false
        if (orderId != other.orderId) return false
        if (orderSubmissionDate != other.orderSubmissionDate) return false
        if (outpostId != other.outpostId) return false
        if (paymentOption != other.paymentOption) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.outposts.model.Order = Builder(this).apply(block).build()

    class Builder {
        /**
         * The line items for the order
         */
        var lineItems: List<LineItem>? = null
        /**
         * The fulfillment date of the order.
         */
        var orderFulfilledDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the order.
         */
        var orderId: kotlin.String? = null
        /**
         * The submission date for the order.
         */
        var orderSubmissionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the Outpost in the order.
         */
        var outpostId: kotlin.String? = null
        /**
         * The payment option for the order.
         */
        var paymentOption: aws.sdk.kotlin.services.outposts.model.PaymentOption? = null
        /**
         * The status of the order.
         * + `PREPARING` - Order is received and being prepared.
         * + `IN_PROGRESS` - Order is either being built, shipped, or installed. To get more details, see the `LineItem` status.
         * + `COMPLETED` - Order is complete.
         * + `CANCELLED` - Order is cancelled.
         * + `ERROR` - Customer should contact support.
         *
         * The following status are deprecated: `RECEIVED`, `PENDING`, `PROCESSING`, `INSTALLING`, and `FULFILLED`.
         */
        var status: aws.sdk.kotlin.services.outposts.model.OrderStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.outposts.model.Order) : this() {
            this.lineItems = x.lineItems
            this.orderFulfilledDate = x.orderFulfilledDate
            this.orderId = x.orderId
            this.orderSubmissionDate = x.orderSubmissionDate
            this.outpostId = x.outpostId
            this.paymentOption = x.paymentOption
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.outposts.model.Order = Order(this)
    }
}
