// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.outposts.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of line items in your order.
 */
class OrderSummary private constructor(builder: Builder) {
    /**
     * The status of all line items in the order.
     */
    val lineItemCountsByStatus: Map<String, Int>? = builder.lineItemCountsByStatus
    /**
     * Fulfilment date for the order.
     */
    val orderFulfilledDate: aws.smithy.kotlin.runtime.time.Instant? = builder.orderFulfilledDate
    /**
     * The ID of the order.
     */
    val orderId: kotlin.String? = builder.orderId
    /**
     * Submission date for the order.
     */
    val orderSubmissionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.orderSubmissionDate
    /**
     * The type of order.
     */
    val orderType: aws.sdk.kotlin.services.outposts.model.OrderType? = builder.orderType
    /**
     * The ID of the Outpost.
     */
    val outpostId: kotlin.String? = builder.outpostId
    /**
     * The status of the order.
     * + `PREPARING` - Order is received and is being prepared.
     * + `IN_PROGRESS` - Order is either being built, shipped, or installed. For more information, see the `LineItem` status.
     * + `COMPLETED` - Order is complete.
     * + `CANCELLED` - Order is cancelled.
     * + `ERROR` - Customer should contact support.
     *
     * The following statuses are deprecated: `RECEIVED`, `PENDING`, `PROCESSING`, `INSTALLING`, and `FULFILLED`.
     */
    val status: aws.sdk.kotlin.services.outposts.model.OrderStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.outposts.model.OrderSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OrderSummary(")
        append("lineItemCountsByStatus=$lineItemCountsByStatus,")
        append("orderFulfilledDate=$orderFulfilledDate,")
        append("orderId=$orderId,")
        append("orderSubmissionDate=$orderSubmissionDate,")
        append("orderType=$orderType,")
        append("outpostId=$outpostId,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = lineItemCountsByStatus?.hashCode() ?: 0
        result = 31 * result + (orderFulfilledDate?.hashCode() ?: 0)
        result = 31 * result + (orderId?.hashCode() ?: 0)
        result = 31 * result + (orderSubmissionDate?.hashCode() ?: 0)
        result = 31 * result + (orderType?.hashCode() ?: 0)
        result = 31 * result + (outpostId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OrderSummary

        if (lineItemCountsByStatus != other.lineItemCountsByStatus) return false
        if (orderFulfilledDate != other.orderFulfilledDate) return false
        if (orderId != other.orderId) return false
        if (orderSubmissionDate != other.orderSubmissionDate) return false
        if (orderType != other.orderType) return false
        if (outpostId != other.outpostId) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.outposts.model.OrderSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The status of all line items in the order.
         */
        var lineItemCountsByStatus: Map<String, Int>? = null
        /**
         * Fulfilment date for the order.
         */
        var orderFulfilledDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the order.
         */
        var orderId: kotlin.String? = null
        /**
         * Submission date for the order.
         */
        var orderSubmissionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of order.
         */
        var orderType: aws.sdk.kotlin.services.outposts.model.OrderType? = null
        /**
         * The ID of the Outpost.
         */
        var outpostId: kotlin.String? = null
        /**
         * The status of the order.
         * + `PREPARING` - Order is received and is being prepared.
         * + `IN_PROGRESS` - Order is either being built, shipped, or installed. For more information, see the `LineItem` status.
         * + `COMPLETED` - Order is complete.
         * + `CANCELLED` - Order is cancelled.
         * + `ERROR` - Customer should contact support.
         *
         * The following statuses are deprecated: `RECEIVED`, `PENDING`, `PROCESSING`, `INSTALLING`, and `FULFILLED`.
         */
        var status: aws.sdk.kotlin.services.outposts.model.OrderStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.outposts.model.OrderSummary) : this() {
            this.lineItemCountsByStatus = x.lineItemCountsByStatus
            this.orderFulfilledDate = x.orderFulfilledDate
            this.orderId = x.orderId
            this.orderSubmissionDate = x.orderSubmissionDate
            this.orderType = x.orderType
            this.outpostId = x.outpostId
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.outposts.model.OrderSummary = OrderSummary(this)
    }
}
