// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.outposts.model



/**
 * Information about a site.
 */
class Site private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account.
     */
    val accountId: kotlin.String? = builder.accountId
    /**
     * The description of the site.
     */
    val description: kotlin.String? = builder.description
    /**
     * The name of the site.
     */
    val name: kotlin.String? = builder.name
    /**
     * Notes about a site.
     */
    val notes: kotlin.String? = builder.notes
    /**
     * City where the hardware is installed and powered on.
     */
    val operatingAddressCity: kotlin.String? = builder.operatingAddressCity
    /**
     * The ISO-3166 two-letter country code where the hardware is installed and powered on.
     */
    val operatingAddressCountryCode: kotlin.String? = builder.operatingAddressCountryCode
    /**
     * State or region where the hardware is installed and powered on.
     */
    val operatingAddressStateOrRegion: kotlin.String? = builder.operatingAddressStateOrRegion
    /**
     * Information about the physical and logistical details for a rack at the site.
     */
    val rackPhysicalProperties: aws.sdk.kotlin.services.outposts.model.RackPhysicalProperties? = builder.rackPhysicalProperties
    /**
     * The Amazon Resource Name (ARN) of the site.
     */
    val siteArn: kotlin.String? = builder.siteArn
    /**
     * The ID of the site.
     */
    val siteId: kotlin.String? = builder.siteId
    /**
     * The site tags.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.outposts.model.Site = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Site(")
        append("accountId=$accountId,")
        append("description=$description,")
        append("name=$name,")
        append("notes=$notes,")
        append("operatingAddressCity=$operatingAddressCity,")
        append("operatingAddressCountryCode=$operatingAddressCountryCode,")
        append("operatingAddressStateOrRegion=$operatingAddressStateOrRegion,")
        append("rackPhysicalProperties=$rackPhysicalProperties,")
        append("siteArn=$siteArn,")
        append("siteId=$siteId,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (notes?.hashCode() ?: 0)
        result = 31 * result + (operatingAddressCity?.hashCode() ?: 0)
        result = 31 * result + (operatingAddressCountryCode?.hashCode() ?: 0)
        result = 31 * result + (operatingAddressStateOrRegion?.hashCode() ?: 0)
        result = 31 * result + (rackPhysicalProperties?.hashCode() ?: 0)
        result = 31 * result + (siteArn?.hashCode() ?: 0)
        result = 31 * result + (siteId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Site

        if (accountId != other.accountId) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (notes != other.notes) return false
        if (operatingAddressCity != other.operatingAddressCity) return false
        if (operatingAddressCountryCode != other.operatingAddressCountryCode) return false
        if (operatingAddressStateOrRegion != other.operatingAddressStateOrRegion) return false
        if (rackPhysicalProperties != other.rackPhysicalProperties) return false
        if (siteArn != other.siteArn) return false
        if (siteId != other.siteId) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.outposts.model.Site = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the Amazon Web Services account.
         */
        var accountId: kotlin.String? = null
        /**
         * The description of the site.
         */
        var description: kotlin.String? = null
        /**
         * The name of the site.
         */
        var name: kotlin.String? = null
        /**
         * Notes about a site.
         */
        var notes: kotlin.String? = null
        /**
         * City where the hardware is installed and powered on.
         */
        var operatingAddressCity: kotlin.String? = null
        /**
         * The ISO-3166 two-letter country code where the hardware is installed and powered on.
         */
        var operatingAddressCountryCode: kotlin.String? = null
        /**
         * State or region where the hardware is installed and powered on.
         */
        var operatingAddressStateOrRegion: kotlin.String? = null
        /**
         * Information about the physical and logistical details for a rack at the site.
         */
        var rackPhysicalProperties: aws.sdk.kotlin.services.outposts.model.RackPhysicalProperties? = null
        /**
         * The Amazon Resource Name (ARN) of the site.
         */
        var siteArn: kotlin.String? = null
        /**
         * The ID of the site.
         */
        var siteId: kotlin.String? = null
        /**
         * The site tags.
         */
        var tags: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.outposts.model.Site) : this() {
            this.accountId = x.accountId
            this.description = x.description
            this.name = x.name
            this.notes = x.notes
            this.operatingAddressCity = x.operatingAddressCity
            this.operatingAddressCountryCode = x.operatingAddressCountryCode
            this.operatingAddressStateOrRegion = x.operatingAddressStateOrRegion
            this.rackPhysicalProperties = x.rackPhysicalProperties
            this.siteArn = x.siteArn
            this.siteId = x.siteId
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.outposts.model.Site = Site(this)

        /**
         * construct an [aws.sdk.kotlin.services.outposts.model.RackPhysicalProperties] inside the given [block]
         */
        fun rackPhysicalProperties(block: aws.sdk.kotlin.services.outposts.model.RackPhysicalProperties.Builder.() -> kotlin.Unit) {
            this.rackPhysicalProperties = aws.sdk.kotlin.services.outposts.model.RackPhysicalProperties.invoke(block)
        }
    }
}
