// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.outposts.transform

import aws.sdk.kotlin.services.outposts.model.CreateOrderRequest
import aws.sdk.kotlin.services.outposts.model.LineItemRequest
import aws.sdk.kotlin.services.outposts.model.PaymentOption
import aws.sdk.kotlin.services.outposts.model.PaymentTerm
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateOrderOperationSerializer: HttpSerialize<CreateOrderRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateOrderRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/orders"
        }

        val payload = serializeCreateOrderOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateOrderOperationBody(context: ExecutionContext, input: CreateOrderRequest): ByteArray {
    val serializer = JsonSerializer()
    val LINEITEMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("LineItems"))
    val OUTPOSTIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OutpostIdentifier"))
    val PAYMENTOPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PaymentOption"))
    val PAYMENTTERM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PaymentTerm"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LINEITEMS_DESCRIPTOR)
        field(OUTPOSTIDENTIFIER_DESCRIPTOR)
        field(PAYMENTOPTION_DESCRIPTOR)
        field(PAYMENTTERM_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.lineItems != null) {
            listField(LINEITEMS_DESCRIPTOR) {
                for (el0 in input.lineItems) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeLineItemRequestDocument))
                }
            }
        }
        input.outpostIdentifier?.let { field(OUTPOSTIDENTIFIER_DESCRIPTOR, it) }
        input.paymentOption?.let { field(PAYMENTOPTION_DESCRIPTOR, it.value) }
        input.paymentTerm?.let { field(PAYMENTTERM_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
