// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.outposts.transform

import aws.sdk.kotlin.services.outposts.model.FiberOpticCableType
import aws.sdk.kotlin.services.outposts.model.MaximumSupportedWeightLbs
import aws.sdk.kotlin.services.outposts.model.OpticalStandard
import aws.sdk.kotlin.services.outposts.model.PowerConnector
import aws.sdk.kotlin.services.outposts.model.PowerDrawKva
import aws.sdk.kotlin.services.outposts.model.PowerFeedDrop
import aws.sdk.kotlin.services.outposts.model.PowerPhase
import aws.sdk.kotlin.services.outposts.model.UpdateSiteRackPhysicalPropertiesRequest
import aws.sdk.kotlin.services.outposts.model.UplinkCount
import aws.sdk.kotlin.services.outposts.model.UplinkGbps
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateSiteRackPhysicalPropertiesOperationSerializer: HttpSerialize<UpdateSiteRackPhysicalPropertiesRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateSiteRackPhysicalPropertiesRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            val pathSegments = listOf(
                "sites",
                "${input.siteId}".encodeLabel(),
                "rackPhysicalProperties",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateSiteRackPhysicalPropertiesOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateSiteRackPhysicalPropertiesOperationBody(context: ExecutionContext, input: UpdateSiteRackPhysicalPropertiesRequest): ByteArray {
    val serializer = JsonSerializer()
    val FIBEROPTICCABLETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FiberOpticCableType"))
    val MAXIMUMSUPPORTEDWEIGHTLBS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MaximumSupportedWeightLbs"))
    val OPTICALSTANDARD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OpticalStandard"))
    val POWERCONNECTOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PowerConnector"))
    val POWERDRAWKVA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PowerDrawKva"))
    val POWERFEEDDROP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PowerFeedDrop"))
    val POWERPHASE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PowerPhase"))
    val UPLINKCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UplinkCount"))
    val UPLINKGBPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UplinkGbps"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FIBEROPTICCABLETYPE_DESCRIPTOR)
        field(MAXIMUMSUPPORTEDWEIGHTLBS_DESCRIPTOR)
        field(OPTICALSTANDARD_DESCRIPTOR)
        field(POWERCONNECTOR_DESCRIPTOR)
        field(POWERDRAWKVA_DESCRIPTOR)
        field(POWERFEEDDROP_DESCRIPTOR)
        field(POWERPHASE_DESCRIPTOR)
        field(UPLINKCOUNT_DESCRIPTOR)
        field(UPLINKGBPS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.fiberOpticCableType?.let { field(FIBEROPTICCABLETYPE_DESCRIPTOR, it.value) }
        input.maximumSupportedWeightLbs?.let { field(MAXIMUMSUPPORTEDWEIGHTLBS_DESCRIPTOR, it.value) }
        input.opticalStandard?.let { field(OPTICALSTANDARD_DESCRIPTOR, it.value) }
        input.powerConnector?.let { field(POWERCONNECTOR_DESCRIPTOR, it.value) }
        input.powerDrawKva?.let { field(POWERDRAWKVA_DESCRIPTOR, it.value) }
        input.powerFeedDrop?.let { field(POWERFEEDDROP_DESCRIPTOR, it.value) }
        input.powerPhase?.let { field(POWERPHASE_DESCRIPTOR, it.value) }
        input.uplinkCount?.let { field(UPLINKCOUNT_DESCRIPTOR, it.value) }
        input.uplinkGbps?.let { field(UPLINKGBPS_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
