// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.outposts

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.outposts.model.*
import aws.sdk.kotlin.services.outposts.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "Outposts"
public const val ServiceApiVersion: String = "2019-12-03"
public const val SdkVersion: String = "0.17.12-beta"

internal class DefaultOutpostsClient(override val config: OutpostsClient.Config) : OutpostsClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Cancels the specified order for an Outpost.
     */
    override suspend fun cancelOrder(input: CancelOrderRequest): CancelOrderResponse {
        val op = SdkHttpOperation.build<CancelOrderRequest, CancelOrderResponse> {
            serializer = CancelOrderOperationSerializer()
            deserializer = CancelOrderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelOrder"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an order for an Outpost.
     */
    override suspend fun createOrder(input: CreateOrderRequest): CreateOrderResponse {
        val op = SdkHttpOperation.build<CreateOrderRequest, CreateOrderResponse> {
            serializer = CreateOrderOperationSerializer()
            deserializer = CreateOrderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateOrder"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Outpost.
     *
     * You can specify either an Availability one or an AZ ID.
     */
    override suspend fun createOutpost(input: CreateOutpostRequest): CreateOutpostResponse {
        val op = SdkHttpOperation.build<CreateOutpostRequest, CreateOutpostResponse> {
            serializer = CreateOutpostOperationSerializer()
            deserializer = CreateOutpostOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateOutpost"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a site for an Outpost.
     */
    override suspend fun createSite(input: CreateSiteRequest): CreateSiteResponse {
        val op = SdkHttpOperation.build<CreateSiteRequest, CreateSiteResponse> {
            serializer = CreateSiteOperationSerializer()
            deserializer = CreateSiteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSite"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified Outpost.
     */
    override suspend fun deleteOutpost(input: DeleteOutpostRequest): DeleteOutpostResponse {
        val op = SdkHttpOperation.build<DeleteOutpostRequest, DeleteOutpostResponse> {
            serializer = DeleteOutpostOperationSerializer()
            deserializer = DeleteOutpostOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteOutpost"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified site.
     */
    override suspend fun deleteSite(input: DeleteSiteRequest): DeleteSiteResponse {
        val op = SdkHttpOperation.build<DeleteSiteRequest, DeleteSiteResponse> {
            serializer = DeleteSiteOperationSerializer()
            deserializer = DeleteSiteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSite"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified catalog item.
     */
    override suspend fun getCatalogItem(input: GetCatalogItemRequest): GetCatalogItemResponse {
        val op = SdkHttpOperation.build<GetCatalogItemRequest, GetCatalogItemResponse> {
            serializer = GetCatalogItemOperationSerializer()
            deserializer = GetCatalogItemOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCatalogItem"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Amazon Web Services uses this action to install Outpost servers.
     *
     *  Gets information about the specified connection.
     *
     *  Use CloudTrail to monitor this action or Amazon Web Services managed policy for Amazon Web Services Outposts to secure it. For more information, see [ Amazon Web Services managed policies for Amazon Web Services Outposts](https://docs.aws.amazon.com/outposts/latest/userguide/security-iam-awsmanpol.html) and [ Logging Amazon Web Services Outposts API calls with Amazon Web Services CloudTrail](https://docs.aws.amazon.com/outposts/latest/userguide/logging-using-cloudtrail.html) in the *Amazon Web Services Outposts User Guide*.
     */
    override suspend fun getConnection(input: GetConnectionRequest): GetConnectionResponse {
        val op = SdkHttpOperation.build<GetConnectionRequest, GetConnectionResponse> {
            serializer = GetConnectionOperationSerializer()
            deserializer = GetConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified order.
     */
    override suspend fun getOrder(input: GetOrderRequest): GetOrderResponse {
        val op = SdkHttpOperation.build<GetOrderRequest, GetOrderResponse> {
            serializer = GetOrderOperationSerializer()
            deserializer = GetOrderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetOrder"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified Outpost.
     */
    override suspend fun getOutpost(input: GetOutpostRequest): GetOutpostResponse {
        val op = SdkHttpOperation.build<GetOutpostRequest, GetOutpostResponse> {
            serializer = GetOutpostOperationSerializer()
            deserializer = GetOutpostOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetOutpost"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the instance types for the specified Outpost.
     */
    override suspend fun getOutpostInstanceTypes(input: GetOutpostInstanceTypesRequest): GetOutpostInstanceTypesResponse {
        val op = SdkHttpOperation.build<GetOutpostInstanceTypesRequest, GetOutpostInstanceTypesResponse> {
            serializer = GetOutpostInstanceTypesOperationSerializer()
            deserializer = GetOutpostInstanceTypesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetOutpostInstanceTypes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified Outpost site.
     */
    override suspend fun getSite(input: GetSiteRequest): GetSiteResponse {
        val op = SdkHttpOperation.build<GetSiteRequest, GetSiteResponse> {
            serializer = GetSiteOperationSerializer()
            deserializer = GetSiteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSite"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the site address of the specified site.
     */
    override suspend fun getSiteAddress(input: GetSiteAddressRequest): GetSiteAddressResponse {
        val op = SdkHttpOperation.build<GetSiteAddressRequest, GetSiteAddressResponse> {
            serializer = GetSiteAddressOperationSerializer()
            deserializer = GetSiteAddressOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSiteAddress"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the hardware assets for the specified Outpost.
     *
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.
     */
    override suspend fun listAssets(input: ListAssetsRequest): ListAssetsResponse {
        val op = SdkHttpOperation.build<ListAssetsRequest, ListAssetsResponse> {
            serializer = ListAssetsOperationSerializer()
            deserializer = ListAssetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAssets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the items in the catalog.
     *
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.
     */
    override suspend fun listCatalogItems(input: ListCatalogItemsRequest): ListCatalogItemsResponse {
        val op = SdkHttpOperation.build<ListCatalogItemsRequest, ListCatalogItemsResponse> {
            serializer = ListCatalogItemsOperationSerializer()
            deserializer = ListCatalogItemsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCatalogItems"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the Outpost orders for your Amazon Web Services account.
     */
    override suspend fun listOrders(input: ListOrdersRequest): ListOrdersResponse {
        val op = SdkHttpOperation.build<ListOrdersRequest, ListOrdersResponse> {
            serializer = ListOrdersOperationSerializer()
            deserializer = ListOrdersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListOrders"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the Outposts for your Amazon Web Services account.
     *
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.
     */
    override suspend fun listOutposts(input: ListOutpostsRequest): ListOutpostsResponse {
        val op = SdkHttpOperation.build<ListOutpostsRequest, ListOutpostsResponse> {
            serializer = ListOutpostsOperationSerializer()
            deserializer = ListOutpostsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListOutposts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the Outpost sites for your Amazon Web Services account. Use filters to return specific results.
     *
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.
     */
    override suspend fun listSites(input: ListSitesRequest): ListSitesResponse {
        val op = SdkHttpOperation.build<ListSitesRequest, ListSitesResponse> {
            serializer = ListSitesOperationSerializer()
            deserializer = ListSitesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSites"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags for the specified resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Amazon Web Services uses this action to install Outpost servers.
     *
     *  Starts the connection required for Outpost server installation.
     *
     *  Use CloudTrail to monitor this action or Amazon Web Services managed policy for Amazon Web Services Outposts to secure it. For more information, see [ Amazon Web Services managed policies for Amazon Web Services Outposts](https://docs.aws.amazon.com/outposts/latest/userguide/security-iam-awsmanpol.html) and [ Logging Amazon Web Services Outposts API calls with Amazon Web Services CloudTrail](https://docs.aws.amazon.com/outposts/latest/userguide/logging-using-cloudtrail.html) in the *Amazon Web Services Outposts User Guide*.
     */
    override suspend fun startConnection(input: StartConnectionRequest): StartConnectionResponse {
        val op = SdkHttpOperation.build<StartConnectionRequest, StartConnectionResponse> {
            serializer = StartConnectionOperationSerializer()
            deserializer = StartConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds tags to the specified resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes tags from the specified resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an Outpost.
     */
    override suspend fun updateOutpost(input: UpdateOutpostRequest): UpdateOutpostResponse {
        val op = SdkHttpOperation.build<UpdateOutpostRequest, UpdateOutpostResponse> {
            serializer = UpdateOutpostOperationSerializer()
            deserializer = UpdateOutpostOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateOutpost"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified site.
     */
    override suspend fun updateSite(input: UpdateSiteRequest): UpdateSiteResponse {
        val op = SdkHttpOperation.build<UpdateSiteRequest, UpdateSiteResponse> {
            serializer = UpdateSiteOperationSerializer()
            deserializer = UpdateSiteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSite"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the address of the specified site.
     *
     * You can't update a site address if there is an order in progress. You must wait for the order to complete or cancel the order.
     *
     * You can update the operating address before you place an order at the site, or after all Outposts that belong to the site have been deactivated.
     */
    override suspend fun updateSiteAddress(input: UpdateSiteAddressRequest): UpdateSiteAddressResponse {
        val op = SdkHttpOperation.build<UpdateSiteAddressRequest, UpdateSiteAddressResponse> {
            serializer = UpdateSiteAddressOperationSerializer()
            deserializer = UpdateSiteAddressOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSiteAddress"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update the physical and logistical details for a rack at a site. For more information about hardware requirements for racks, see [Network readiness checklist](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist) in the Amazon Web Services Outposts User Guide.
     *
     * To update a rack at a site with an order of `IN_PROGRESS`, you must wait for the order to complete or cancel the order.
     */
    override suspend fun updateSiteRackPhysicalProperties(input: UpdateSiteRackPhysicalPropertiesRequest): UpdateSiteRackPhysicalPropertiesResponse {
        val op = SdkHttpOperation.build<UpdateSiteRackPhysicalPropertiesRequest, UpdateSiteRackPhysicalPropertiesResponse> {
            serializer = UpdateSiteRackPhysicalPropertiesOperationSerializer()
            deserializer = UpdateSiteRackPhysicalPropertiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSiteRackPhysicalProperties"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "outposts"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "outposts")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
