// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.outposts

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.outposts.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.outposts.model.*
import aws.sdk.kotlin.services.outposts.model.CancelOrderRequest
import aws.sdk.kotlin.services.outposts.model.CancelOrderResponse
import aws.sdk.kotlin.services.outposts.model.CreateOrderRequest
import aws.sdk.kotlin.services.outposts.model.CreateOrderResponse
import aws.sdk.kotlin.services.outposts.model.CreateOutpostRequest
import aws.sdk.kotlin.services.outposts.model.CreateOutpostResponse
import aws.sdk.kotlin.services.outposts.model.CreateSiteRequest
import aws.sdk.kotlin.services.outposts.model.CreateSiteResponse
import aws.sdk.kotlin.services.outposts.model.DeleteOutpostRequest
import aws.sdk.kotlin.services.outposts.model.DeleteOutpostResponse
import aws.sdk.kotlin.services.outposts.model.DeleteSiteRequest
import aws.sdk.kotlin.services.outposts.model.DeleteSiteResponse
import aws.sdk.kotlin.services.outposts.model.GetCatalogItemRequest
import aws.sdk.kotlin.services.outposts.model.GetCatalogItemResponse
import aws.sdk.kotlin.services.outposts.model.GetConnectionRequest
import aws.sdk.kotlin.services.outposts.model.GetConnectionResponse
import aws.sdk.kotlin.services.outposts.model.GetOrderRequest
import aws.sdk.kotlin.services.outposts.model.GetOrderResponse
import aws.sdk.kotlin.services.outposts.model.GetOutpostInstanceTypesRequest
import aws.sdk.kotlin.services.outposts.model.GetOutpostInstanceTypesResponse
import aws.sdk.kotlin.services.outposts.model.GetOutpostRequest
import aws.sdk.kotlin.services.outposts.model.GetOutpostResponse
import aws.sdk.kotlin.services.outposts.model.GetSiteAddressRequest
import aws.sdk.kotlin.services.outposts.model.GetSiteAddressResponse
import aws.sdk.kotlin.services.outposts.model.GetSiteRequest
import aws.sdk.kotlin.services.outposts.model.GetSiteResponse
import aws.sdk.kotlin.services.outposts.model.ListAssetsRequest
import aws.sdk.kotlin.services.outposts.model.ListAssetsResponse
import aws.sdk.kotlin.services.outposts.model.ListCatalogItemsRequest
import aws.sdk.kotlin.services.outposts.model.ListCatalogItemsResponse
import aws.sdk.kotlin.services.outposts.model.ListOrdersRequest
import aws.sdk.kotlin.services.outposts.model.ListOrdersResponse
import aws.sdk.kotlin.services.outposts.model.ListOutpostsRequest
import aws.sdk.kotlin.services.outposts.model.ListOutpostsResponse
import aws.sdk.kotlin.services.outposts.model.ListSitesRequest
import aws.sdk.kotlin.services.outposts.model.ListSitesResponse
import aws.sdk.kotlin.services.outposts.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.outposts.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.outposts.model.StartConnectionRequest
import aws.sdk.kotlin.services.outposts.model.StartConnectionResponse
import aws.sdk.kotlin.services.outposts.model.TagResourceRequest
import aws.sdk.kotlin.services.outposts.model.TagResourceResponse
import aws.sdk.kotlin.services.outposts.model.UntagResourceRequest
import aws.sdk.kotlin.services.outposts.model.UntagResourceResponse
import aws.sdk.kotlin.services.outposts.model.UpdateOutpostRequest
import aws.sdk.kotlin.services.outposts.model.UpdateOutpostResponse
import aws.sdk.kotlin.services.outposts.model.UpdateSiteAddressRequest
import aws.sdk.kotlin.services.outposts.model.UpdateSiteAddressResponse
import aws.sdk.kotlin.services.outposts.model.UpdateSiteRackPhysicalPropertiesRequest
import aws.sdk.kotlin.services.outposts.model.UpdateSiteRackPhysicalPropertiesResponse
import aws.sdk.kotlin.services.outposts.model.UpdateSiteRequest
import aws.sdk.kotlin.services.outposts.model.UpdateSiteResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Web Services Outposts is a fully managed service that extends Amazon Web Services infrastructure, APIs, and tools to customer premises. By providing local access to Amazon Web Services managed infrastructure, Amazon Web Services Outposts enables customers to build and run applications on premises using the same programming interfaces as in Amazon Web Services Regions, while using local compute and storage resources for lower latency and local data processing needs.
 */
public interface OutpostsClient : SdkClient {

    override val serviceName: String
        get() = "Outposts"
    /**
     * OutpostsClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): OutpostsClient {
            val config = Config.Builder().apply(block).build()
            return DefaultOutpostsClient(config)
        }

        public operator fun invoke(config: Config): OutpostsClient = DefaultOutpostsClient(config)

        /**
         * Construct a [OutpostsClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): OutpostsClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultOutpostsClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Cancels the specified order for an Outpost.
     */
    public suspend fun cancelOrder(input: CancelOrderRequest): CancelOrderResponse

    /**
     * Creates an order for an Outpost.
     */
    public suspend fun createOrder(input: CreateOrderRequest): CreateOrderResponse

    /**
     * Creates an Outpost.
     *
     * You can specify either an Availability one or an AZ ID.
     */
    public suspend fun createOutpost(input: CreateOutpostRequest): CreateOutpostResponse

    /**
     * Creates a site for an Outpost.
     */
    public suspend fun createSite(input: CreateSiteRequest): CreateSiteResponse

    /**
     * Deletes the specified Outpost.
     */
    public suspend fun deleteOutpost(input: DeleteOutpostRequest): DeleteOutpostResponse

    /**
     * Deletes the specified site.
     */
    public suspend fun deleteSite(input: DeleteSiteRequest): DeleteSiteResponse

    /**
     * Gets information about the specified catalog item.
     */
    public suspend fun getCatalogItem(input: GetCatalogItemRequest): GetCatalogItemResponse

    /**
     * Amazon Web Services uses this action to install Outpost servers.
     *
     *  Gets information about the specified connection.
     *
     *  Use CloudTrail to monitor this action or Amazon Web Services managed policy for Amazon Web Services Outposts to secure it. For more information, see [ Amazon Web Services managed policies for Amazon Web Services Outposts](https://docs.aws.amazon.com/outposts/latest/userguide/security-iam-awsmanpol.html) and [ Logging Amazon Web Services Outposts API calls with Amazon Web Services CloudTrail](https://docs.aws.amazon.com/outposts/latest/userguide/logging-using-cloudtrail.html) in the *Amazon Web Services Outposts User Guide*.
     */
    public suspend fun getConnection(input: GetConnectionRequest): GetConnectionResponse

    /**
     * Gets information about the specified order.
     */
    public suspend fun getOrder(input: GetOrderRequest): GetOrderResponse

    /**
     * Gets information about the specified Outpost.
     */
    public suspend fun getOutpost(input: GetOutpostRequest): GetOutpostResponse

    /**
     * Gets the instance types for the specified Outpost.
     */
    public suspend fun getOutpostInstanceTypes(input: GetOutpostInstanceTypesRequest): GetOutpostInstanceTypesResponse

    /**
     * Gets information about the specified Outpost site.
     */
    public suspend fun getSite(input: GetSiteRequest): GetSiteResponse

    /**
     * Gets the site address of the specified site.
     */
    public suspend fun getSiteAddress(input: GetSiteAddressRequest): GetSiteAddressResponse

    /**
     * Lists the hardware assets for the specified Outpost.
     *
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.
     */
    public suspend fun listAssets(input: ListAssetsRequest): ListAssetsResponse

    /**
     * Lists the items in the catalog.
     *
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.
     */
    public suspend fun listCatalogItems(input: ListCatalogItemsRequest = ListCatalogItemsRequest {}): ListCatalogItemsResponse

    /**
     * Lists the Outpost orders for your Amazon Web Services account.
     */
    public suspend fun listOrders(input: ListOrdersRequest = ListOrdersRequest {}): ListOrdersResponse

    /**
     * Lists the Outposts for your Amazon Web Services account.
     *
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.
     */
    public suspend fun listOutposts(input: ListOutpostsRequest = ListOutpostsRequest {}): ListOutpostsResponse

    /**
     * Lists the Outpost sites for your Amazon Web Services account. Use filters to return specific results.
     *
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.
     */
    public suspend fun listSites(input: ListSitesRequest = ListSitesRequest {}): ListSitesResponse

    /**
     * Lists the tags for the specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Amazon Web Services uses this action to install Outpost servers.
     *
     *  Starts the connection required for Outpost server installation.
     *
     *  Use CloudTrail to monitor this action or Amazon Web Services managed policy for Amazon Web Services Outposts to secure it. For more information, see [ Amazon Web Services managed policies for Amazon Web Services Outposts](https://docs.aws.amazon.com/outposts/latest/userguide/security-iam-awsmanpol.html) and [ Logging Amazon Web Services Outposts API calls with Amazon Web Services CloudTrail](https://docs.aws.amazon.com/outposts/latest/userguide/logging-using-cloudtrail.html) in the *Amazon Web Services Outposts User Guide*.
     */
    public suspend fun startConnection(input: StartConnectionRequest): StartConnectionResponse

    /**
     * Adds tags to the specified resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from the specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an Outpost.
     */
    public suspend fun updateOutpost(input: UpdateOutpostRequest): UpdateOutpostResponse

    /**
     * Updates the specified site.
     */
    public suspend fun updateSite(input: UpdateSiteRequest): UpdateSiteResponse

    /**
     * Updates the address of the specified site.
     *
     * You can't update a site address if there is an order in progress. You must wait for the order to complete or cancel the order.
     *
     * You can update the operating address before you place an order at the site, or after all Outposts that belong to the site have been deactivated.
     */
    public suspend fun updateSiteAddress(input: UpdateSiteAddressRequest): UpdateSiteAddressResponse

    /**
     * Update the physical and logistical details for a rack at a site. For more information about hardware requirements for racks, see [Network readiness checklist](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist) in the Amazon Web Services Outposts User Guide.
     *
     * To update a rack at a site with an order of `IN_PROGRESS`, you must wait for the order to complete or cancel the order.
     */
    public suspend fun updateSiteRackPhysicalProperties(input: UpdateSiteRackPhysicalPropertiesRequest): UpdateSiteRackPhysicalPropertiesResponse
}

/**
 * Cancels the specified order for an Outpost.
 */
public suspend inline fun OutpostsClient.cancelOrder(crossinline block: CancelOrderRequest.Builder.() -> Unit): CancelOrderResponse = cancelOrder(CancelOrderRequest.Builder().apply(block).build())

/**
 * Creates an order for an Outpost.
 */
public suspend inline fun OutpostsClient.createOrder(crossinline block: CreateOrderRequest.Builder.() -> Unit): CreateOrderResponse = createOrder(CreateOrderRequest.Builder().apply(block).build())

/**
 * Creates an Outpost.
 *
 * You can specify either an Availability one or an AZ ID.
 */
public suspend inline fun OutpostsClient.createOutpost(crossinline block: CreateOutpostRequest.Builder.() -> Unit): CreateOutpostResponse = createOutpost(CreateOutpostRequest.Builder().apply(block).build())

/**
 * Creates a site for an Outpost.
 */
public suspend inline fun OutpostsClient.createSite(crossinline block: CreateSiteRequest.Builder.() -> Unit): CreateSiteResponse = createSite(CreateSiteRequest.Builder().apply(block).build())

/**
 * Deletes the specified Outpost.
 */
public suspend inline fun OutpostsClient.deleteOutpost(crossinline block: DeleteOutpostRequest.Builder.() -> Unit): DeleteOutpostResponse = deleteOutpost(DeleteOutpostRequest.Builder().apply(block).build())

/**
 * Deletes the specified site.
 */
public suspend inline fun OutpostsClient.deleteSite(crossinline block: DeleteSiteRequest.Builder.() -> Unit): DeleteSiteResponse = deleteSite(DeleteSiteRequest.Builder().apply(block).build())

/**
 * Gets information about the specified catalog item.
 */
public suspend inline fun OutpostsClient.getCatalogItem(crossinline block: GetCatalogItemRequest.Builder.() -> Unit): GetCatalogItemResponse = getCatalogItem(GetCatalogItemRequest.Builder().apply(block).build())

/**
 * Amazon Web Services uses this action to install Outpost servers.
 *
 *  Gets information about the specified connection.
 *
 *  Use CloudTrail to monitor this action or Amazon Web Services managed policy for Amazon Web Services Outposts to secure it. For more information, see [ Amazon Web Services managed policies for Amazon Web Services Outposts](https://docs.aws.amazon.com/outposts/latest/userguide/security-iam-awsmanpol.html) and [ Logging Amazon Web Services Outposts API calls with Amazon Web Services CloudTrail](https://docs.aws.amazon.com/outposts/latest/userguide/logging-using-cloudtrail.html) in the *Amazon Web Services Outposts User Guide*.
 */
public suspend inline fun OutpostsClient.getConnection(crossinline block: GetConnectionRequest.Builder.() -> Unit): GetConnectionResponse = getConnection(GetConnectionRequest.Builder().apply(block).build())

/**
 * Gets information about the specified order.
 */
public suspend inline fun OutpostsClient.getOrder(crossinline block: GetOrderRequest.Builder.() -> Unit): GetOrderResponse = getOrder(GetOrderRequest.Builder().apply(block).build())

/**
 * Gets information about the specified Outpost.
 */
public suspend inline fun OutpostsClient.getOutpost(crossinline block: GetOutpostRequest.Builder.() -> Unit): GetOutpostResponse = getOutpost(GetOutpostRequest.Builder().apply(block).build())

/**
 * Gets the instance types for the specified Outpost.
 */
public suspend inline fun OutpostsClient.getOutpostInstanceTypes(crossinline block: GetOutpostInstanceTypesRequest.Builder.() -> Unit): GetOutpostInstanceTypesResponse = getOutpostInstanceTypes(GetOutpostInstanceTypesRequest.Builder().apply(block).build())

/**
 * Gets information about the specified Outpost site.
 */
public suspend inline fun OutpostsClient.getSite(crossinline block: GetSiteRequest.Builder.() -> Unit): GetSiteResponse = getSite(GetSiteRequest.Builder().apply(block).build())

/**
 * Gets the site address of the specified site.
 */
public suspend inline fun OutpostsClient.getSiteAddress(crossinline block: GetSiteAddressRequest.Builder.() -> Unit): GetSiteAddressResponse = getSiteAddress(GetSiteAddressRequest.Builder().apply(block).build())

/**
 * Lists the hardware assets for the specified Outpost.
 *
 * Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.
 */
public suspend inline fun OutpostsClient.listAssets(crossinline block: ListAssetsRequest.Builder.() -> Unit): ListAssetsResponse = listAssets(ListAssetsRequest.Builder().apply(block).build())

/**
 * Lists the items in the catalog.
 *
 * Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.
 */
public suspend inline fun OutpostsClient.listCatalogItems(crossinline block: ListCatalogItemsRequest.Builder.() -> Unit): ListCatalogItemsResponse = listCatalogItems(ListCatalogItemsRequest.Builder().apply(block).build())

/**
 * Lists the Outpost orders for your Amazon Web Services account.
 */
public suspend inline fun OutpostsClient.listOrders(crossinline block: ListOrdersRequest.Builder.() -> Unit): ListOrdersResponse = listOrders(ListOrdersRequest.Builder().apply(block).build())

/**
 * Lists the Outposts for your Amazon Web Services account.
 *
 * Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.
 */
public suspend inline fun OutpostsClient.listOutposts(crossinline block: ListOutpostsRequest.Builder.() -> Unit): ListOutpostsResponse = listOutposts(ListOutpostsRequest.Builder().apply(block).build())

/**
 * Lists the Outpost sites for your Amazon Web Services account. Use filters to return specific results.
 *
 * Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.
 */
public suspend inline fun OutpostsClient.listSites(crossinline block: ListSitesRequest.Builder.() -> Unit): ListSitesResponse = listSites(ListSitesRequest.Builder().apply(block).build())

/**
 * Lists the tags for the specified resource.
 */
public suspend inline fun OutpostsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Amazon Web Services uses this action to install Outpost servers.
 *
 *  Starts the connection required for Outpost server installation.
 *
 *  Use CloudTrail to monitor this action or Amazon Web Services managed policy for Amazon Web Services Outposts to secure it. For more information, see [ Amazon Web Services managed policies for Amazon Web Services Outposts](https://docs.aws.amazon.com/outposts/latest/userguide/security-iam-awsmanpol.html) and [ Logging Amazon Web Services Outposts API calls with Amazon Web Services CloudTrail](https://docs.aws.amazon.com/outposts/latest/userguide/logging-using-cloudtrail.html) in the *Amazon Web Services Outposts User Guide*.
 */
public suspend inline fun OutpostsClient.startConnection(crossinline block: StartConnectionRequest.Builder.() -> Unit): StartConnectionResponse = startConnection(StartConnectionRequest.Builder().apply(block).build())

/**
 * Adds tags to the specified resource.
 */
public suspend inline fun OutpostsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from the specified resource.
 */
public suspend inline fun OutpostsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an Outpost.
 */
public suspend inline fun OutpostsClient.updateOutpost(crossinline block: UpdateOutpostRequest.Builder.() -> Unit): UpdateOutpostResponse = updateOutpost(UpdateOutpostRequest.Builder().apply(block).build())

/**
 * Updates the specified site.
 */
public suspend inline fun OutpostsClient.updateSite(crossinline block: UpdateSiteRequest.Builder.() -> Unit): UpdateSiteResponse = updateSite(UpdateSiteRequest.Builder().apply(block).build())

/**
 * Updates the address of the specified site.
 *
 * You can't update a site address if there is an order in progress. You must wait for the order to complete or cancel the order.
 *
 * You can update the operating address before you place an order at the site, or after all Outposts that belong to the site have been deactivated.
 */
public suspend inline fun OutpostsClient.updateSiteAddress(crossinline block: UpdateSiteAddressRequest.Builder.() -> Unit): UpdateSiteAddressResponse = updateSiteAddress(UpdateSiteAddressRequest.Builder().apply(block).build())

/**
 * Update the physical and logistical details for a rack at a site. For more information about hardware requirements for racks, see [Network readiness checklist](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist) in the Amazon Web Services Outposts User Guide.
 *
 * To update a rack at a site with an order of `IN_PROGRESS`, you must wait for the order to complete or cancel the order.
 */
public suspend inline fun OutpostsClient.updateSiteRackPhysicalProperties(crossinline block: UpdateSiteRackPhysicalPropertiesRequest.Builder.() -> Unit): UpdateSiteRackPhysicalPropertiesResponse = updateSiteRackPhysicalProperties(UpdateSiteRackPhysicalPropertiesRequest.Builder().apply(block).build())
