// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.outposts.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.outposts.model.GetOutpostInstanceTypesResponse
import aws.sdk.kotlin.services.outposts.model.InstanceTypeItem
import aws.sdk.kotlin.services.outposts.model.OutpostsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetOutpostInstanceTypesOperationDeserializer: HttpDeserialize<GetOutpostInstanceTypesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetOutpostInstanceTypesResponse {
        if (!response.status.isSuccess()) {
            throwGetOutpostInstanceTypesError(context, response)
        }
        val builder = GetOutpostInstanceTypesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetOutpostInstanceTypesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetOutpostInstanceTypesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw OutpostsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> OutpostsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetOutpostInstanceTypesOperationBody(builder: GetOutpostInstanceTypesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INSTANCETYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("InstanceTypes"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OUTPOSTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OutpostArn"))
    val OUTPOSTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OutpostId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INSTANCETYPES_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(OUTPOSTARN_DESCRIPTOR)
        field(OUTPOSTID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INSTANCETYPES_DESCRIPTOR.index -> builder.instanceTypes =
                    deserializer.deserializeList(INSTANCETYPES_DESCRIPTOR) {
                        val col0 = mutableListOf<InstanceTypeItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInstanceTypeItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                OUTPOSTARN_DESCRIPTOR.index -> builder.outpostArn = deserializeString()
                OUTPOSTID_DESCRIPTOR.index -> builder.outpostId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
