// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.outposts.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of line items in your order.
 */
public class OrderSummary private constructor(builder: Builder) {
    /**
     * The status of all line items in the order.
     */
    public val lineItemCountsByStatus: Map<String, Int>? = builder.lineItemCountsByStatus
    /**
     * Fulfilment date for the order.
     */
    public val orderFulfilledDate: aws.smithy.kotlin.runtime.time.Instant? = builder.orderFulfilledDate
    /**
     * The ID of the order.
     */
    public val orderId: kotlin.String? = builder.orderId
    /**
     * Submission date for the order.
     */
    public val orderSubmissionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.orderSubmissionDate
    /**
     * The type of order.
     */
    public val orderType: aws.sdk.kotlin.services.outposts.model.OrderType? = builder.orderType
    /**
     * The ID of the Outpost.
     */
    public val outpostId: kotlin.String? = builder.outpostId
    /**
     * The status of the order.
     * + `PREPARING` - Order is received and is being prepared.
     * + `IN_PROGRESS` - Order is either being built, shipped, or installed. For more information, see the `LineItem` status.
     * + `COMPLETED` - Order is complete.
     * + `CANCELLED` - Order is cancelled.
     * + `ERROR` - Customer should contact support.
     *
     * The following statuses are deprecated: `RECEIVED`, `PENDING`, `PROCESSING`, `INSTALLING`, and `FULFILLED`.
     */
    public val status: aws.sdk.kotlin.services.outposts.model.OrderStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.outposts.model.OrderSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OrderSummary(")
        append("lineItemCountsByStatus=$lineItemCountsByStatus,")
        append("orderFulfilledDate=$orderFulfilledDate,")
        append("orderId=$orderId,")
        append("orderSubmissionDate=$orderSubmissionDate,")
        append("orderType=$orderType,")
        append("outpostId=$outpostId,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = lineItemCountsByStatus?.hashCode() ?: 0
        result = 31 * result + (orderFulfilledDate?.hashCode() ?: 0)
        result = 31 * result + (orderId?.hashCode() ?: 0)
        result = 31 * result + (orderSubmissionDate?.hashCode() ?: 0)
        result = 31 * result + (orderType?.hashCode() ?: 0)
        result = 31 * result + (outpostId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OrderSummary

        if (lineItemCountsByStatus != other.lineItemCountsByStatus) return false
        if (orderFulfilledDate != other.orderFulfilledDate) return false
        if (orderId != other.orderId) return false
        if (orderSubmissionDate != other.orderSubmissionDate) return false
        if (orderType != other.orderType) return false
        if (outpostId != other.outpostId) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.outposts.model.OrderSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The status of all line items in the order.
         */
        public var lineItemCountsByStatus: Map<String, Int>? = null
        /**
         * Fulfilment date for the order.
         */
        public var orderFulfilledDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the order.
         */
        public var orderId: kotlin.String? = null
        /**
         * Submission date for the order.
         */
        public var orderSubmissionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of order.
         */
        public var orderType: aws.sdk.kotlin.services.outposts.model.OrderType? = null
        /**
         * The ID of the Outpost.
         */
        public var outpostId: kotlin.String? = null
        /**
         * The status of the order.
         * + `PREPARING` - Order is received and is being prepared.
         * + `IN_PROGRESS` - Order is either being built, shipped, or installed. For more information, see the `LineItem` status.
         * + `COMPLETED` - Order is complete.
         * + `CANCELLED` - Order is cancelled.
         * + `ERROR` - Customer should contact support.
         *
         * The following statuses are deprecated: `RECEIVED`, `PENDING`, `PROCESSING`, `INSTALLING`, and `FULFILLED`.
         */
        public var status: aws.sdk.kotlin.services.outposts.model.OrderStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.outposts.model.OrderSummary) : this() {
            this.lineItemCountsByStatus = x.lineItemCountsByStatus
            this.orderFulfilledDate = x.orderFulfilledDate
            this.orderId = x.orderId
            this.orderSubmissionDate = x.orderSubmissionDate
            this.orderType = x.orderType
            this.outpostId = x.outpostId
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.outposts.model.OrderSummary = OrderSummary(this)
    }
}
