// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A truncated version of the [BatchInferenceJob](https://docs.aws.amazon.com/personalize/latest/dg/API_BatchInferenceJob.html). The [ListBatchInferenceJobs](https://docs.aws.amazon.com/personalize/latest/dg/API_ListBatchInferenceJobs.html) operation returns a list of batch inference job summaries.
 */
class BatchInferenceJobSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the batch inference job.
     */
    val batchInferenceJobArn: kotlin.String? = builder.batchInferenceJobArn
    /**
     * The time at which the batch inference job was created.
     */
    val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * If the batch inference job failed, the reason for the failure.
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * The name of the batch inference job.
     */
    val jobName: kotlin.String? = builder.jobName
    /**
     * The time at which the batch inference job was last updated.
     */
    val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The ARN of the solution version used by the batch inference job.
     */
    val solutionVersionArn: kotlin.String? = builder.solutionVersionArn
    /**
     * The status of the batch inference job. The status is one of the following values:
     * + PENDING
     * + IN PROGRESS
     * + ACTIVE
     * + CREATE FAILED
     */
    val status: kotlin.String? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.BatchInferenceJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchInferenceJobSummary(")
        append("batchInferenceJobArn=$batchInferenceJobArn,")
        append("creationDateTime=$creationDateTime,")
        append("failureReason=$failureReason,")
        append("jobName=$jobName,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("solutionVersionArn=$solutionVersionArn,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchInferenceJobArn?.hashCode() ?: 0
        result = 31 * result + (creationDateTime?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (solutionVersionArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchInferenceJobSummary

        if (batchInferenceJobArn != other.batchInferenceJobArn) return false
        if (creationDateTime != other.creationDateTime) return false
        if (failureReason != other.failureReason) return false
        if (jobName != other.jobName) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (solutionVersionArn != other.solutionVersionArn) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.BatchInferenceJobSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the batch inference job.
         */
        var batchInferenceJobArn: kotlin.String? = null
        /**
         * The time at which the batch inference job was created.
         */
        var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If the batch inference job failed, the reason for the failure.
         */
        var failureReason: kotlin.String? = null
        /**
         * The name of the batch inference job.
         */
        var jobName: kotlin.String? = null
        /**
         * The time at which the batch inference job was last updated.
         */
        var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the solution version used by the batch inference job.
         */
        var solutionVersionArn: kotlin.String? = null
        /**
         * The status of the batch inference job. The status is one of the following values:
         * + PENDING
         * + IN PROGRESS
         * + ACTIVE
         * + CREATE FAILED
         */
        var status: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobSummary) : this() {
            this.batchInferenceJobArn = x.batchInferenceJobArn
            this.creationDateTime = x.creationDateTime
            this.failureReason = x.failureReason
            this.jobName = x.jobName
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.solutionVersionArn = x.solutionVersionArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.BatchInferenceJobSummary = BatchInferenceJobSummary(this)
    }
}
