// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object that describes the deployment of a solution version. For more information on campaigns, see [CreateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html).
 */
class Campaign private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the campaign.
     */
    val campaignArn: kotlin.String? = builder.campaignArn
    /**
     * The configuration details of a campaign.
     */
    val campaignConfig: aws.sdk.kotlin.services.personalize.model.CampaignConfig? = builder.campaignConfig
    /**
     * The date and time (in Unix format) that the campaign was created.
     */
    val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * If a campaign fails, the reason behind the failure.
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * The date and time (in Unix format) that the campaign was last updated.
     */
    val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * Provides a summary of the properties of a campaign update. For a complete listing, call the [DescribeCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html) API.
     */
    val latestCampaignUpdate: aws.sdk.kotlin.services.personalize.model.CampaignUpdateSummary? = builder.latestCampaignUpdate
    /**
     * Specifies the requested minimum provisioned transactions (recommendations) per second.
     */
    val minProvisionedTps: kotlin.Int? = builder.minProvisionedTps
    /**
     * The name of the campaign.
     */
    val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of a specific version of the solution.
     */
    val solutionVersionArn: kotlin.String? = builder.solutionVersionArn
    /**
     * The status of the campaign.
     *
     * A campaign can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     */
    val status: kotlin.String? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.Campaign = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Campaign(")
        append("campaignArn=$campaignArn,")
        append("campaignConfig=$campaignConfig,")
        append("creationDateTime=$creationDateTime,")
        append("failureReason=$failureReason,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("latestCampaignUpdate=$latestCampaignUpdate,")
        append("minProvisionedTps=$minProvisionedTps,")
        append("name=$name,")
        append("solutionVersionArn=$solutionVersionArn,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = campaignArn?.hashCode() ?: 0
        result = 31 * result + (campaignConfig?.hashCode() ?: 0)
        result = 31 * result + (creationDateTime?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (latestCampaignUpdate?.hashCode() ?: 0)
        result = 31 * result + (minProvisionedTps ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (solutionVersionArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Campaign

        if (campaignArn != other.campaignArn) return false
        if (campaignConfig != other.campaignConfig) return false
        if (creationDateTime != other.creationDateTime) return false
        if (failureReason != other.failureReason) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (latestCampaignUpdate != other.latestCampaignUpdate) return false
        if (minProvisionedTps != other.minProvisionedTps) return false
        if (name != other.name) return false
        if (solutionVersionArn != other.solutionVersionArn) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.Campaign = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the campaign.
         */
        var campaignArn: kotlin.String? = null
        /**
         * The configuration details of a campaign.
         */
        var campaignConfig: aws.sdk.kotlin.services.personalize.model.CampaignConfig? = null
        /**
         * The date and time (in Unix format) that the campaign was created.
         */
        var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If a campaign fails, the reason behind the failure.
         */
        var failureReason: kotlin.String? = null
        /**
         * The date and time (in Unix format) that the campaign was last updated.
         */
        var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Provides a summary of the properties of a campaign update. For a complete listing, call the [DescribeCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html) API.
         */
        var latestCampaignUpdate: aws.sdk.kotlin.services.personalize.model.CampaignUpdateSummary? = null
        /**
         * Specifies the requested minimum provisioned transactions (recommendations) per second.
         */
        var minProvisionedTps: kotlin.Int? = null
        /**
         * The name of the campaign.
         */
        var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of a specific version of the solution.
         */
        var solutionVersionArn: kotlin.String? = null
        /**
         * The status of the campaign.
         *
         * A campaign can be in one of the following states:
         * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
         * + DELETE PENDING > DELETE IN_PROGRESS
         */
        var status: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.Campaign) : this() {
            this.campaignArn = x.campaignArn
            this.campaignConfig = x.campaignConfig
            this.creationDateTime = x.creationDateTime
            this.failureReason = x.failureReason
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.latestCampaignUpdate = x.latestCampaignUpdate
            this.minProvisionedTps = x.minProvisionedTps
            this.name = x.name
            this.solutionVersionArn = x.solutionVersionArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.Campaign = Campaign(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.CampaignConfig] inside the given [block]
         */
        fun campaignConfig(block: aws.sdk.kotlin.services.personalize.model.CampaignConfig.Builder.() -> kotlin.Unit) {
            this.campaignConfig = aws.sdk.kotlin.services.personalize.model.CampaignConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.CampaignUpdateSummary] inside the given [block]
         */
        fun latestCampaignUpdate(block: aws.sdk.kotlin.services.personalize.model.CampaignUpdateSummary.Builder.() -> kotlin.Unit) {
            this.latestCampaignUpdate = aws.sdk.kotlin.services.personalize.model.CampaignUpdateSummary.invoke(block)
        }
    }
}
