// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model



class CreateDatasetGroupRequest private constructor(builder: Builder) {
    /**
     * The domain of the dataset group. Specify a domain to create a Domain dataset group. The domain you specify determines the default schemas for datasets and the use cases available for recommenders. If you don't specify a domain, you create a Custom dataset group with solution versions that you deploy with a campaign.
     */
    val domain: aws.sdk.kotlin.services.personalize.model.Domain? = builder.domain
    /**
     * The Amazon Resource Name (ARN) of a Key Management Service (KMS) key used to encrypt the datasets.
     */
    val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The name for the new dataset group.
     */
    val name: kotlin.String? = builder.name
    /**
     * The ARN of the Identity and Access Management (IAM) role that has permissions to access the Key Management Service (KMS) key. Supplying an IAM role is only valid when also specifying a KMS key.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * A list of [tags](https://docs.aws.amazon.com/personalize/latest/dev/tagging-resources.html) to apply to the dataset group.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.CreateDatasetGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDatasetGroupRequest(")
        append("domain=$domain,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domain?.hashCode() ?: 0
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDatasetGroupRequest

        if (domain != other.domain) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.CreateDatasetGroupRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The domain of the dataset group. Specify a domain to create a Domain dataset group. The domain you specify determines the default schemas for datasets and the use cases available for recommenders. If you don't specify a domain, you create a Custom dataset group with solution versions that you deploy with a campaign.
         */
        var domain: aws.sdk.kotlin.services.personalize.model.Domain? = null
        /**
         * The Amazon Resource Name (ARN) of a Key Management Service (KMS) key used to encrypt the datasets.
         */
        var kmsKeyArn: kotlin.String? = null
        /**
         * The name for the new dataset group.
         */
        var name: kotlin.String? = null
        /**
         * The ARN of the Identity and Access Management (IAM) role that has permissions to access the Key Management Service (KMS) key. Supplying an IAM role is only valid when also specifying a KMS key.
         */
        var roleArn: kotlin.String? = null
        /**
         * A list of [tags](https://docs.aws.amazon.com/personalize/latest/dev/tagging-resources.html) to apply to the dataset group.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.CreateDatasetGroupRequest) : this() {
            this.domain = x.domain
            this.kmsKeyArn = x.kmsKeyArn
            this.name = x.name
            this.roleArn = x.roleArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.CreateDatasetGroupRequest = CreateDatasetGroupRequest(this)
    }
}
