// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model



class CreateSolutionVersionRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the solution containing the training configuration information.
     */
    val solutionArn: kotlin.String? = builder.solutionArn
    /**
     * A list of [tags](https://docs.aws.amazon.com/personalize/latest/dev/tagging-resources.html) to apply to the solution version.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The scope of training to be performed when creating the solution version. The `FULL` option trains the solution version based on the entirety of the input solution's training data, while the `UPDATE` option processes only the data that has changed in comparison to the input solution. Choose `UPDATE` when you want to incrementally update your solution version instead of creating an entirely new one.
     *
     * The `UPDATE` option can only be used when you already have an active solution version created from the input solution using the `FULL` option and the input solution was trained with the [User-Personalization](https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html) recipe or the [HRNN-Coldstart](https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html) recipe.
     */
    val trainingMode: aws.sdk.kotlin.services.personalize.model.TrainingMode? = builder.trainingMode

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.CreateSolutionVersionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSolutionVersionRequest(")
        append("solutionArn=$solutionArn,")
        append("tags=$tags,")
        append("trainingMode=$trainingMode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = solutionArn?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (trainingMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSolutionVersionRequest

        if (solutionArn != other.solutionArn) return false
        if (tags != other.tags) return false
        if (trainingMode != other.trainingMode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.CreateSolutionVersionRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the solution containing the training configuration information.
         */
        var solutionArn: kotlin.String? = null
        /**
         * A list of [tags](https://docs.aws.amazon.com/personalize/latest/dev/tagging-resources.html) to apply to the solution version.
         */
        var tags: List<Tag>? = null
        /**
         * The scope of training to be performed when creating the solution version. The `FULL` option trains the solution version based on the entirety of the input solution's training data, while the `UPDATE` option processes only the data that has changed in comparison to the input solution. Choose `UPDATE` when you want to incrementally update your solution version instead of creating an entirely new one.
         *
         * The `UPDATE` option can only be used when you already have an active solution version created from the input solution using the `FULL` option and the input solution was trained with the [User-Personalization](https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html) recipe or the [HRNN-Coldstart](https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html) recipe.
         */
        var trainingMode: aws.sdk.kotlin.services.personalize.model.TrainingMode? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.CreateSolutionVersionRequest) : this() {
            this.solutionArn = x.solutionArn
            this.tags = x.tags
            this.trainingMode = x.trainingMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.CreateSolutionVersionRequest = CreateSolutionVersionRequest(this)
    }
}
