// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a job that exports a dataset to an Amazon S3 bucket. For more information, see [CreateDatasetExportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html).
 *
 * A dataset export job can be in one of the following states:
 * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
 */
class DatasetExportJob private constructor(builder: Builder) {
    /**
     * The creation date and time (in Unix time) of the dataset export job.
     */
    val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The Amazon Resource Name (ARN) of the dataset to export.
     */
    val datasetArn: kotlin.String? = builder.datasetArn
    /**
     * The Amazon Resource Name (ARN) of the dataset export job.
     */
    val datasetExportJobArn: kotlin.String? = builder.datasetExportJobArn
    /**
     * If a dataset export job fails, provides the reason why.
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * The data to export, based on how you imported the data. You can choose to export `BULK` data that you imported using a dataset import job, `PUT` data that you imported incrementally (using the console, PutEvents, PutUsers and PutItems operations), or `ALL` for both types. The default value is `PUT`.
     */
    val ingestionMode: aws.sdk.kotlin.services.personalize.model.IngestionMode? = builder.ingestionMode
    /**
     * The name of the export job.
     */
    val jobName: kotlin.String? = builder.jobName
    /**
     * The path to the Amazon S3 bucket where the job's output is stored. For example:
     *
     * `s3://bucket-name/folder-name/`
     */
    val jobOutput: aws.sdk.kotlin.services.personalize.model.DatasetExportJobOutput? = builder.jobOutput
    /**
     * The date and time (in Unix time) the status of the dataset export job was last updated.
     */
    val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The Amazon Resource Name (ARN) of the IAM service role that has permissions to add data to your output Amazon S3 bucket.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The status of the dataset export job.
     *
     * A dataset export job can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     */
    val status: kotlin.String? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.DatasetExportJob = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatasetExportJob(")
        append("creationDateTime=$creationDateTime,")
        append("datasetArn=$datasetArn,")
        append("datasetExportJobArn=$datasetExportJobArn,")
        append("failureReason=$failureReason,")
        append("ingestionMode=$ingestionMode,")
        append("jobName=$jobName,")
        append("jobOutput=$jobOutput,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("roleArn=$roleArn,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (datasetArn?.hashCode() ?: 0)
        result = 31 * result + (datasetExportJobArn?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (ingestionMode?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (jobOutput?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatasetExportJob

        if (creationDateTime != other.creationDateTime) return false
        if (datasetArn != other.datasetArn) return false
        if (datasetExportJobArn != other.datasetExportJobArn) return false
        if (failureReason != other.failureReason) return false
        if (ingestionMode != other.ingestionMode) return false
        if (jobName != other.jobName) return false
        if (jobOutput != other.jobOutput) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.DatasetExportJob = Builder(this).apply(block).build()

    class Builder {
        /**
         * The creation date and time (in Unix time) of the dataset export job.
         */
        var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the dataset to export.
         */
        var datasetArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the dataset export job.
         */
        var datasetExportJobArn: kotlin.String? = null
        /**
         * If a dataset export job fails, provides the reason why.
         */
        var failureReason: kotlin.String? = null
        /**
         * The data to export, based on how you imported the data. You can choose to export `BULK` data that you imported using a dataset import job, `PUT` data that you imported incrementally (using the console, PutEvents, PutUsers and PutItems operations), or `ALL` for both types. The default value is `PUT`.
         */
        var ingestionMode: aws.sdk.kotlin.services.personalize.model.IngestionMode? = null
        /**
         * The name of the export job.
         */
        var jobName: kotlin.String? = null
        /**
         * The path to the Amazon S3 bucket where the job's output is stored. For example:
         *
         * `s3://bucket-name/folder-name/`
         */
        var jobOutput: aws.sdk.kotlin.services.personalize.model.DatasetExportJobOutput? = null
        /**
         * The date and time (in Unix time) the status of the dataset export job was last updated.
         */
        var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM service role that has permissions to add data to your output Amazon S3 bucket.
         */
        var roleArn: kotlin.String? = null
        /**
         * The status of the dataset export job.
         *
         * A dataset export job can be in one of the following states:
         * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
         */
        var status: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.DatasetExportJob) : this() {
            this.creationDateTime = x.creationDateTime
            this.datasetArn = x.datasetArn
            this.datasetExportJobArn = x.datasetExportJobArn
            this.failureReason = x.failureReason
            this.ingestionMode = x.ingestionMode
            this.jobName = x.jobName
            this.jobOutput = x.jobOutput
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.roleArn = x.roleArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.DatasetExportJob = DatasetExportJob(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.DatasetExportJobOutput] inside the given [block]
         */
        fun jobOutput(block: aws.sdk.kotlin.services.personalize.model.DatasetExportJobOutput.Builder.() -> kotlin.Unit) {
            this.jobOutput = aws.sdk.kotlin.services.personalize.model.DatasetExportJobOutput.invoke(block)
        }
    }
}
