// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.personalize.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.personalize.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Personalize is a machine learning service that makes it easy to add individualized recommendations to customers.
 */
interface PersonalizeClient : SdkClient {

    override val serviceName: String
        get() = "Personalize"
    /**
     * PersonalizeClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): PersonalizeClient {
            val config = Config.Builder().apply(block).build()
            return DefaultPersonalizeClient(config)
        }

        operator fun invoke(config: Config): PersonalizeClient = DefaultPersonalizeClient(config)

        /**
         * Construct a [PersonalizeClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): PersonalizeClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultPersonalizeClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a batch inference job. The operation can handle up to 50 million records and the input file must be in JSON format. For more information, see [Creating a batch inference job](https://docs.aws.amazon.com/personalize/latest/dg/creating-batch-inference-job.html).
     */
    suspend fun createBatchInferenceJob(input: CreateBatchInferenceJobRequest): CreateBatchInferenceJobResponse

    /**
     * Creates a batch inference job. The operation can handle up to 50 million records and the input file must be in JSON format. For more information, see [Creating a batch inference job](https://docs.aws.amazon.com/personalize/latest/dg/creating-batch-inference-job.html).
     */
    suspend fun createBatchInferenceJob(block: CreateBatchInferenceJobRequest.Builder.() -> Unit) = createBatchInferenceJob(CreateBatchInferenceJobRequest.Builder().apply(block).build())

    /**
     * Creates a batch segment job. The operation can handle up to 50 million records and the input file must be in JSON format. For more information, see [Getting batch recommendations and user segments](https://docs.aws.amazon.com/personalize/latest/dg/recommendations-batch.html).
     */
    suspend fun createBatchSegmentJob(input: CreateBatchSegmentJobRequest): CreateBatchSegmentJobResponse

    /**
     * Creates a batch segment job. The operation can handle up to 50 million records and the input file must be in JSON format. For more information, see [Getting batch recommendations and user segments](https://docs.aws.amazon.com/personalize/latest/dg/recommendations-batch.html).
     */
    suspend fun createBatchSegmentJob(block: CreateBatchSegmentJobRequest.Builder.() -> Unit) = createBatchSegmentJob(CreateBatchSegmentJobRequest.Builder().apply(block).build())

    /**
     * Creates a campaign that deploys a solution version. When a client calls the [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) and [GetPersonalizedRanking](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetPersonalizedRanking.html) APIs, a campaign is specified in the request.
     *
     * **Minimum Provisioned TPS and Auto-Scaling**
     *
     * A transaction is a single `GetRecommendations` or `GetPersonalizedRanking` call. Transactions per second (TPS) is the throughput and unit of billing for Amazon Personalize. The minimum provisioned TPS (`minProvisionedTPS`) specifies the baseline throughput provisioned by Amazon Personalize, and thus, the minimum billing charge.
     *
     *  If your TPS increases beyond `minProvisionedTPS`, Amazon Personalize auto-scales the provisioned capacity up and down, but never below `minProvisionedTPS`. There's a short time delay while the capacity is increased that might cause loss of transactions.
     *
     * The actual TPS used is calculated as the average requests/second within a 5-minute window. You pay for maximum of either the minimum provisioned TPS or the actual TPS. We recommend starting with a low `minProvisionedTPS`, track your usage using Amazon CloudWatch metrics, and then increase the `minProvisionedTPS` as necessary.
     *
     * **Status**
     *
     * A campaign can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * To get the campaign status, call [DescribeCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html).
     *
     * Wait until the `status` of the campaign is `ACTIVE` before asking the campaign for recommendations.
     *
     * **Related APIs**
     * + [ListCampaigns](https://docs.aws.amazon.com/personalize/latest/dg/API_ListCampaigns.html)
     * + [DescribeCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html)
     * + [UpdateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateCampaign.html)
     * + [DeleteCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteCampaign.html)
     */
    suspend fun createCampaign(input: CreateCampaignRequest): CreateCampaignResponse

    /**
     * Creates a campaign that deploys a solution version. When a client calls the [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) and [GetPersonalizedRanking](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetPersonalizedRanking.html) APIs, a campaign is specified in the request.
     *
     * **Minimum Provisioned TPS and Auto-Scaling**
     *
     * A transaction is a single `GetRecommendations` or `GetPersonalizedRanking` call. Transactions per second (TPS) is the throughput and unit of billing for Amazon Personalize. The minimum provisioned TPS (`minProvisionedTPS`) specifies the baseline throughput provisioned by Amazon Personalize, and thus, the minimum billing charge.
     *
     *  If your TPS increases beyond `minProvisionedTPS`, Amazon Personalize auto-scales the provisioned capacity up and down, but never below `minProvisionedTPS`. There's a short time delay while the capacity is increased that might cause loss of transactions.
     *
     * The actual TPS used is calculated as the average requests/second within a 5-minute window. You pay for maximum of either the minimum provisioned TPS or the actual TPS. We recommend starting with a low `minProvisionedTPS`, track your usage using Amazon CloudWatch metrics, and then increase the `minProvisionedTPS` as necessary.
     *
     * **Status**
     *
     * A campaign can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * To get the campaign status, call [DescribeCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html).
     *
     * Wait until the `status` of the campaign is `ACTIVE` before asking the campaign for recommendations.
     *
     * **Related APIs**
     * + [ListCampaigns](https://docs.aws.amazon.com/personalize/latest/dg/API_ListCampaigns.html)
     * + [DescribeCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html)
     * + [UpdateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateCampaign.html)
     * + [DeleteCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteCampaign.html)
     */
    suspend fun createCampaign(block: CreateCampaignRequest.Builder.() -> Unit) = createCampaign(CreateCampaignRequest.Builder().apply(block).build())

    /**
     * Creates an empty dataset and adds it to the specified dataset group. Use [CreateDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html) to import your training data to a dataset.
     *
     * There are three types of datasets:
     * + Interactions
     * + Items
     * + Users
     *
     * Each dataset type has an associated schema with required field types. Only the `Interactions` dataset is required in order to train a model (also referred to as creating a solution).
     *
     * A dataset can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * To get the status of the dataset, call [DescribeDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html).
     *
     * **Related APIs**
     * + [CreateDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html)
     * + [ListDatasets](https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasets.html)
     * + [DescribeDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html)
     * + [DeleteDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDataset.html)
     */
    suspend fun createDataset(input: CreateDatasetRequest): CreateDatasetResponse

    /**
     * Creates an empty dataset and adds it to the specified dataset group. Use [CreateDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html) to import your training data to a dataset.
     *
     * There are three types of datasets:
     * + Interactions
     * + Items
     * + Users
     *
     * Each dataset type has an associated schema with required field types. Only the `Interactions` dataset is required in order to train a model (also referred to as creating a solution).
     *
     * A dataset can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * To get the status of the dataset, call [DescribeDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html).
     *
     * **Related APIs**
     * + [CreateDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html)
     * + [ListDatasets](https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasets.html)
     * + [DescribeDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html)
     * + [DeleteDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDataset.html)
     */
    suspend fun createDataset(block: CreateDatasetRequest.Builder.() -> Unit) = createDataset(CreateDatasetRequest.Builder().apply(block).build())

    /**
     * Creates a job that exports data from your dataset to an Amazon S3 bucket. To allow Amazon Personalize to export the training data, you must specify an service-linked IAM role that gives Amazon Personalize `PutObject` permissions for your Amazon S3 bucket. For information, see [Exporting a dataset](https://docs.aws.amazon.com/personalize/latest/dg/export-data.html) in the Amazon Personalize developer guide.
     *
     * **Status**
     *
     * A dataset export job can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     *
     *  To get the status of the export job, call [DescribeDatasetExportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetExportJob.html), and specify the Amazon Resource Name (ARN) of the dataset export job. The dataset export is complete when the status shows as ACTIVE. If the status shows as CREATE FAILED, the response includes a `failureReason` key, which describes why the job failed.
     */
    suspend fun createDatasetExportJob(input: CreateDatasetExportJobRequest): CreateDatasetExportJobResponse

    /**
     * Creates a job that exports data from your dataset to an Amazon S3 bucket. To allow Amazon Personalize to export the training data, you must specify an service-linked IAM role that gives Amazon Personalize `PutObject` permissions for your Amazon S3 bucket. For information, see [Exporting a dataset](https://docs.aws.amazon.com/personalize/latest/dg/export-data.html) in the Amazon Personalize developer guide.
     *
     * **Status**
     *
     * A dataset export job can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     *
     *  To get the status of the export job, call [DescribeDatasetExportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetExportJob.html), and specify the Amazon Resource Name (ARN) of the dataset export job. The dataset export is complete when the status shows as ACTIVE. If the status shows as CREATE FAILED, the response includes a `failureReason` key, which describes why the job failed.
     */
    suspend fun createDatasetExportJob(block: CreateDatasetExportJobRequest.Builder.() -> Unit) = createDatasetExportJob(CreateDatasetExportJobRequest.Builder().apply(block).build())

    /**
     * Creates an empty dataset group. A dataset group is a container for Amazon Personalize resources. A dataset group can contain at most three datasets, one for each type of dataset:
     * + Interactions
     * + Items
     * + Users
     *
     *  A dataset group can be a Domain dataset group, where you specify a domain and use pre-configured resources like recommenders, or a Custom dataset group, where you use custom resources, such as a solution with a solution version, that you deploy with a campaign. If you start with a Domain dataset group, you can still add custom resources such as solutions and solution versions trained with recipes for custom use cases and deployed with campaigns.
     *
     * A dataset group can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING
     *
     * To get the status of the dataset group, call [DescribeDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html). If the status shows as CREATE FAILED, the response includes a `failureReason` key, which describes why the creation failed.
     *
     * You must wait until the `status` of the dataset group is `ACTIVE` before adding a dataset to the group.
     *
     * You can specify an Key Management Service (KMS) key to encrypt the datasets in the group. If you specify a KMS key, you must also include an Identity and Access Management (IAM) role that has permission to access the key.
     *
     * **APIs that require a dataset group ARN in the request**
     * + [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html)
     * + [CreateEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html)
     * + [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html)
     *
     * **Related APIs**
     * + [ListDatasetGroups](https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetGroups.html)
     * + [DescribeDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html)
     * + [DeleteDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDatasetGroup.html)
     */
    suspend fun createDatasetGroup(input: CreateDatasetGroupRequest): CreateDatasetGroupResponse

    /**
     * Creates an empty dataset group. A dataset group is a container for Amazon Personalize resources. A dataset group can contain at most three datasets, one for each type of dataset:
     * + Interactions
     * + Items
     * + Users
     *
     *  A dataset group can be a Domain dataset group, where you specify a domain and use pre-configured resources like recommenders, or a Custom dataset group, where you use custom resources, such as a solution with a solution version, that you deploy with a campaign. If you start with a Domain dataset group, you can still add custom resources such as solutions and solution versions trained with recipes for custom use cases and deployed with campaigns.
     *
     * A dataset group can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING
     *
     * To get the status of the dataset group, call [DescribeDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html). If the status shows as CREATE FAILED, the response includes a `failureReason` key, which describes why the creation failed.
     *
     * You must wait until the `status` of the dataset group is `ACTIVE` before adding a dataset to the group.
     *
     * You can specify an Key Management Service (KMS) key to encrypt the datasets in the group. If you specify a KMS key, you must also include an Identity and Access Management (IAM) role that has permission to access the key.
     *
     * **APIs that require a dataset group ARN in the request**
     * + [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html)
     * + [CreateEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html)
     * + [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html)
     *
     * **Related APIs**
     * + [ListDatasetGroups](https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetGroups.html)
     * + [DescribeDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html)
     * + [DeleteDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDatasetGroup.html)
     */
    suspend fun createDatasetGroup(block: CreateDatasetGroupRequest.Builder.() -> Unit) = createDatasetGroup(CreateDatasetGroupRequest.Builder().apply(block).build())

    /**
     * Creates a job that imports training data from your data source (an Amazon S3 bucket) to an Amazon Personalize dataset. To allow Amazon Personalize to import the training data, you must specify an IAM service role that has permission to read from the data source, as Amazon Personalize makes a copy of your data and processes it internally. For information on granting access to your Amazon S3 bucket, see [Giving Amazon Personalize Access to Amazon S3 Resources](https://docs.aws.amazon.com/personalize/latest/dg/granting-personalize-s3-access.html).
     *
     * The dataset import job replaces any existing data in the dataset that you imported in bulk.
     *
     * **Status**
     *
     * A dataset import job can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     *
     * To get the status of the import job, call [DescribeDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html), providing the Amazon Resource Name (ARN) of the dataset import job. The dataset import is complete when the status shows as ACTIVE. If the status shows as CREATE FAILED, the response includes a `failureReason` key, which describes why the job failed.
     *
     * Importing takes time. You must wait until the status shows as ACTIVE before training a model using the dataset.
     *
     * **Related APIs**
     * + [ListDatasetImportJobs](https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetImportJobs.html)
     * + [DescribeDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html)
     */
    suspend fun createDatasetImportJob(input: CreateDatasetImportJobRequest): CreateDatasetImportJobResponse

    /**
     * Creates a job that imports training data from your data source (an Amazon S3 bucket) to an Amazon Personalize dataset. To allow Amazon Personalize to import the training data, you must specify an IAM service role that has permission to read from the data source, as Amazon Personalize makes a copy of your data and processes it internally. For information on granting access to your Amazon S3 bucket, see [Giving Amazon Personalize Access to Amazon S3 Resources](https://docs.aws.amazon.com/personalize/latest/dg/granting-personalize-s3-access.html).
     *
     * The dataset import job replaces any existing data in the dataset that you imported in bulk.
     *
     * **Status**
     *
     * A dataset import job can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     *
     * To get the status of the import job, call [DescribeDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html), providing the Amazon Resource Name (ARN) of the dataset import job. The dataset import is complete when the status shows as ACTIVE. If the status shows as CREATE FAILED, the response includes a `failureReason` key, which describes why the job failed.
     *
     * Importing takes time. You must wait until the status shows as ACTIVE before training a model using the dataset.
     *
     * **Related APIs**
     * + [ListDatasetImportJobs](https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetImportJobs.html)
     * + [DescribeDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html)
     */
    suspend fun createDatasetImportJob(block: CreateDatasetImportJobRequest.Builder.() -> Unit) = createDatasetImportJob(CreateDatasetImportJobRequest.Builder().apply(block).build())

    /**
     * Creates an event tracker that you use when adding event data to a specified dataset group using the [PutEvents](https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html) API.
     *
     * Only one event tracker can be associated with a dataset group. You will get an error if you call `CreateEventTracker` using the same dataset group as an existing event tracker.
     *
     * When you create an event tracker, the response includes a tracking ID, which you pass as a parameter when you use the [PutEvents](https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html) operation. Amazon Personalize then appends the event data to the Interactions dataset of the dataset group you specify in your event tracker.
     *
     * The event tracker can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * To get the status of the event tracker, call [DescribeEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html).
     *
     * The event tracker must be in the ACTIVE state before using the tracking ID.
     *
     * **Related APIs**
     * + [ListEventTrackers](https://docs.aws.amazon.com/personalize/latest/dg/API_ListEventTrackers.html)
     * + [DescribeEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html)
     * + [DeleteEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteEventTracker.html)
     */
    suspend fun createEventTracker(input: CreateEventTrackerRequest): CreateEventTrackerResponse

    /**
     * Creates an event tracker that you use when adding event data to a specified dataset group using the [PutEvents](https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html) API.
     *
     * Only one event tracker can be associated with a dataset group. You will get an error if you call `CreateEventTracker` using the same dataset group as an existing event tracker.
     *
     * When you create an event tracker, the response includes a tracking ID, which you pass as a parameter when you use the [PutEvents](https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html) operation. Amazon Personalize then appends the event data to the Interactions dataset of the dataset group you specify in your event tracker.
     *
     * The event tracker can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * To get the status of the event tracker, call [DescribeEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html).
     *
     * The event tracker must be in the ACTIVE state before using the tracking ID.
     *
     * **Related APIs**
     * + [ListEventTrackers](https://docs.aws.amazon.com/personalize/latest/dg/API_ListEventTrackers.html)
     * + [DescribeEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html)
     * + [DeleteEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteEventTracker.html)
     */
    suspend fun createEventTracker(block: CreateEventTrackerRequest.Builder.() -> Unit) = createEventTracker(CreateEventTrackerRequest.Builder().apply(block).build())

    /**
     * Creates a recommendation filter. For more information, see [Filtering recommendations and user segments](https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
     */
    suspend fun createFilter(input: CreateFilterRequest): CreateFilterResponse

    /**
     * Creates a recommendation filter. For more information, see [Filtering recommendations and user segments](https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
     */
    suspend fun createFilter(block: CreateFilterRequest.Builder.() -> Unit) = createFilter(CreateFilterRequest.Builder().apply(block).build())

    /**
     * Creates a recommender with the recipe (a Domain dataset group use case) you specify. You create recommenders for a Domain dataset group and specify the recommender's Amazon Resource Name (ARN) when you make a [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) request.
     *
     * **Minimum recommendation requests per second**
     *
     * When you create a recommender, you can configure the recommender's minimum recommendation requests per second. The minimum recommendation requests per second (`minRecommendationRequestsPerSecond`) specifies the baseline recommendation request throughput provisioned by Amazon Personalize. The default minRecommendationRequestsPerSecond is `1`. A recommendation request is a single `GetRecommendations` operation. Request throughput is measured in requests per second and Amazon Personalize uses your requests per second to derive your requests per hour and the price of your recommender usage.
     *
     *  If your requests per second increases beyond `minRecommendationRequestsPerSecond`, Amazon Personalize auto-scales the provisioned capacity up and down, but never below `minRecommendationRequestsPerSecond`. There's a short time delay while the capacity is increased that might cause loss of requests.
     *
     *  Your bill is the greater of either the minimum requests per hour (based on minRecommendationRequestsPerSecond) or the actual number of requests. The actual request throughput used is calculated as the average requests/second within a one-hour window. We recommend starting with the default `minRecommendationRequestsPerSecond`, track your usage using Amazon CloudWatch metrics, and then increase the `minRecommendationRequestsPerSecond` as necessary.
     *
     * **Status**
     *
     * A recommender can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + STOP PENDING > STOP IN_PROGRESS > INACTIVE > START PENDING > START IN_PROGRESS > ACTIVE
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * To get the recommender status, call [DescribeRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html).
     *
     * Wait until the `status` of the recommender is `ACTIVE` before asking the recommender for recommendations.
     *
     * **Related APIs**
     * + [ListRecommenders](https://docs.aws.amazon.com/personalize/latest/dg/API_ListRecommenders.html)
     * + [DescribeRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html)
     * + [UpdateRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateRecommender.html)
     * + [DeleteRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteRecommender.html)
     */
    suspend fun createRecommender(input: CreateRecommenderRequest): CreateRecommenderResponse

    /**
     * Creates a recommender with the recipe (a Domain dataset group use case) you specify. You create recommenders for a Domain dataset group and specify the recommender's Amazon Resource Name (ARN) when you make a [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) request.
     *
     * **Minimum recommendation requests per second**
     *
     * When you create a recommender, you can configure the recommender's minimum recommendation requests per second. The minimum recommendation requests per second (`minRecommendationRequestsPerSecond`) specifies the baseline recommendation request throughput provisioned by Amazon Personalize. The default minRecommendationRequestsPerSecond is `1`. A recommendation request is a single `GetRecommendations` operation. Request throughput is measured in requests per second and Amazon Personalize uses your requests per second to derive your requests per hour and the price of your recommender usage.
     *
     *  If your requests per second increases beyond `minRecommendationRequestsPerSecond`, Amazon Personalize auto-scales the provisioned capacity up and down, but never below `minRecommendationRequestsPerSecond`. There's a short time delay while the capacity is increased that might cause loss of requests.
     *
     *  Your bill is the greater of either the minimum requests per hour (based on minRecommendationRequestsPerSecond) or the actual number of requests. The actual request throughput used is calculated as the average requests/second within a one-hour window. We recommend starting with the default `minRecommendationRequestsPerSecond`, track your usage using Amazon CloudWatch metrics, and then increase the `minRecommendationRequestsPerSecond` as necessary.
     *
     * **Status**
     *
     * A recommender can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + STOP PENDING > STOP IN_PROGRESS > INACTIVE > START PENDING > START IN_PROGRESS > ACTIVE
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * To get the recommender status, call [DescribeRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html).
     *
     * Wait until the `status` of the recommender is `ACTIVE` before asking the recommender for recommendations.
     *
     * **Related APIs**
     * + [ListRecommenders](https://docs.aws.amazon.com/personalize/latest/dg/API_ListRecommenders.html)
     * + [DescribeRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html)
     * + [UpdateRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateRecommender.html)
     * + [DeleteRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteRecommender.html)
     */
    suspend fun createRecommender(block: CreateRecommenderRequest.Builder.() -> Unit) = createRecommender(CreateRecommenderRequest.Builder().apply(block).build())

    /**
     * Creates an Amazon Personalize schema from the specified schema string. The schema you create must be in Avro JSON format.
     *
     * Amazon Personalize recognizes three schema variants. Each schema is associated with a dataset type and has a set of required field and keywords. If you are creating a schema for a dataset in a Domain dataset group, you provide the domain of the Domain dataset group. You specify a schema when you call [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
     *
     * **Related APIs**
     * + [ListSchemas](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSchemas.html)
     * + [DescribeSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSchema.html)
     * + [DeleteSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSchema.html)
     */
    suspend fun createSchema(input: CreateSchemaRequest): CreateSchemaResponse

    /**
     * Creates an Amazon Personalize schema from the specified schema string. The schema you create must be in Avro JSON format.
     *
     * Amazon Personalize recognizes three schema variants. Each schema is associated with a dataset type and has a set of required field and keywords. If you are creating a schema for a dataset in a Domain dataset group, you provide the domain of the Domain dataset group. You specify a schema when you call [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
     *
     * **Related APIs**
     * + [ListSchemas](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSchemas.html)
     * + [DescribeSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSchema.html)
     * + [DeleteSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSchema.html)
     */
    suspend fun createSchema(block: CreateSchemaRequest.Builder.() -> Unit) = createSchema(CreateSchemaRequest.Builder().apply(block).build())

    /**
     * Creates the configuration for training a model. A trained model is known as a solution. After the configuration is created, you train the model (create a solution) by calling the [CreateSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolutionVersion.html) operation. Every time you call `CreateSolutionVersion`, a new version of the solution is created.
     *
     * After creating a solution version, you check its accuracy by calling [GetSolutionMetrics](https://docs.aws.amazon.com/personalize/latest/dg/API_GetSolutionMetrics.html). When you are satisfied with the version, you deploy it using [CreateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html). The campaign provides recommendations to a client through the [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) API.
     *
     * To train a model, Amazon Personalize requires training data and a recipe. The training data comes from the dataset group that you provide in the request. A recipe specifies the training algorithm and a feature transformation. You can specify one of the predefined recipes provided by Amazon Personalize. Alternatively, you can specify `performAutoML` and Amazon Personalize will analyze your data and select the optimum USER_PERSONALIZATION recipe for you.
     *
     * Amazon Personalize doesn't support configuring the `hpoObjective` for solution hyperparameter optimization at this time.
     *
     * **Status**
     *
     * A solution can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * To get the status of the solution, call [DescribeSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html). Wait until the status shows as ACTIVE before calling `CreateSolutionVersion`.
     *
     * **Related APIs**
     * + [ListSolutions](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutions.html)
     * + [CreateSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolutionVersion.html)
     * + [DescribeSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html)
     * + [DeleteSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSolution.html)
     *
     * + [ListSolutionVersions](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html)
     * + [DescribeSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html)
     */
    suspend fun createSolution(input: CreateSolutionRequest): CreateSolutionResponse

    /**
     * Creates the configuration for training a model. A trained model is known as a solution. After the configuration is created, you train the model (create a solution) by calling the [CreateSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolutionVersion.html) operation. Every time you call `CreateSolutionVersion`, a new version of the solution is created.
     *
     * After creating a solution version, you check its accuracy by calling [GetSolutionMetrics](https://docs.aws.amazon.com/personalize/latest/dg/API_GetSolutionMetrics.html). When you are satisfied with the version, you deploy it using [CreateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html). The campaign provides recommendations to a client through the [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) API.
     *
     * To train a model, Amazon Personalize requires training data and a recipe. The training data comes from the dataset group that you provide in the request. A recipe specifies the training algorithm and a feature transformation. You can specify one of the predefined recipes provided by Amazon Personalize. Alternatively, you can specify `performAutoML` and Amazon Personalize will analyze your data and select the optimum USER_PERSONALIZATION recipe for you.
     *
     * Amazon Personalize doesn't support configuring the `hpoObjective` for solution hyperparameter optimization at this time.
     *
     * **Status**
     *
     * A solution can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * To get the status of the solution, call [DescribeSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html). Wait until the status shows as ACTIVE before calling `CreateSolutionVersion`.
     *
     * **Related APIs**
     * + [ListSolutions](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutions.html)
     * + [CreateSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolutionVersion.html)
     * + [DescribeSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html)
     * + [DeleteSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSolution.html)
     *
     * + [ListSolutionVersions](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html)
     * + [DescribeSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html)
     */
    suspend fun createSolution(block: CreateSolutionRequest.Builder.() -> Unit) = createSolution(CreateSolutionRequest.Builder().apply(block).build())

    /**
     * Trains or retrains an active solution in a Custom dataset group. A solution is created using the [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html) operation and must be in the ACTIVE state before calling `CreateSolutionVersion`. A new version of the solution is created every time you call this operation.
     *
     * **Status**
     *
     * A solution version can be in one of the following states:
     * + CREATE PENDING
     * + CREATE IN_PROGRESS
     * + ACTIVE
     * + CREATE FAILED
     * + CREATE STOPPING
     * + CREATE STOPPED
     *
     * To get the status of the version, call [DescribeSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html). Wait until the status shows as ACTIVE before calling `CreateCampaign`.
     *
     * If the status shows as CREATE FAILED, the response includes a `failureReason` key, which describes why the job failed.
     *
     * **Related APIs**
     * + [ListSolutionVersions](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html)
     * + [DescribeSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html)
     * + [ListSolutions](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutions.html)
     * + [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html)
     * + [DescribeSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html)
     * + [DeleteSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSolution.html)
     */
    suspend fun createSolutionVersion(input: CreateSolutionVersionRequest): CreateSolutionVersionResponse

    /**
     * Trains or retrains an active solution in a Custom dataset group. A solution is created using the [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html) operation and must be in the ACTIVE state before calling `CreateSolutionVersion`. A new version of the solution is created every time you call this operation.
     *
     * **Status**
     *
     * A solution version can be in one of the following states:
     * + CREATE PENDING
     * + CREATE IN_PROGRESS
     * + ACTIVE
     * + CREATE FAILED
     * + CREATE STOPPING
     * + CREATE STOPPED
     *
     * To get the status of the version, call [DescribeSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html). Wait until the status shows as ACTIVE before calling `CreateCampaign`.
     *
     * If the status shows as CREATE FAILED, the response includes a `failureReason` key, which describes why the job failed.
     *
     * **Related APIs**
     * + [ListSolutionVersions](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html)
     * + [DescribeSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html)
     * + [ListSolutions](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutions.html)
     * + [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html)
     * + [DescribeSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html)
     * + [DeleteSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSolution.html)
     */
    suspend fun createSolutionVersion(block: CreateSolutionVersionRequest.Builder.() -> Unit) = createSolutionVersion(CreateSolutionVersionRequest.Builder().apply(block).build())

    /**
     * Removes a campaign by deleting the solution deployment. The solution that the campaign is based on is not deleted and can be redeployed when needed. A deleted campaign can no longer be specified in a [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) request. For information on creating campaigns, see [CreateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html).
     */
    suspend fun deleteCampaign(input: DeleteCampaignRequest): DeleteCampaignResponse

    /**
     * Removes a campaign by deleting the solution deployment. The solution that the campaign is based on is not deleted and can be redeployed when needed. A deleted campaign can no longer be specified in a [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) request. For information on creating campaigns, see [CreateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html).
     */
    suspend fun deleteCampaign(block: DeleteCampaignRequest.Builder.() -> Unit) = deleteCampaign(DeleteCampaignRequest.Builder().apply(block).build())

    /**
     * Deletes a dataset. You can't delete a dataset if an associated `DatasetImportJob` or `SolutionVersion` is in the CREATE PENDING or IN PROGRESS state. For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
     */
    suspend fun deleteDataset(input: DeleteDatasetRequest): DeleteDatasetResponse

    /**
     * Deletes a dataset. You can't delete a dataset if an associated `DatasetImportJob` or `SolutionVersion` is in the CREATE PENDING or IN PROGRESS state. For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
     */
    suspend fun deleteDataset(block: DeleteDatasetRequest.Builder.() -> Unit) = deleteDataset(DeleteDatasetRequest.Builder().apply(block).build())

    /**
     * Deletes a dataset group. Before you delete a dataset group, you must delete the following:
     * + All associated event trackers.
     * + All associated solutions.
     * + All datasets in the dataset group.
     */
    suspend fun deleteDatasetGroup(input: DeleteDatasetGroupRequest): DeleteDatasetGroupResponse

    /**
     * Deletes a dataset group. Before you delete a dataset group, you must delete the following:
     * + All associated event trackers.
     * + All associated solutions.
     * + All datasets in the dataset group.
     */
    suspend fun deleteDatasetGroup(block: DeleteDatasetGroupRequest.Builder.() -> Unit) = deleteDatasetGroup(DeleteDatasetGroupRequest.Builder().apply(block).build())

    /**
     * Deletes the event tracker. Does not delete the event-interactions dataset from the associated dataset group. For more information on event trackers, see [CreateEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html).
     */
    suspend fun deleteEventTracker(input: DeleteEventTrackerRequest): DeleteEventTrackerResponse

    /**
     * Deletes the event tracker. Does not delete the event-interactions dataset from the associated dataset group. For more information on event trackers, see [CreateEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html).
     */
    suspend fun deleteEventTracker(block: DeleteEventTrackerRequest.Builder.() -> Unit) = deleteEventTracker(DeleteEventTrackerRequest.Builder().apply(block).build())

    /**
     * Deletes a filter.
     */
    suspend fun deleteFilter(input: DeleteFilterRequest): DeleteFilterResponse

    /**
     * Deletes a filter.
     */
    suspend fun deleteFilter(block: DeleteFilterRequest.Builder.() -> Unit) = deleteFilter(DeleteFilterRequest.Builder().apply(block).build())

    /**
     * Deactivates and removes a recommender. A deleted recommender can no longer be specified in a [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) request.
     */
    suspend fun deleteRecommender(input: DeleteRecommenderRequest): DeleteRecommenderResponse

    /**
     * Deactivates and removes a recommender. A deleted recommender can no longer be specified in a [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) request.
     */
    suspend fun deleteRecommender(block: DeleteRecommenderRequest.Builder.() -> Unit) = deleteRecommender(DeleteRecommenderRequest.Builder().apply(block).build())

    /**
     * Deletes a schema. Before deleting a schema, you must delete all datasets referencing the schema. For more information on schemas, see [CreateSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html).
     */
    suspend fun deleteSchema(input: DeleteSchemaRequest): DeleteSchemaResponse

    /**
     * Deletes a schema. Before deleting a schema, you must delete all datasets referencing the schema. For more information on schemas, see [CreateSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html).
     */
    suspend fun deleteSchema(block: DeleteSchemaRequest.Builder.() -> Unit) = deleteSchema(DeleteSchemaRequest.Builder().apply(block).build())

    /**
     * Deletes all versions of a solution and the `Solution` object itself. Before deleting a solution, you must delete all campaigns based on the solution. To determine what campaigns are using the solution, call [ListCampaigns](https://docs.aws.amazon.com/personalize/latest/dg/API_ListCampaigns.html) and supply the Amazon Resource Name (ARN) of the solution. You can't delete a solution if an associated `SolutionVersion` is in the CREATE PENDING or IN PROGRESS state. For more information on solutions, see [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html).
     */
    suspend fun deleteSolution(input: DeleteSolutionRequest): DeleteSolutionResponse

    /**
     * Deletes all versions of a solution and the `Solution` object itself. Before deleting a solution, you must delete all campaigns based on the solution. To determine what campaigns are using the solution, call [ListCampaigns](https://docs.aws.amazon.com/personalize/latest/dg/API_ListCampaigns.html) and supply the Amazon Resource Name (ARN) of the solution. You can't delete a solution if an associated `SolutionVersion` is in the CREATE PENDING or IN PROGRESS state. For more information on solutions, see [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html).
     */
    suspend fun deleteSolution(block: DeleteSolutionRequest.Builder.() -> Unit) = deleteSolution(DeleteSolutionRequest.Builder().apply(block).build())

    /**
     * Describes the given algorithm.
     */
    suspend fun describeAlgorithm(input: DescribeAlgorithmRequest): DescribeAlgorithmResponse

    /**
     * Describes the given algorithm.
     */
    suspend fun describeAlgorithm(block: DescribeAlgorithmRequest.Builder.() -> Unit) = describeAlgorithm(DescribeAlgorithmRequest.Builder().apply(block).build())

    /**
     * Gets the properties of a batch inference job including name, Amazon Resource Name (ARN), status, input and output configurations, and the ARN of the solution version used to generate the recommendations.
     */
    suspend fun describeBatchInferenceJob(input: DescribeBatchInferenceJobRequest): DescribeBatchInferenceJobResponse

    /**
     * Gets the properties of a batch inference job including name, Amazon Resource Name (ARN), status, input and output configurations, and the ARN of the solution version used to generate the recommendations.
     */
    suspend fun describeBatchInferenceJob(block: DescribeBatchInferenceJobRequest.Builder.() -> Unit) = describeBatchInferenceJob(DescribeBatchInferenceJobRequest.Builder().apply(block).build())

    /**
     * Gets the properties of a batch segment job including name, Amazon Resource Name (ARN), status, input and output configurations, and the ARN of the solution version used to generate segments.
     */
    suspend fun describeBatchSegmentJob(input: DescribeBatchSegmentJobRequest): DescribeBatchSegmentJobResponse

    /**
     * Gets the properties of a batch segment job including name, Amazon Resource Name (ARN), status, input and output configurations, and the ARN of the solution version used to generate segments.
     */
    suspend fun describeBatchSegmentJob(block: DescribeBatchSegmentJobRequest.Builder.() -> Unit) = describeBatchSegmentJob(DescribeBatchSegmentJobRequest.Builder().apply(block).build())

    /**
     * Describes the given campaign, including its status.
     *
     * A campaign can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * When the `status` is `CREATE FAILED`, the response includes the `failureReason` key, which describes why.
     *
     * For more information on campaigns, see [CreateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html).
     */
    suspend fun describeCampaign(input: DescribeCampaignRequest): DescribeCampaignResponse

    /**
     * Describes the given campaign, including its status.
     *
     * A campaign can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * When the `status` is `CREATE FAILED`, the response includes the `failureReason` key, which describes why.
     *
     * For more information on campaigns, see [CreateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html).
     */
    suspend fun describeCampaign(block: DescribeCampaignRequest.Builder.() -> Unit) = describeCampaign(DescribeCampaignRequest.Builder().apply(block).build())

    /**
     * Describes the given dataset. For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
     */
    suspend fun describeDataset(input: DescribeDatasetRequest): DescribeDatasetResponse

    /**
     * Describes the given dataset. For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
     */
    suspend fun describeDataset(block: DescribeDatasetRequest.Builder.() -> Unit) = describeDataset(DescribeDatasetRequest.Builder().apply(block).build())

    /**
     * Describes the dataset export job created by [CreateDatasetExportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html), including the export job status.
     */
    suspend fun describeDatasetExportJob(input: DescribeDatasetExportJobRequest): DescribeDatasetExportJobResponse

    /**
     * Describes the dataset export job created by [CreateDatasetExportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html), including the export job status.
     */
    suspend fun describeDatasetExportJob(block: DescribeDatasetExportJobRequest.Builder.() -> Unit) = describeDatasetExportJob(DescribeDatasetExportJobRequest.Builder().apply(block).build())

    /**
     * Describes the given dataset group. For more information on dataset groups, see [CreateDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html).
     */
    suspend fun describeDatasetGroup(input: DescribeDatasetGroupRequest): DescribeDatasetGroupResponse

    /**
     * Describes the given dataset group. For more information on dataset groups, see [CreateDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html).
     */
    suspend fun describeDatasetGroup(block: DescribeDatasetGroupRequest.Builder.() -> Unit) = describeDatasetGroup(DescribeDatasetGroupRequest.Builder().apply(block).build())

    /**
     * Describes the dataset import job created by [CreateDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html), including the import job status.
     */
    suspend fun describeDatasetImportJob(input: DescribeDatasetImportJobRequest): DescribeDatasetImportJobResponse

    /**
     * Describes the dataset import job created by [CreateDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html), including the import job status.
     */
    suspend fun describeDatasetImportJob(block: DescribeDatasetImportJobRequest.Builder.() -> Unit) = describeDatasetImportJob(DescribeDatasetImportJobRequest.Builder().apply(block).build())

    /**
     * Describes an event tracker. The response includes the `trackingId` and `status` of the event tracker. For more information on event trackers, see [CreateEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html).
     */
    suspend fun describeEventTracker(input: DescribeEventTrackerRequest): DescribeEventTrackerResponse

    /**
     * Describes an event tracker. The response includes the `trackingId` and `status` of the event tracker. For more information on event trackers, see [CreateEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html).
     */
    suspend fun describeEventTracker(block: DescribeEventTrackerRequest.Builder.() -> Unit) = describeEventTracker(DescribeEventTrackerRequest.Builder().apply(block).build())

    /**
     * Describes the given feature transformation.
     */
    suspend fun describeFeatureTransformation(input: DescribeFeatureTransformationRequest): DescribeFeatureTransformationResponse

    /**
     * Describes the given feature transformation.
     */
    suspend fun describeFeatureTransformation(block: DescribeFeatureTransformationRequest.Builder.() -> Unit) = describeFeatureTransformation(DescribeFeatureTransformationRequest.Builder().apply(block).build())

    /**
     * Describes a filter's properties.
     */
    suspend fun describeFilter(input: DescribeFilterRequest): DescribeFilterResponse

    /**
     * Describes a filter's properties.
     */
    suspend fun describeFilter(block: DescribeFilterRequest.Builder.() -> Unit) = describeFilter(DescribeFilterRequest.Builder().apply(block).build())

    /**
     * Describes a recipe.
     *
     * A recipe contains three items:
     * + An algorithm that trains a model.
     * + Hyperparameters that govern the training.
     * + Feature transformation information for modifying the input data before training.
     *
     * Amazon Personalize provides a set of predefined recipes. You specify a recipe when you create a solution with the [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html) API. `CreateSolution` trains a model by using the algorithm in the specified recipe and a training dataset. The solution, when deployed as a campaign, can provide recommendations using the [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) API.
     */
    suspend fun describeRecipe(input: DescribeRecipeRequest): DescribeRecipeResponse

    /**
     * Describes a recipe.
     *
     * A recipe contains three items:
     * + An algorithm that trains a model.
     * + Hyperparameters that govern the training.
     * + Feature transformation information for modifying the input data before training.
     *
     * Amazon Personalize provides a set of predefined recipes. You specify a recipe when you create a solution with the [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html) API. `CreateSolution` trains a model by using the algorithm in the specified recipe and a training dataset. The solution, when deployed as a campaign, can provide recommendations using the [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) API.
     */
    suspend fun describeRecipe(block: DescribeRecipeRequest.Builder.() -> Unit) = describeRecipe(DescribeRecipeRequest.Builder().apply(block).build())

    /**
     * Describes the given recommender, including its status.
     *
     * A recommender can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + STOP PENDING > STOP IN_PROGRESS > INACTIVE > START PENDING > START IN_PROGRESS > ACTIVE
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * When the `status` is `CREATE FAILED`, the response includes the `failureReason` key, which describes why.
     *
     * The `modelMetrics` key is null when the recommender is being created or deleted.
     *
     * For more information on recommenders, see [CreateRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html).
     */
    suspend fun describeRecommender(input: DescribeRecommenderRequest): DescribeRecommenderResponse

    /**
     * Describes the given recommender, including its status.
     *
     * A recommender can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + STOP PENDING > STOP IN_PROGRESS > INACTIVE > START PENDING > START IN_PROGRESS > ACTIVE
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * When the `status` is `CREATE FAILED`, the response includes the `failureReason` key, which describes why.
     *
     * The `modelMetrics` key is null when the recommender is being created or deleted.
     *
     * For more information on recommenders, see [CreateRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html).
     */
    suspend fun describeRecommender(block: DescribeRecommenderRequest.Builder.() -> Unit) = describeRecommender(DescribeRecommenderRequest.Builder().apply(block).build())

    /**
     * Describes a schema. For more information on schemas, see [CreateSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html).
     */
    suspend fun describeSchema(input: DescribeSchemaRequest): DescribeSchemaResponse

    /**
     * Describes a schema. For more information on schemas, see [CreateSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html).
     */
    suspend fun describeSchema(block: DescribeSchemaRequest.Builder.() -> Unit) = describeSchema(DescribeSchemaRequest.Builder().apply(block).build())

    /**
     * Describes a solution. For more information on solutions, see [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html).
     */
    suspend fun describeSolution(input: DescribeSolutionRequest): DescribeSolutionResponse

    /**
     * Describes a solution. For more information on solutions, see [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html).
     */
    suspend fun describeSolution(block: DescribeSolutionRequest.Builder.() -> Unit) = describeSolution(DescribeSolutionRequest.Builder().apply(block).build())

    /**
     * Describes a specific version of a solution. For more information on solutions, see [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html)
     */
    suspend fun describeSolutionVersion(input: DescribeSolutionVersionRequest): DescribeSolutionVersionResponse

    /**
     * Describes a specific version of a solution. For more information on solutions, see [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html)
     */
    suspend fun describeSolutionVersion(block: DescribeSolutionVersionRequest.Builder.() -> Unit) = describeSolutionVersion(DescribeSolutionVersionRequest.Builder().apply(block).build())

    /**
     * Gets the metrics for the specified solution version.
     */
    suspend fun getSolutionMetrics(input: GetSolutionMetricsRequest): GetSolutionMetricsResponse

    /**
     * Gets the metrics for the specified solution version.
     */
    suspend fun getSolutionMetrics(block: GetSolutionMetricsRequest.Builder.() -> Unit) = getSolutionMetrics(GetSolutionMetricsRequest.Builder().apply(block).build())

    /**
     * Gets a list of the batch inference jobs that have been performed off of a solution version.
     */
    suspend fun listBatchInferenceJobs(input: ListBatchInferenceJobsRequest = ListBatchInferenceJobsRequest {}): ListBatchInferenceJobsResponse

    /**
     * Gets a list of the batch inference jobs that have been performed off of a solution version.
     */
    suspend fun listBatchInferenceJobs(block: ListBatchInferenceJobsRequest.Builder.() -> Unit) = listBatchInferenceJobs(ListBatchInferenceJobsRequest.Builder().apply(block).build())

    /**
     * Gets a list of the batch segment jobs that have been performed off of a solution version that you specify.
     */
    suspend fun listBatchSegmentJobs(input: ListBatchSegmentJobsRequest = ListBatchSegmentJobsRequest {}): ListBatchSegmentJobsResponse

    /**
     * Gets a list of the batch segment jobs that have been performed off of a solution version that you specify.
     */
    suspend fun listBatchSegmentJobs(block: ListBatchSegmentJobsRequest.Builder.() -> Unit) = listBatchSegmentJobs(ListBatchSegmentJobsRequest.Builder().apply(block).build())

    /**
     * Returns a list of campaigns that use the given solution. When a solution is not specified, all the campaigns associated with the account are listed. The response provides the properties for each campaign, including the Amazon Resource Name (ARN). For more information on campaigns, see [CreateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html).
     */
    suspend fun listCampaigns(input: ListCampaignsRequest = ListCampaignsRequest {}): ListCampaignsResponse

    /**
     * Returns a list of campaigns that use the given solution. When a solution is not specified, all the campaigns associated with the account are listed. The response provides the properties for each campaign, including the Amazon Resource Name (ARN). For more information on campaigns, see [CreateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html).
     */
    suspend fun listCampaigns(block: ListCampaignsRequest.Builder.() -> Unit) = listCampaigns(ListCampaignsRequest.Builder().apply(block).build())

    /**
     * Returns a list of dataset export jobs that use the given dataset. When a dataset is not specified, all the dataset export jobs associated with the account are listed. The response provides the properties for each dataset export job, including the Amazon Resource Name (ARN). For more information on dataset export jobs, see [CreateDatasetExportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html). For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
     */
    suspend fun listDatasetExportJobs(input: ListDatasetExportJobsRequest = ListDatasetExportJobsRequest {}): ListDatasetExportJobsResponse

    /**
     * Returns a list of dataset export jobs that use the given dataset. When a dataset is not specified, all the dataset export jobs associated with the account are listed. The response provides the properties for each dataset export job, including the Amazon Resource Name (ARN). For more information on dataset export jobs, see [CreateDatasetExportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html). For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
     */
    suspend fun listDatasetExportJobs(block: ListDatasetExportJobsRequest.Builder.() -> Unit) = listDatasetExportJobs(ListDatasetExportJobsRequest.Builder().apply(block).build())

    /**
     * Returns a list of dataset groups. The response provides the properties for each dataset group, including the Amazon Resource Name (ARN). For more information on dataset groups, see [CreateDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html).
     */
    suspend fun listDatasetGroups(input: ListDatasetGroupsRequest = ListDatasetGroupsRequest {}): ListDatasetGroupsResponse

    /**
     * Returns a list of dataset groups. The response provides the properties for each dataset group, including the Amazon Resource Name (ARN). For more information on dataset groups, see [CreateDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html).
     */
    suspend fun listDatasetGroups(block: ListDatasetGroupsRequest.Builder.() -> Unit) = listDatasetGroups(ListDatasetGroupsRequest.Builder().apply(block).build())

    /**
     * Returns a list of dataset import jobs that use the given dataset. When a dataset is not specified, all the dataset import jobs associated with the account are listed. The response provides the properties for each dataset import job, including the Amazon Resource Name (ARN). For more information on dataset import jobs, see [CreateDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html). For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
     */
    suspend fun listDatasetImportJobs(input: ListDatasetImportJobsRequest = ListDatasetImportJobsRequest {}): ListDatasetImportJobsResponse

    /**
     * Returns a list of dataset import jobs that use the given dataset. When a dataset is not specified, all the dataset import jobs associated with the account are listed. The response provides the properties for each dataset import job, including the Amazon Resource Name (ARN). For more information on dataset import jobs, see [CreateDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html). For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
     */
    suspend fun listDatasetImportJobs(block: ListDatasetImportJobsRequest.Builder.() -> Unit) = listDatasetImportJobs(ListDatasetImportJobsRequest.Builder().apply(block).build())

    /**
     * Returns the list of datasets contained in the given dataset group. The response provides the properties for each dataset, including the Amazon Resource Name (ARN). For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
     */
    suspend fun listDatasets(input: ListDatasetsRequest = ListDatasetsRequest {}): ListDatasetsResponse

    /**
     * Returns the list of datasets contained in the given dataset group. The response provides the properties for each dataset, including the Amazon Resource Name (ARN). For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
     */
    suspend fun listDatasets(block: ListDatasetsRequest.Builder.() -> Unit) = listDatasets(ListDatasetsRequest.Builder().apply(block).build())

    /**
     * Returns the list of event trackers associated with the account. The response provides the properties for each event tracker, including the Amazon Resource Name (ARN) and tracking ID. For more information on event trackers, see [CreateEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html).
     */
    suspend fun listEventTrackers(input: ListEventTrackersRequest = ListEventTrackersRequest {}): ListEventTrackersResponse

    /**
     * Returns the list of event trackers associated with the account. The response provides the properties for each event tracker, including the Amazon Resource Name (ARN) and tracking ID. For more information on event trackers, see [CreateEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html).
     */
    suspend fun listEventTrackers(block: ListEventTrackersRequest.Builder.() -> Unit) = listEventTrackers(ListEventTrackersRequest.Builder().apply(block).build())

    /**
     * Lists all filters that belong to a given dataset group.
     */
    suspend fun listFilters(input: ListFiltersRequest = ListFiltersRequest {}): ListFiltersResponse

    /**
     * Lists all filters that belong to a given dataset group.
     */
    suspend fun listFilters(block: ListFiltersRequest.Builder.() -> Unit) = listFilters(ListFiltersRequest.Builder().apply(block).build())

    /**
     * Returns a list of available recipes. The response provides the properties for each recipe, including the recipe's Amazon Resource Name (ARN).
     */
    suspend fun listRecipes(input: ListRecipesRequest = ListRecipesRequest {}): ListRecipesResponse

    /**
     * Returns a list of available recipes. The response provides the properties for each recipe, including the recipe's Amazon Resource Name (ARN).
     */
    suspend fun listRecipes(block: ListRecipesRequest.Builder.() -> Unit) = listRecipes(ListRecipesRequest.Builder().apply(block).build())

    /**
     * Returns a list of recommenders in a given Domain dataset group. When a Domain dataset group is not specified, all the recommenders associated with the account are listed. The response provides the properties for each recommender, including the Amazon Resource Name (ARN). For more information on recommenders, see [CreateRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html).
     */
    suspend fun listRecommenders(input: ListRecommendersRequest = ListRecommendersRequest {}): ListRecommendersResponse

    /**
     * Returns a list of recommenders in a given Domain dataset group. When a Domain dataset group is not specified, all the recommenders associated with the account are listed. The response provides the properties for each recommender, including the Amazon Resource Name (ARN). For more information on recommenders, see [CreateRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html).
     */
    suspend fun listRecommenders(block: ListRecommendersRequest.Builder.() -> Unit) = listRecommenders(ListRecommendersRequest.Builder().apply(block).build())

    /**
     * Returns the list of schemas associated with the account. The response provides the properties for each schema, including the Amazon Resource Name (ARN). For more information on schemas, see [CreateSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html).
     */
    suspend fun listSchemas(input: ListSchemasRequest = ListSchemasRequest {}): ListSchemasResponse

    /**
     * Returns the list of schemas associated with the account. The response provides the properties for each schema, including the Amazon Resource Name (ARN). For more information on schemas, see [CreateSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html).
     */
    suspend fun listSchemas(block: ListSchemasRequest.Builder.() -> Unit) = listSchemas(ListSchemasRequest.Builder().apply(block).build())

    /**
     * Returns a list of solution versions for the given solution. When a solution is not specified, all the solution versions associated with the account are listed. The response provides the properties for each solution version, including the Amazon Resource Name (ARN).
     */
    suspend fun listSolutionVersions(input: ListSolutionVersionsRequest = ListSolutionVersionsRequest {}): ListSolutionVersionsResponse

    /**
     * Returns a list of solution versions for the given solution. When a solution is not specified, all the solution versions associated with the account are listed. The response provides the properties for each solution version, including the Amazon Resource Name (ARN).
     */
    suspend fun listSolutionVersions(block: ListSolutionVersionsRequest.Builder.() -> Unit) = listSolutionVersions(ListSolutionVersionsRequest.Builder().apply(block).build())

    /**
     * Returns a list of solutions that use the given dataset group. When a dataset group is not specified, all the solutions associated with the account are listed. The response provides the properties for each solution, including the Amazon Resource Name (ARN). For more information on solutions, see [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html).
     */
    suspend fun listSolutions(input: ListSolutionsRequest = ListSolutionsRequest {}): ListSolutionsResponse

    /**
     * Returns a list of solutions that use the given dataset group. When a dataset group is not specified, all the solutions associated with the account are listed. The response provides the properties for each solution, including the Amazon Resource Name (ARN). For more information on solutions, see [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html).
     */
    suspend fun listSolutions(block: ListSolutionsRequest.Builder.() -> Unit) = listSolutions(ListSolutionsRequest.Builder().apply(block).build())

    /**
     * Get a list of [tags](https://docs.aws.amazon.com/personalize/latest/dev/tagging-resources.html) attached to a resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Get a list of [tags](https://docs.aws.amazon.com/personalize/latest/dev/tagging-resources.html) attached to a resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Starts a recommender that is INACTIVE. Starting a recommender does not create any new models, but resumes billing and automatic retraining for the recommender.
     */
    suspend fun startRecommender(input: StartRecommenderRequest): StartRecommenderResponse

    /**
     * Starts a recommender that is INACTIVE. Starting a recommender does not create any new models, but resumes billing and automatic retraining for the recommender.
     */
    suspend fun startRecommender(block: StartRecommenderRequest.Builder.() -> Unit) = startRecommender(StartRecommenderRequest.Builder().apply(block).build())

    /**
     * Stops a recommender that is ACTIVE. Stopping a recommender halts billing and automatic retraining for the recommender.
     */
    suspend fun stopRecommender(input: StopRecommenderRequest): StopRecommenderResponse

    /**
     * Stops a recommender that is ACTIVE. Stopping a recommender halts billing and automatic retraining for the recommender.
     */
    suspend fun stopRecommender(block: StopRecommenderRequest.Builder.() -> Unit) = stopRecommender(StopRecommenderRequest.Builder().apply(block).build())

    /**
     * Stops creating a solution version that is in a state of CREATE_PENDING or CREATE IN_PROGRESS.
     *
     * Depending on the current state of the solution version, the solution version state changes as follows:
     * + CREATE_PENDING > CREATE_STOPPEDor
     * + CREATE_IN_PROGRESS > CREATE_STOPPING > CREATE_STOPPED
     *
     * You are billed for all of the training completed up until you stop the solution version creation. You cannot resume creating a solution version once it has been stopped.
     */
    suspend fun stopSolutionVersionCreation(input: StopSolutionVersionCreationRequest): StopSolutionVersionCreationResponse

    /**
     * Stops creating a solution version that is in a state of CREATE_PENDING or CREATE IN_PROGRESS.
     *
     * Depending on the current state of the solution version, the solution version state changes as follows:
     * + CREATE_PENDING > CREATE_STOPPEDor
     * + CREATE_IN_PROGRESS > CREATE_STOPPING > CREATE_STOPPED
     *
     * You are billed for all of the training completed up until you stop the solution version creation. You cannot resume creating a solution version once it has been stopped.
     */
    suspend fun stopSolutionVersionCreation(block: StopSolutionVersionCreationRequest.Builder.() -> Unit) = stopSolutionVersionCreation(StopSolutionVersionCreationRequest.Builder().apply(block).build())

    /**
     * Add a list of tags to a resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Add a list of tags to a resource.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Remove [tags](https://docs.aws.amazon.com/personalize/latest/dev/tagging-resources.html) that are attached to a resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Remove [tags](https://docs.aws.amazon.com/personalize/latest/dev/tagging-resources.html) that are attached to a resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates a campaign by either deploying a new solution or changing the value of the campaign's `minProvisionedTPS` parameter.
     *
     * To update a campaign, the campaign status must be ACTIVE or CREATE FAILED. Check the campaign status using the [DescribeCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html) operation.
     *
     * You can still get recommendations from a campaign while an update is in progress. The campaign will use the previous solution version and campaign configuration to generate recommendations until the latest campaign update status is `Active`.
     *
     * For more information on campaigns, see [CreateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html).
     */
    suspend fun updateCampaign(input: UpdateCampaignRequest): UpdateCampaignResponse

    /**
     * Updates a campaign by either deploying a new solution or changing the value of the campaign's `minProvisionedTPS` parameter.
     *
     * To update a campaign, the campaign status must be ACTIVE or CREATE FAILED. Check the campaign status using the [DescribeCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html) operation.
     *
     * You can still get recommendations from a campaign while an update is in progress. The campaign will use the previous solution version and campaign configuration to generate recommendations until the latest campaign update status is `Active`.
     *
     * For more information on campaigns, see [CreateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html).
     */
    suspend fun updateCampaign(block: UpdateCampaignRequest.Builder.() -> Unit) = updateCampaign(UpdateCampaignRequest.Builder().apply(block).build())

    /**
     * Updates the recommender to modify the recommender configuration.
     */
    suspend fun updateRecommender(input: UpdateRecommenderRequest): UpdateRecommenderResponse

    /**
     * Updates the recommender to modify the recommender configuration.
     */
    suspend fun updateRecommender(block: UpdateRecommenderRequest.Builder.() -> Unit) = updateRecommender(UpdateRecommenderRequest.Builder().apply(block).build())
}
