// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A dataset group is a collection of related datasets (Interactions, User, and Item). You create a dataset group by calling [CreateDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html). You then create a dataset and add it to a dataset group by calling [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html). The dataset group is used to create and train a solution by calling [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html). A dataset group can contain only one of each type of dataset.
 *
 * You can specify an Key Management Service (KMS) key to encrypt the datasets in the group.
 */
class DatasetGroup private constructor(builder: Builder) {
    /**
     * The creation date and time (in Unix time) of the dataset group.
     */
    val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The Amazon Resource Name (ARN) of the dataset group.
     */
    val datasetGroupArn: kotlin.String? = builder.datasetGroupArn
    /**
     * The domain of a Domain dataset group.
     */
    val domain: aws.sdk.kotlin.services.personalize.model.Domain? = builder.domain
    /**
     * If creating a dataset group fails, provides the reason why.
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used to encrypt the datasets.
     */
    val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The last update date and time (in Unix time) of the dataset group.
     */
    val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The name of the dataset group.
     */
    val name: kotlin.String? = builder.name
    /**
     * The ARN of the IAM role that has permissions to create the dataset group.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The current status of the dataset group.
     *
     * A dataset group can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING
     */
    val status: kotlin.String? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.DatasetGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatasetGroup(")
        append("creationDateTime=$creationDateTime,")
        append("datasetGroupArn=$datasetGroupArn,")
        append("domain=$domain,")
        append("failureReason=$failureReason,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (datasetGroupArn?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatasetGroup

        if (creationDateTime != other.creationDateTime) return false
        if (datasetGroupArn != other.datasetGroupArn) return false
        if (domain != other.domain) return false
        if (failureReason != other.failureReason) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.DatasetGroup = Builder(this).apply(block).build()

    class Builder {
        /**
         * The creation date and time (in Unix time) of the dataset group.
         */
        var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the dataset group.
         */
        var datasetGroupArn: kotlin.String? = null
        /**
         * The domain of a Domain dataset group.
         */
        var domain: aws.sdk.kotlin.services.personalize.model.Domain? = null
        /**
         * If creating a dataset group fails, provides the reason why.
         */
        var failureReason: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used to encrypt the datasets.
         */
        var kmsKeyArn: kotlin.String? = null
        /**
         * The last update date and time (in Unix time) of the dataset group.
         */
        var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the dataset group.
         */
        var name: kotlin.String? = null
        /**
         * The ARN of the IAM role that has permissions to create the dataset group.
         */
        var roleArn: kotlin.String? = null
        /**
         * The current status of the dataset group.
         *
         * A dataset group can be in one of the following states:
         * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
         * + DELETE PENDING
         */
        var status: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.DatasetGroup) : this() {
            this.creationDateTime = x.creationDateTime
            this.datasetGroupArn = x.datasetGroupArn
            this.domain = x.domain
            this.failureReason = x.failureReason
            this.kmsKeyArn = x.kmsKeyArn
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.name = x.name
            this.roleArn = x.roleArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.DatasetGroup = DatasetGroup(this)
    }
}
