// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a job that imports training data from a data source (Amazon S3 bucket) to an Amazon Personalize dataset. For more information, see [CreateDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html).
 *
 * A dataset import job can be in one of the following states:
 * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
 */
class DatasetImportJob private constructor(builder: Builder) {
    /**
     * The creation date and time (in Unix time) of the dataset import job.
     */
    val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The Amazon S3 bucket that contains the training data to import.
     */
    val dataSource: aws.sdk.kotlin.services.personalize.model.DataSource? = builder.dataSource
    /**
     * The Amazon Resource Name (ARN) of the dataset that receives the imported data.
     */
    val datasetArn: kotlin.String? = builder.datasetArn
    /**
     * The ARN of the dataset import job.
     */
    val datasetImportJobArn: kotlin.String? = builder.datasetImportJobArn
    /**
     * If a dataset import job fails, provides the reason why.
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * The name of the import job.
     */
    val jobName: kotlin.String? = builder.jobName
    /**
     * The date and time (in Unix time) the dataset was last updated.
     */
    val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The ARN of the IAM role that has permissions to read from the Amazon S3 data source.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The status of the dataset import job.
     *
     * A dataset import job can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     */
    val status: kotlin.String? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.DatasetImportJob = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatasetImportJob(")
        append("creationDateTime=$creationDateTime,")
        append("dataSource=$dataSource,")
        append("datasetArn=$datasetArn,")
        append("datasetImportJobArn=$datasetImportJobArn,")
        append("failureReason=$failureReason,")
        append("jobName=$jobName,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("roleArn=$roleArn,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (dataSource?.hashCode() ?: 0)
        result = 31 * result + (datasetArn?.hashCode() ?: 0)
        result = 31 * result + (datasetImportJobArn?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatasetImportJob

        if (creationDateTime != other.creationDateTime) return false
        if (dataSource != other.dataSource) return false
        if (datasetArn != other.datasetArn) return false
        if (datasetImportJobArn != other.datasetImportJobArn) return false
        if (failureReason != other.failureReason) return false
        if (jobName != other.jobName) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.DatasetImportJob = Builder(this).apply(block).build()

    class Builder {
        /**
         * The creation date and time (in Unix time) of the dataset import job.
         */
        var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon S3 bucket that contains the training data to import.
         */
        var dataSource: aws.sdk.kotlin.services.personalize.model.DataSource? = null
        /**
         * The Amazon Resource Name (ARN) of the dataset that receives the imported data.
         */
        var datasetArn: kotlin.String? = null
        /**
         * The ARN of the dataset import job.
         */
        var datasetImportJobArn: kotlin.String? = null
        /**
         * If a dataset import job fails, provides the reason why.
         */
        var failureReason: kotlin.String? = null
        /**
         * The name of the import job.
         */
        var jobName: kotlin.String? = null
        /**
         * The date and time (in Unix time) the dataset was last updated.
         */
        var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the IAM role that has permissions to read from the Amazon S3 data source.
         */
        var roleArn: kotlin.String? = null
        /**
         * The status of the dataset import job.
         *
         * A dataset import job can be in one of the following states:
         * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
         */
        var status: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.DatasetImportJob) : this() {
            this.creationDateTime = x.creationDateTime
            this.dataSource = x.dataSource
            this.datasetArn = x.datasetArn
            this.datasetImportJobArn = x.datasetImportJobArn
            this.failureReason = x.failureReason
            this.jobName = x.jobName
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.roleArn = x.roleArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.DatasetImportJob = DatasetImportJob(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.DataSource] inside the given [block]
         */
        fun dataSource(block: aws.sdk.kotlin.services.personalize.model.DataSource.Builder.() -> kotlin.Unit) {
            this.dataSource = aws.sdk.kotlin.services.personalize.model.DataSource.invoke(block)
        }
    }
}
