// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the schema for a dataset. For more information on schemas, see [CreateSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html).
 */
class DatasetSchema private constructor(builder: Builder) {
    /**
     * The date and time (in Unix time) that the schema was created.
     */
    val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The domain of a schema that you created for a dataset in a Domain dataset group.
     */
    val domain: aws.sdk.kotlin.services.personalize.model.Domain? = builder.domain
    /**
     * The date and time (in Unix time) that the schema was last updated.
     */
    val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The name of the schema.
     */
    val name: kotlin.String? = builder.name
    /**
     * The schema.
     */
    val schema: kotlin.String? = builder.schema
    /**
     * The Amazon Resource Name (ARN) of the schema.
     */
    val schemaArn: kotlin.String? = builder.schemaArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.DatasetSchema = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatasetSchema(")
        append("creationDateTime=$creationDateTime,")
        append("domain=$domain,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("name=$name,")
        append("schema=$schema,")
        append("schemaArn=$schemaArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (schema?.hashCode() ?: 0)
        result = 31 * result + (schemaArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatasetSchema

        if (creationDateTime != other.creationDateTime) return false
        if (domain != other.domain) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (name != other.name) return false
        if (schema != other.schema) return false
        if (schemaArn != other.schemaArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.DatasetSchema = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time (in Unix time) that the schema was created.
         */
        var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The domain of a schema that you created for a dataset in a Domain dataset group.
         */
        var domain: aws.sdk.kotlin.services.personalize.model.Domain? = null
        /**
         * The date and time (in Unix time) that the schema was last updated.
         */
        var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the schema.
         */
        var name: kotlin.String? = null
        /**
         * The schema.
         */
        var schema: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the schema.
         */
        var schemaArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.DatasetSchema) : this() {
            this.creationDateTime = x.creationDateTime
            this.domain = x.domain
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.name = x.name
            this.schema = x.schema
            this.schemaArn = x.schemaArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.DatasetSchema = DatasetSchema(this)
    }
}
