// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about an event tracker.
 */
class EventTracker private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account that owns the event tracker.
     */
    val accountId: kotlin.String? = builder.accountId
    /**
     * The date and time (in Unix format) that the event tracker was created.
     */
    val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The Amazon Resource Name (ARN) of the dataset group that receives the event data.
     */
    val datasetGroupArn: kotlin.String? = builder.datasetGroupArn
    /**
     * The ARN of the event tracker.
     */
    val eventTrackerArn: kotlin.String? = builder.eventTrackerArn
    /**
     * The date and time (in Unix time) that the event tracker was last updated.
     */
    val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The name of the event tracker.
     */
    val name: kotlin.String? = builder.name
    /**
     * The status of the event tracker.
     *
     * An event tracker can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     */
    val status: kotlin.String? = builder.status
    /**
     * The ID of the event tracker. Include this ID in requests to the [PutEvents](https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html) API.
     */
    val trackingId: kotlin.String? = builder.trackingId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.EventTracker = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventTracker(")
        append("accountId=$accountId,")
        append("creationDateTime=$creationDateTime,")
        append("datasetGroupArn=$datasetGroupArn,")
        append("eventTrackerArn=$eventTrackerArn,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("name=$name,")
        append("status=$status,")
        append("trackingId=$trackingId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (creationDateTime?.hashCode() ?: 0)
        result = 31 * result + (datasetGroupArn?.hashCode() ?: 0)
        result = 31 * result + (eventTrackerArn?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (trackingId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventTracker

        if (accountId != other.accountId) return false
        if (creationDateTime != other.creationDateTime) return false
        if (datasetGroupArn != other.datasetGroupArn) return false
        if (eventTrackerArn != other.eventTrackerArn) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (trackingId != other.trackingId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.EventTracker = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Web Services account that owns the event tracker.
         */
        var accountId: kotlin.String? = null
        /**
         * The date and time (in Unix format) that the event tracker was created.
         */
        var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the dataset group that receives the event data.
         */
        var datasetGroupArn: kotlin.String? = null
        /**
         * The ARN of the event tracker.
         */
        var eventTrackerArn: kotlin.String? = null
        /**
         * The date and time (in Unix time) that the event tracker was last updated.
         */
        var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the event tracker.
         */
        var name: kotlin.String? = null
        /**
         * The status of the event tracker.
         *
         * An event tracker can be in one of the following states:
         * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
         * + DELETE PENDING > DELETE IN_PROGRESS
         */
        var status: kotlin.String? = null
        /**
         * The ID of the event tracker. Include this ID in requests to the [PutEvents](https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html) API.
         */
        var trackingId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.EventTracker) : this() {
            this.accountId = x.accountId
            this.creationDateTime = x.creationDateTime
            this.datasetGroupArn = x.datasetGroupArn
            this.eventTrackerArn = x.eventTrackerArn
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.name = x.name
            this.status = x.status
            this.trackingId = x.trackingId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.EventTracker = EventTracker(this)
    }
}
