// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model



/**
 * Describes the properties for hyperparameter optimization (HPO).
 */
class HpoConfig private constructor(builder: Builder) {
    /**
     * The hyperparameters and their allowable ranges.
     */
    val algorithmHyperParameterRanges: aws.sdk.kotlin.services.personalize.model.HyperParameterRanges? = builder.algorithmHyperParameterRanges
    /**
     * The metric to optimize during HPO.
     *
     * Amazon Personalize doesn't support configuring the `hpoObjective` at this time.
     */
    val hpoObjective: aws.sdk.kotlin.services.personalize.model.HpoObjective? = builder.hpoObjective
    /**
     * Describes the resource configuration for HPO.
     */
    val hpoResourceConfig: aws.sdk.kotlin.services.personalize.model.HpoResourceConfig? = builder.hpoResourceConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.HpoConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HpoConfig(")
        append("algorithmHyperParameterRanges=$algorithmHyperParameterRanges,")
        append("hpoObjective=$hpoObjective,")
        append("hpoResourceConfig=$hpoResourceConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithmHyperParameterRanges?.hashCode() ?: 0
        result = 31 * result + (hpoObjective?.hashCode() ?: 0)
        result = 31 * result + (hpoResourceConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HpoConfig

        if (algorithmHyperParameterRanges != other.algorithmHyperParameterRanges) return false
        if (hpoObjective != other.hpoObjective) return false
        if (hpoResourceConfig != other.hpoResourceConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.HpoConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The hyperparameters and their allowable ranges.
         */
        var algorithmHyperParameterRanges: aws.sdk.kotlin.services.personalize.model.HyperParameterRanges? = null
        /**
         * The metric to optimize during HPO.
         *
         * Amazon Personalize doesn't support configuring the `hpoObjective` at this time.
         */
        var hpoObjective: aws.sdk.kotlin.services.personalize.model.HpoObjective? = null
        /**
         * Describes the resource configuration for HPO.
         */
        var hpoResourceConfig: aws.sdk.kotlin.services.personalize.model.HpoResourceConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.HpoConfig) : this() {
            this.algorithmHyperParameterRanges = x.algorithmHyperParameterRanges
            this.hpoObjective = x.hpoObjective
            this.hpoResourceConfig = x.hpoResourceConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.HpoConfig = HpoConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.HyperParameterRanges] inside the given [block]
         */
        fun algorithmHyperParameterRanges(block: aws.sdk.kotlin.services.personalize.model.HyperParameterRanges.Builder.() -> kotlin.Unit) {
            this.algorithmHyperParameterRanges = aws.sdk.kotlin.services.personalize.model.HyperParameterRanges.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.HpoObjective] inside the given [block]
         */
        fun hpoObjective(block: aws.sdk.kotlin.services.personalize.model.HpoObjective.Builder.() -> kotlin.Unit) {
            this.hpoObjective = aws.sdk.kotlin.services.personalize.model.HpoObjective.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.HpoResourceConfig] inside the given [block]
         */
        fun hpoResourceConfig(block: aws.sdk.kotlin.services.personalize.model.HpoResourceConfig.Builder.() -> kotlin.Unit) {
            this.hpoResourceConfig = aws.sdk.kotlin.services.personalize.model.HpoResourceConfig.invoke(block)
        }
    }
}
