// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model



/**
 * Describes the additional objective for the solution, such as maximizing streaming minutes or increasing revenue. For more information see [Optimizing a solution](https://docs.aws.amazon.com/personalize/latest/dg/optimizing-solution-for-objective.html).
 */
class OptimizationObjective private constructor(builder: Builder) {
    /**
     * The numerical metadata column in an Items dataset related to the optimization objective. For example, VIDEO_LENGTH (to maximize streaming minutes), or PRICE (to maximize revenue).
     */
    val itemAttribute: kotlin.String? = builder.itemAttribute
    /**
     * Specifies how Amazon Personalize balances the importance of your optimization objective versus relevance.
     */
    val objectiveSensitivity: aws.sdk.kotlin.services.personalize.model.ObjectiveSensitivity? = builder.objectiveSensitivity

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.OptimizationObjective = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OptimizationObjective(")
        append("itemAttribute=$itemAttribute,")
        append("objectiveSensitivity=$objectiveSensitivity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = itemAttribute?.hashCode() ?: 0
        result = 31 * result + (objectiveSensitivity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OptimizationObjective

        if (itemAttribute != other.itemAttribute) return false
        if (objectiveSensitivity != other.objectiveSensitivity) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.OptimizationObjective = Builder(this).apply(block).build()

    class Builder {
        /**
         * The numerical metadata column in an Items dataset related to the optimization objective. For example, VIDEO_LENGTH (to maximize streaming minutes), or PRICE (to maximize revenue).
         */
        var itemAttribute: kotlin.String? = null
        /**
         * Specifies how Amazon Personalize balances the importance of your optimization objective versus relevance.
         */
        var objectiveSensitivity: aws.sdk.kotlin.services.personalize.model.ObjectiveSensitivity? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.OptimizationObjective) : this() {
            this.itemAttribute = x.itemAttribute
            this.objectiveSensitivity = x.objectiveSensitivity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.OptimizationObjective = OptimizationObjective(this)
    }
}
