// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of the properties of a recipe. For a complete listing, call the [DescribeRecipe](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecipe.html) API.
 */
class RecipeSummary private constructor(builder: Builder) {
    /**
     * The date and time (in Unix time) that the recipe was created.
     */
    val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The domain of the recipe (if the recipe is a Domain dataset group use case).
     */
    val domain: aws.sdk.kotlin.services.personalize.model.Domain? = builder.domain
    /**
     * The date and time (in Unix time) that the recipe was last updated.
     */
    val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The name of the recipe.
     */
    val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the recipe.
     */
    val recipeArn: kotlin.String? = builder.recipeArn
    /**
     * The status of the recipe.
     */
    val status: kotlin.String? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.RecipeSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecipeSummary(")
        append("creationDateTime=$creationDateTime,")
        append("domain=$domain,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("name=$name,")
        append("recipeArn=$recipeArn,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (recipeArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecipeSummary

        if (creationDateTime != other.creationDateTime) return false
        if (domain != other.domain) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (name != other.name) return false
        if (recipeArn != other.recipeArn) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.RecipeSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time (in Unix time) that the recipe was created.
         */
        var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The domain of the recipe (if the recipe is a Domain dataset group use case).
         */
        var domain: aws.sdk.kotlin.services.personalize.model.Domain? = null
        /**
         * The date and time (in Unix time) that the recipe was last updated.
         */
        var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the recipe.
         */
        var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the recipe.
         */
        var recipeArn: kotlin.String? = null
        /**
         * The status of the recipe.
         */
        var status: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.RecipeSummary) : this() {
            this.creationDateTime = x.creationDateTime
            this.domain = x.domain
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.name = x.name
            this.recipeArn = x.recipeArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.RecipeSummary = RecipeSummary(this)
    }
}
