// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model



/**
 * The configuration details of the recommender.
 */
class RecommenderConfig private constructor(builder: Builder) {
    /**
     * Specifies the exploration configuration hyperparameters, including `explorationWeight` and `explorationItemAgeCutOff`, you want to use to configure the amount of item exploration Amazon Personalize uses when recommending items. Provide `itemExplorationConfig` data only if your recommenders generate personalized recommendations for a user (not popular items or similar items).
     */
    val itemExplorationConfig: Map<String, String>? = builder.itemExplorationConfig
    /**
     * Specifies the requested minimum provisioned recommendation requests per second that Amazon Personalize will support.
     */
    val minRecommendationRequestsPerSecond: kotlin.Int? = builder.minRecommendationRequestsPerSecond

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.RecommenderConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecommenderConfig(")
        append("itemExplorationConfig=$itemExplorationConfig,")
        append("minRecommendationRequestsPerSecond=$minRecommendationRequestsPerSecond)")
    }

    override fun hashCode(): kotlin.Int {
        var result = itemExplorationConfig?.hashCode() ?: 0
        result = 31 * result + (minRecommendationRequestsPerSecond ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecommenderConfig

        if (itemExplorationConfig != other.itemExplorationConfig) return false
        if (minRecommendationRequestsPerSecond != other.minRecommendationRequestsPerSecond) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.RecommenderConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the exploration configuration hyperparameters, including `explorationWeight` and `explorationItemAgeCutOff`, you want to use to configure the amount of item exploration Amazon Personalize uses when recommending items. Provide `itemExplorationConfig` data only if your recommenders generate personalized recommendations for a user (not popular items or similar items).
         */
        var itemExplorationConfig: Map<String, String>? = null
        /**
         * Specifies the requested minimum provisioned recommendation requests per second that Amazon Personalize will support.
         */
        var minRecommendationRequestsPerSecond: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.RecommenderConfig) : this() {
            this.itemExplorationConfig = x.itemExplorationConfig
            this.minRecommendationRequestsPerSecond = x.minRecommendationRequestsPerSecond
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.RecommenderConfig = RecommenderConfig(this)
    }
}
