// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of the properties of a recommender update. For a complete listing, call the [DescribeRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html) API.
 */
class RecommenderUpdateSummary private constructor(builder: Builder) {
    /**
     * The date and time (in Unix format) that the recommender update was created.
     */
    val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * If a recommender update fails, the reason behind the failure.
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * The date and time (in Unix time) that the recommender update was last updated.
     */
    val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The configuration details of the recommender update.
     */
    val recommenderConfig: aws.sdk.kotlin.services.personalize.model.RecommenderConfig? = builder.recommenderConfig
    /**
     * The status of the recommender update.
     *
     * A recommender can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + STOP PENDING > STOP IN_PROGRESS > INACTIVE > START PENDING > START IN_PROGRESS > ACTIVE
     * + DELETE PENDING > DELETE IN_PROGRESS
     */
    val status: kotlin.String? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.RecommenderUpdateSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecommenderUpdateSummary(")
        append("creationDateTime=$creationDateTime,")
        append("failureReason=$failureReason,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("recommenderConfig=$recommenderConfig,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (recommenderConfig?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecommenderUpdateSummary

        if (creationDateTime != other.creationDateTime) return false
        if (failureReason != other.failureReason) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (recommenderConfig != other.recommenderConfig) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.RecommenderUpdateSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time (in Unix format) that the recommender update was created.
         */
        var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If a recommender update fails, the reason behind the failure.
         */
        var failureReason: kotlin.String? = null
        /**
         * The date and time (in Unix time) that the recommender update was last updated.
         */
        var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The configuration details of the recommender update.
         */
        var recommenderConfig: aws.sdk.kotlin.services.personalize.model.RecommenderConfig? = null
        /**
         * The status of the recommender update.
         *
         * A recommender can be in one of the following states:
         * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
         * + STOP PENDING > STOP IN_PROGRESS > INACTIVE > START PENDING > START IN_PROGRESS > ACTIVE
         * + DELETE PENDING > DELETE IN_PROGRESS
         */
        var status: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.RecommenderUpdateSummary) : this() {
            this.creationDateTime = x.creationDateTime
            this.failureReason = x.failureReason
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.recommenderConfig = x.recommenderConfig
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.RecommenderUpdateSummary = RecommenderUpdateSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.RecommenderConfig] inside the given [block]
         */
        fun recommenderConfig(block: aws.sdk.kotlin.services.personalize.model.RecommenderConfig.Builder.() -> kotlin.Unit) {
            this.recommenderConfig = aws.sdk.kotlin.services.personalize.model.RecommenderConfig.invoke(block)
        }
    }
}
