// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model



/**
 * Describes the configuration properties for the solution.
 */
class SolutionConfig private constructor(builder: Builder) {
    /**
     * Lists the hyperparameter names and ranges.
     */
    val algorithmHyperParameters: Map<String, String>? = builder.algorithmHyperParameters
    /**
     * The [AutoMLConfig](https://docs.aws.amazon.com/personalize/latest/dg/API_AutoMLConfig.html) object containing a list of recipes to search when AutoML is performed.
     */
    val autoMlConfig: aws.sdk.kotlin.services.personalize.model.AutoMlConfig? = builder.autoMlConfig
    /**
     * Only events with a value greater than or equal to this threshold are used for training a model.
     */
    val eventValueThreshold: kotlin.String? = builder.eventValueThreshold
    /**
     * Lists the feature transformation parameters.
     */
    val featureTransformationParameters: Map<String, String>? = builder.featureTransformationParameters
    /**
     * Describes the properties for hyperparameter optimization (HPO).
     */
    val hpoConfig: aws.sdk.kotlin.services.personalize.model.HpoConfig? = builder.hpoConfig
    /**
     * Describes the additional objective for the solution, such as maximizing streaming minutes or increasing revenue. For more information see [Optimizing a solution](https://docs.aws.amazon.com/personalize/latest/dg/optimizing-solution-for-objective.html).
     */
    val optimizationObjective: aws.sdk.kotlin.services.personalize.model.OptimizationObjective? = builder.optimizationObjective

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.SolutionConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SolutionConfig(")
        append("algorithmHyperParameters=$algorithmHyperParameters,")
        append("autoMlConfig=$autoMlConfig,")
        append("eventValueThreshold=$eventValueThreshold,")
        append("featureTransformationParameters=$featureTransformationParameters,")
        append("hpoConfig=$hpoConfig,")
        append("optimizationObjective=$optimizationObjective)")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithmHyperParameters?.hashCode() ?: 0
        result = 31 * result + (autoMlConfig?.hashCode() ?: 0)
        result = 31 * result + (eventValueThreshold?.hashCode() ?: 0)
        result = 31 * result + (featureTransformationParameters?.hashCode() ?: 0)
        result = 31 * result + (hpoConfig?.hashCode() ?: 0)
        result = 31 * result + (optimizationObjective?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SolutionConfig

        if (algorithmHyperParameters != other.algorithmHyperParameters) return false
        if (autoMlConfig != other.autoMlConfig) return false
        if (eventValueThreshold != other.eventValueThreshold) return false
        if (featureTransformationParameters != other.featureTransformationParameters) return false
        if (hpoConfig != other.hpoConfig) return false
        if (optimizationObjective != other.optimizationObjective) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.SolutionConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * Lists the hyperparameter names and ranges.
         */
        var algorithmHyperParameters: Map<String, String>? = null
        /**
         * The [AutoMLConfig](https://docs.aws.amazon.com/personalize/latest/dg/API_AutoMLConfig.html) object containing a list of recipes to search when AutoML is performed.
         */
        var autoMlConfig: aws.sdk.kotlin.services.personalize.model.AutoMlConfig? = null
        /**
         * Only events with a value greater than or equal to this threshold are used for training a model.
         */
        var eventValueThreshold: kotlin.String? = null
        /**
         * Lists the feature transformation parameters.
         */
        var featureTransformationParameters: Map<String, String>? = null
        /**
         * Describes the properties for hyperparameter optimization (HPO).
         */
        var hpoConfig: aws.sdk.kotlin.services.personalize.model.HpoConfig? = null
        /**
         * Describes the additional objective for the solution, such as maximizing streaming minutes or increasing revenue. For more information see [Optimizing a solution](https://docs.aws.amazon.com/personalize/latest/dg/optimizing-solution-for-objective.html).
         */
        var optimizationObjective: aws.sdk.kotlin.services.personalize.model.OptimizationObjective? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.SolutionConfig) : this() {
            this.algorithmHyperParameters = x.algorithmHyperParameters
            this.autoMlConfig = x.autoMlConfig
            this.eventValueThreshold = x.eventValueThreshold
            this.featureTransformationParameters = x.featureTransformationParameters
            this.hpoConfig = x.hpoConfig
            this.optimizationObjective = x.optimizationObjective
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.SolutionConfig = SolutionConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.AutoMlConfig] inside the given [block]
         */
        fun autoMlConfig(block: aws.sdk.kotlin.services.personalize.model.AutoMlConfig.Builder.() -> kotlin.Unit) {
            this.autoMlConfig = aws.sdk.kotlin.services.personalize.model.AutoMlConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.HpoConfig] inside the given [block]
         */
        fun hpoConfig(block: aws.sdk.kotlin.services.personalize.model.HpoConfig.Builder.() -> kotlin.Unit) {
            this.hpoConfig = aws.sdk.kotlin.services.personalize.model.HpoConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.OptimizationObjective] inside the given [block]
         */
        fun optimizationObjective(block: aws.sdk.kotlin.services.personalize.model.OptimizationObjective.Builder.() -> kotlin.Unit) {
            this.optimizationObjective = aws.sdk.kotlin.services.personalize.model.OptimizationObjective.invoke(block)
        }
    }
}
