// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.personalize.model.Algorithm
import aws.sdk.kotlin.services.personalize.model.DescribeAlgorithmResponse
import aws.sdk.kotlin.services.personalize.model.PersonalizeException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeAlgorithmOperationDeserializer: HttpDeserialize<DescribeAlgorithmResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeAlgorithmResponse {
        if (!response.status.isSuccess()) {
            throwDescribeAlgorithmError(context, response)
        }
        val builder = DescribeAlgorithmResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAlgorithmOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeAlgorithmError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw PersonalizeException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> PersonalizeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAlgorithmOperationBody(builder: DescribeAlgorithmResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALGORITHM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("algorithm"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALGORITHM_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALGORITHM_DESCRIPTOR.index -> builder.algorithm = deserializeAlgorithmDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
