// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.personalize.model.DescribeRecommenderResponse
import aws.sdk.kotlin.services.personalize.model.PersonalizeException
import aws.sdk.kotlin.services.personalize.model.Recommender
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeRecommenderOperationDeserializer: HttpDeserialize<DescribeRecommenderResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeRecommenderResponse {
        if (!response.status.isSuccess()) {
            throwDescribeRecommenderError(context, response)
        }
        val builder = DescribeRecommenderResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeRecommenderOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeRecommenderError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw PersonalizeException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> PersonalizeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeRecommenderOperationBody(builder: DescribeRecommenderResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RECOMMENDER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("recommender"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RECOMMENDER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RECOMMENDER_DESCRIPTOR.index -> builder.recommender = deserializeRecommenderDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
