// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model



class CreateBatchInferenceJobRequest private constructor(builder: Builder) {
    /**
     * The configuration details of a batch inference job.
     */
    val batchInferenceJobConfig: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobConfig? = builder.batchInferenceJobConfig
    /**
     * The ARN of the filter to apply to the batch inference job. For more information on using filters, see [Filtering batch recommendations](https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html).
     */
    val filterArn: kotlin.String? = builder.filterArn
    /**
     * The Amazon S3 path that leads to the input file to base your recommendations on. The input material must be in JSON format.
     */
    val jobInput: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobInput? = builder.jobInput
    /**
     * The name of the batch inference job to create.
     */
    val jobName: kotlin.String? = builder.jobName
    /**
     * The path to the Amazon S3 bucket where the job's output will be stored.
     */
    val jobOutput: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobOutput? = builder.jobOutput
    /**
     * The number of recommendations to retrieve.
     */
    val numResults: kotlin.Int? = builder.numResults
    /**
     * The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your input and output Amazon S3 buckets respectively.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The Amazon Resource Name (ARN) of the solution version that will be used to generate the batch inference recommendations.
     */
    val solutionVersionArn: kotlin.String? = builder.solutionVersionArn
    /**
     * A list of [tags](https://docs.aws.amazon.com/personalize/latest/dev/tagging-resources.html) to apply to the batch inference job.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.CreateBatchInferenceJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateBatchInferenceJobRequest(")
        append("batchInferenceJobConfig=$batchInferenceJobConfig,")
        append("filterArn=$filterArn,")
        append("jobInput=$jobInput,")
        append("jobName=$jobName,")
        append("jobOutput=$jobOutput,")
        append("numResults=$numResults,")
        append("roleArn=$roleArn,")
        append("solutionVersionArn=$solutionVersionArn,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchInferenceJobConfig?.hashCode() ?: 0
        result = 31 * result + (filterArn?.hashCode() ?: 0)
        result = 31 * result + (jobInput?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (jobOutput?.hashCode() ?: 0)
        result = 31 * result + (numResults ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (solutionVersionArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateBatchInferenceJobRequest

        if (batchInferenceJobConfig != other.batchInferenceJobConfig) return false
        if (filterArn != other.filterArn) return false
        if (jobInput != other.jobInput) return false
        if (jobName != other.jobName) return false
        if (jobOutput != other.jobOutput) return false
        if (numResults != other.numResults) return false
        if (roleArn != other.roleArn) return false
        if (solutionVersionArn != other.solutionVersionArn) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.CreateBatchInferenceJobRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The configuration details of a batch inference job.
         */
        var batchInferenceJobConfig: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobConfig? = null
        /**
         * The ARN of the filter to apply to the batch inference job. For more information on using filters, see [Filtering batch recommendations](https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html).
         */
        var filterArn: kotlin.String? = null
        /**
         * The Amazon S3 path that leads to the input file to base your recommendations on. The input material must be in JSON format.
         */
        var jobInput: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobInput? = null
        /**
         * The name of the batch inference job to create.
         */
        var jobName: kotlin.String? = null
        /**
         * The path to the Amazon S3 bucket where the job's output will be stored.
         */
        var jobOutput: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobOutput? = null
        /**
         * The number of recommendations to retrieve.
         */
        var numResults: kotlin.Int? = null
        /**
         * The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your input and output Amazon S3 buckets respectively.
         */
        var roleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the solution version that will be used to generate the batch inference recommendations.
         */
        var solutionVersionArn: kotlin.String? = null
        /**
         * A list of [tags](https://docs.aws.amazon.com/personalize/latest/dev/tagging-resources.html) to apply to the batch inference job.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.CreateBatchInferenceJobRequest) : this() {
            this.batchInferenceJobConfig = x.batchInferenceJobConfig
            this.filterArn = x.filterArn
            this.jobInput = x.jobInput
            this.jobName = x.jobName
            this.jobOutput = x.jobOutput
            this.numResults = x.numResults
            this.roleArn = x.roleArn
            this.solutionVersionArn = x.solutionVersionArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.CreateBatchInferenceJobRequest = CreateBatchInferenceJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.BatchInferenceJobConfig] inside the given [block]
         */
        fun batchInferenceJobConfig(block: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobConfig.Builder.() -> kotlin.Unit) {
            this.batchInferenceJobConfig = aws.sdk.kotlin.services.personalize.model.BatchInferenceJobConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.BatchInferenceJobInput] inside the given [block]
         */
        fun jobInput(block: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobInput.Builder.() -> kotlin.Unit) {
            this.jobInput = aws.sdk.kotlin.services.personalize.model.BatchInferenceJobInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.BatchInferenceJobOutput] inside the given [block]
         */
        fun jobOutput(block: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobOutput.Builder.() -> kotlin.Unit) {
            this.jobOutput = aws.sdk.kotlin.services.personalize.model.BatchInferenceJobOutput.invoke(block)
        }
    }
}
