// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model



class CreateDatasetExportJobRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the dataset that contains the data to export.
     */
    val datasetArn: kotlin.String? = builder.datasetArn
    /**
     * The data to export, based on how you imported the data. You can choose to export only `BULK` data that you imported using a dataset import job, only `PUT` data that you imported incrementally (using the console, PutEvents, PutUsers and PutItems operations), or `ALL` for both types. The default value is `PUT`.
     */
    val ingestionMode: aws.sdk.kotlin.services.personalize.model.IngestionMode? = builder.ingestionMode
    /**
     * The name for the dataset export job.
     */
    val jobName: kotlin.String? = builder.jobName
    /**
     * The path to the Amazon S3 bucket where the job's output is stored.
     */
    val jobOutput: aws.sdk.kotlin.services.personalize.model.DatasetExportJobOutput? = builder.jobOutput
    /**
     * The Amazon Resource Name (ARN) of the IAM service role that has permissions to add data to your output Amazon S3 bucket.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * A list of [tags](https://docs.aws.amazon.com/personalize/latest/dev/tagging-resources.html) to apply to the dataset export job.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.CreateDatasetExportJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDatasetExportJobRequest(")
        append("datasetArn=$datasetArn,")
        append("ingestionMode=$ingestionMode,")
        append("jobName=$jobName,")
        append("jobOutput=$jobOutput,")
        append("roleArn=$roleArn,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = datasetArn?.hashCode() ?: 0
        result = 31 * result + (ingestionMode?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (jobOutput?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDatasetExportJobRequest

        if (datasetArn != other.datasetArn) return false
        if (ingestionMode != other.ingestionMode) return false
        if (jobName != other.jobName) return false
        if (jobOutput != other.jobOutput) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.CreateDatasetExportJobRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the dataset that contains the data to export.
         */
        var datasetArn: kotlin.String? = null
        /**
         * The data to export, based on how you imported the data. You can choose to export only `BULK` data that you imported using a dataset import job, only `PUT` data that you imported incrementally (using the console, PutEvents, PutUsers and PutItems operations), or `ALL` for both types. The default value is `PUT`.
         */
        var ingestionMode: aws.sdk.kotlin.services.personalize.model.IngestionMode? = null
        /**
         * The name for the dataset export job.
         */
        var jobName: kotlin.String? = null
        /**
         * The path to the Amazon S3 bucket where the job's output is stored.
         */
        var jobOutput: aws.sdk.kotlin.services.personalize.model.DatasetExportJobOutput? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM service role that has permissions to add data to your output Amazon S3 bucket.
         */
        var roleArn: kotlin.String? = null
        /**
         * A list of [tags](https://docs.aws.amazon.com/personalize/latest/dev/tagging-resources.html) to apply to the dataset export job.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.CreateDatasetExportJobRequest) : this() {
            this.datasetArn = x.datasetArn
            this.ingestionMode = x.ingestionMode
            this.jobName = x.jobName
            this.jobOutput = x.jobOutput
            this.roleArn = x.roleArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.CreateDatasetExportJobRequest = CreateDatasetExportJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.DatasetExportJobOutput] inside the given [block]
         */
        fun jobOutput(block: aws.sdk.kotlin.services.personalize.model.DatasetExportJobOutput.Builder.() -> kotlin.Unit) {
            this.jobOutput = aws.sdk.kotlin.services.personalize.model.DatasetExportJobOutput.invoke(block)
        }
    }
}
