// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides metadata for a dataset.
 */
class Dataset private constructor(builder: Builder) {
    /**
     * The creation date and time (in Unix time) of the dataset.
     */
    val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The Amazon Resource Name (ARN) of the dataset that you want metadata for.
     */
    val datasetArn: kotlin.String? = builder.datasetArn
    /**
     * The Amazon Resource Name (ARN) of the dataset group.
     */
    val datasetGroupArn: kotlin.String? = builder.datasetGroupArn
    /**
     * One of the following values:
     * + Interactions
     * + Items
     * + Users
     */
    val datasetType: kotlin.String? = builder.datasetType
    /**
     * A time stamp that shows when the dataset was updated.
     */
    val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The name of the dataset.
     */
    val name: kotlin.String? = builder.name
    /**
     * The ARN of the associated schema.
     */
    val schemaArn: kotlin.String? = builder.schemaArn
    /**
     * The status of the dataset.
     *
     * A dataset can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     */
    val status: kotlin.String? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.Dataset = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Dataset(")
        append("creationDateTime=$creationDateTime,")
        append("datasetArn=$datasetArn,")
        append("datasetGroupArn=$datasetGroupArn,")
        append("datasetType=$datasetType,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("name=$name,")
        append("schemaArn=$schemaArn,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (datasetArn?.hashCode() ?: 0)
        result = 31 * result + (datasetGroupArn?.hashCode() ?: 0)
        result = 31 * result + (datasetType?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (schemaArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Dataset

        if (creationDateTime != other.creationDateTime) return false
        if (datasetArn != other.datasetArn) return false
        if (datasetGroupArn != other.datasetGroupArn) return false
        if (datasetType != other.datasetType) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (name != other.name) return false
        if (schemaArn != other.schemaArn) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.Dataset = Builder(this).apply(block).build()

    class Builder {
        /**
         * The creation date and time (in Unix time) of the dataset.
         */
        var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the dataset that you want metadata for.
         */
        var datasetArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the dataset group.
         */
        var datasetGroupArn: kotlin.String? = null
        /**
         * One of the following values:
         * + Interactions
         * + Items
         * + Users
         */
        var datasetType: kotlin.String? = null
        /**
         * A time stamp that shows when the dataset was updated.
         */
        var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the dataset.
         */
        var name: kotlin.String? = null
        /**
         * The ARN of the associated schema.
         */
        var schemaArn: kotlin.String? = null
        /**
         * The status of the dataset.
         *
         * A dataset can be in one of the following states:
         * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
         * + DELETE PENDING > DELETE IN_PROGRESS
         */
        var status: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.Dataset) : this() {
            this.creationDateTime = x.creationDateTime
            this.datasetArn = x.datasetArn
            this.datasetGroupArn = x.datasetGroupArn
            this.datasetType = x.datasetType
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.name = x.name
            this.schemaArn = x.schemaArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.Dataset = Dataset(this)
    }
}
