// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of the properties of a dataset import job. For a complete listing, call the [DescribeDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html) API.
 */
class DatasetImportJobSummary private constructor(builder: Builder) {
    /**
     * The date and time (in Unix time) that the dataset import job was created.
     */
    val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The Amazon Resource Name (ARN) of the dataset import job.
     */
    val datasetImportJobArn: kotlin.String? = builder.datasetImportJobArn
    /**
     * If a dataset import job fails, the reason behind the failure.
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * The name of the dataset import job.
     */
    val jobName: kotlin.String? = builder.jobName
    /**
     * The date and time (in Unix time) that the dataset import job status was last updated.
     */
    val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The status of the dataset import job.
     *
     * A dataset import job can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     */
    val status: kotlin.String? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.DatasetImportJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatasetImportJobSummary(")
        append("creationDateTime=$creationDateTime,")
        append("datasetImportJobArn=$datasetImportJobArn,")
        append("failureReason=$failureReason,")
        append("jobName=$jobName,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (datasetImportJobArn?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatasetImportJobSummary

        if (creationDateTime != other.creationDateTime) return false
        if (datasetImportJobArn != other.datasetImportJobArn) return false
        if (failureReason != other.failureReason) return false
        if (jobName != other.jobName) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.DatasetImportJobSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time (in Unix time) that the dataset import job was created.
         */
        var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the dataset import job.
         */
        var datasetImportJobArn: kotlin.String? = null
        /**
         * If a dataset import job fails, the reason behind the failure.
         */
        var failureReason: kotlin.String? = null
        /**
         * The name of the dataset import job.
         */
        var jobName: kotlin.String? = null
        /**
         * The date and time (in Unix time) that the dataset import job status was last updated.
         */
        var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the dataset import job.
         *
         * A dataset import job can be in one of the following states:
         * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
         */
        var status: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.DatasetImportJobSummary) : this() {
            this.creationDateTime = x.creationDateTime
            this.datasetImportJobArn = x.datasetImportJobArn
            this.failureReason = x.failureReason
            this.jobName = x.jobName
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.DatasetImportJobSummary = DatasetImportJobSummary(this)
    }
}
