// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object that provides information about a specific version of a [Solution](https://docs.aws.amazon.com/personalize/latest/dg/API_Solution.html) in a Custom dataset group.
 */
class SolutionVersion private constructor(builder: Builder) {
    /**
     * The date and time (in Unix time) that this version of the solution was created.
     */
    val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The Amazon Resource Name (ARN) of the dataset group providing the training data.
     */
    val datasetGroupArn: kotlin.String? = builder.datasetGroupArn
    /**
     * The event type (for example, 'click' or 'like') that is used for training the model.
     */
    val eventType: kotlin.String? = builder.eventType
    /**
     * If training a solution version fails, the reason for the failure.
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * The date and time (in Unix time) that the solution was last updated.
     */
    val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * When true, Amazon Personalize searches for the most optimal recipe according to the solution configuration. When false (the default), Amazon Personalize uses `recipeArn`.
     */
    val performAutoMl: kotlin.Boolean = builder.performAutoMl
    /**
     * Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The default is `false`.
     */
    val performHpo: kotlin.Boolean = builder.performHpo
    /**
     * The ARN of the recipe used in the solution.
     */
    val recipeArn: kotlin.String? = builder.recipeArn
    /**
     * The ARN of the solution.
     */
    val solutionArn: kotlin.String? = builder.solutionArn
    /**
     * Describes the configuration properties for the solution.
     */
    val solutionConfig: aws.sdk.kotlin.services.personalize.model.SolutionConfig? = builder.solutionConfig
    /**
     * The ARN of the solution version.
     */
    val solutionVersionArn: kotlin.String? = builder.solutionVersionArn
    /**
     * The status of the solution version.
     *
     * A solution version can be in one of the following states:
     * + CREATE PENDING
     * + CREATE IN_PROGRESS
     * + ACTIVE
     * + CREATE FAILED
     * + CREATE STOPPING
     * + CREATE STOPPED
     */
    val status: kotlin.String? = builder.status
    /**
     * The time used to train the model. You are billed for the time it takes to train a model. This field is visible only after Amazon Personalize successfully trains a model.
     */
    val trainingHours: kotlin.Double? = builder.trainingHours
    /**
     * The scope of training to be performed when creating the solution version. The `FULL` option trains the solution version based on the entirety of the input solution's training data, while the `UPDATE` option processes only the data that has changed in comparison to the input solution. Choose `UPDATE` when you want to incrementally update your solution version instead of creating an entirely new one.
     *
     * The `UPDATE` option can only be used when you already have an active solution version created from the input solution using the `FULL` option and the input solution was trained with the [User-Personalization](https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html) recipe or the [HRNN-Coldstart](https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html) recipe.
     */
    val trainingMode: aws.sdk.kotlin.services.personalize.model.TrainingMode? = builder.trainingMode
    /**
     * If hyperparameter optimization was performed, contains the hyperparameter values of the best performing model.
     */
    val tunedHpoParams: aws.sdk.kotlin.services.personalize.model.TunedHpoParams? = builder.tunedHpoParams

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.SolutionVersion = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SolutionVersion(")
        append("creationDateTime=$creationDateTime,")
        append("datasetGroupArn=$datasetGroupArn,")
        append("eventType=$eventType,")
        append("failureReason=$failureReason,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("performAutoMl=$performAutoMl,")
        append("performHpo=$performHpo,")
        append("recipeArn=$recipeArn,")
        append("solutionArn=$solutionArn,")
        append("solutionConfig=$solutionConfig,")
        append("solutionVersionArn=$solutionVersionArn,")
        append("status=$status,")
        append("trainingHours=$trainingHours,")
        append("trainingMode=$trainingMode,")
        append("tunedHpoParams=$tunedHpoParams)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (datasetGroupArn?.hashCode() ?: 0)
        result = 31 * result + (eventType?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (performAutoMl.hashCode())
        result = 31 * result + (performHpo.hashCode())
        result = 31 * result + (recipeArn?.hashCode() ?: 0)
        result = 31 * result + (solutionArn?.hashCode() ?: 0)
        result = 31 * result + (solutionConfig?.hashCode() ?: 0)
        result = 31 * result + (solutionVersionArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (trainingHours?.hashCode() ?: 0)
        result = 31 * result + (trainingMode?.hashCode() ?: 0)
        result = 31 * result + (tunedHpoParams?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SolutionVersion

        if (creationDateTime != other.creationDateTime) return false
        if (datasetGroupArn != other.datasetGroupArn) return false
        if (eventType != other.eventType) return false
        if (failureReason != other.failureReason) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (performAutoMl != other.performAutoMl) return false
        if (performHpo != other.performHpo) return false
        if (recipeArn != other.recipeArn) return false
        if (solutionArn != other.solutionArn) return false
        if (solutionConfig != other.solutionConfig) return false
        if (solutionVersionArn != other.solutionVersionArn) return false
        if (status != other.status) return false
        if (trainingHours != other.trainingHours) return false
        if (trainingMode != other.trainingMode) return false
        if (tunedHpoParams != other.tunedHpoParams) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.SolutionVersion = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time (in Unix time) that this version of the solution was created.
         */
        var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the dataset group providing the training data.
         */
        var datasetGroupArn: kotlin.String? = null
        /**
         * The event type (for example, 'click' or 'like') that is used for training the model.
         */
        var eventType: kotlin.String? = null
        /**
         * If training a solution version fails, the reason for the failure.
         */
        var failureReason: kotlin.String? = null
        /**
         * The date and time (in Unix time) that the solution was last updated.
         */
        var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * When true, Amazon Personalize searches for the most optimal recipe according to the solution configuration. When false (the default), Amazon Personalize uses `recipeArn`.
         */
        var performAutoMl: kotlin.Boolean = false
        /**
         * Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The default is `false`.
         */
        var performHpo: kotlin.Boolean = false
        /**
         * The ARN of the recipe used in the solution.
         */
        var recipeArn: kotlin.String? = null
        /**
         * The ARN of the solution.
         */
        var solutionArn: kotlin.String? = null
        /**
         * Describes the configuration properties for the solution.
         */
        var solutionConfig: aws.sdk.kotlin.services.personalize.model.SolutionConfig? = null
        /**
         * The ARN of the solution version.
         */
        var solutionVersionArn: kotlin.String? = null
        /**
         * The status of the solution version.
         *
         * A solution version can be in one of the following states:
         * + CREATE PENDING
         * + CREATE IN_PROGRESS
         * + ACTIVE
         * + CREATE FAILED
         * + CREATE STOPPING
         * + CREATE STOPPED
         */
        var status: kotlin.String? = null
        /**
         * The time used to train the model. You are billed for the time it takes to train a model. This field is visible only after Amazon Personalize successfully trains a model.
         */
        var trainingHours: kotlin.Double? = null
        /**
         * The scope of training to be performed when creating the solution version. The `FULL` option trains the solution version based on the entirety of the input solution's training data, while the `UPDATE` option processes only the data that has changed in comparison to the input solution. Choose `UPDATE` when you want to incrementally update your solution version instead of creating an entirely new one.
         *
         * The `UPDATE` option can only be used when you already have an active solution version created from the input solution using the `FULL` option and the input solution was trained with the [User-Personalization](https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html) recipe or the [HRNN-Coldstart](https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html) recipe.
         */
        var trainingMode: aws.sdk.kotlin.services.personalize.model.TrainingMode? = null
        /**
         * If hyperparameter optimization was performed, contains the hyperparameter values of the best performing model.
         */
        var tunedHpoParams: aws.sdk.kotlin.services.personalize.model.TunedHpoParams? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.SolutionVersion) : this() {
            this.creationDateTime = x.creationDateTime
            this.datasetGroupArn = x.datasetGroupArn
            this.eventType = x.eventType
            this.failureReason = x.failureReason
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.performAutoMl = x.performAutoMl
            this.performHpo = x.performHpo
            this.recipeArn = x.recipeArn
            this.solutionArn = x.solutionArn
            this.solutionConfig = x.solutionConfig
            this.solutionVersionArn = x.solutionVersionArn
            this.status = x.status
            this.trainingHours = x.trainingHours
            this.trainingMode = x.trainingMode
            this.tunedHpoParams = x.tunedHpoParams
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.SolutionVersion = SolutionVersion(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.SolutionConfig] inside the given [block]
         */
        fun solutionConfig(block: aws.sdk.kotlin.services.personalize.model.SolutionConfig.Builder.() -> kotlin.Unit) {
            this.solutionConfig = aws.sdk.kotlin.services.personalize.model.SolutionConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.TunedHpoParams] inside the given [block]
         */
        fun tunedHpoParams(block: aws.sdk.kotlin.services.personalize.model.TunedHpoParams.Builder.() -> kotlin.Unit) {
            this.tunedHpoParams = aws.sdk.kotlin.services.personalize.model.TunedHpoParams.invoke(block)
        }
    }
}
