// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of the properties of a solution version. For a complete listing, call the [DescribeSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html) API.
 */
class SolutionVersionSummary private constructor(builder: Builder) {
    /**
     * The date and time (in Unix time) that this version of a solution was created.
     */
    val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * If a solution version fails, the reason behind the failure.
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * The date and time (in Unix time) that the solution version was last updated.
     */
    val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The Amazon Resource Name (ARN) of the solution version.
     */
    val solutionVersionArn: kotlin.String? = builder.solutionVersionArn
    /**
     * The status of the solution version.
     *
     * A solution version can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     */
    val status: kotlin.String? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.SolutionVersionSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SolutionVersionSummary(")
        append("creationDateTime=$creationDateTime,")
        append("failureReason=$failureReason,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("solutionVersionArn=$solutionVersionArn,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (solutionVersionArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SolutionVersionSummary

        if (creationDateTime != other.creationDateTime) return false
        if (failureReason != other.failureReason) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (solutionVersionArn != other.solutionVersionArn) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.SolutionVersionSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time (in Unix time) that this version of a solution was created.
         */
        var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If a solution version fails, the reason behind the failure.
         */
        var failureReason: kotlin.String? = null
        /**
         * The date and time (in Unix time) that the solution version was last updated.
         */
        var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the solution version.
         */
        var solutionVersionArn: kotlin.String? = null
        /**
         * The status of the solution version.
         *
         * A solution version can be in one of the following states:
         * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
         */
        var status: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.SolutionVersionSummary) : this() {
            this.creationDateTime = x.creationDateTime
            this.failureReason = x.failureReason
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.solutionVersionArn = x.solutionVersionArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.SolutionVersionSummary = SolutionVersionSummary(this)
    }
}
