// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.paginators

import aws.sdk.kotlin.services.personalize.PersonalizeClient
import aws.sdk.kotlin.services.personalize.model.BatchInferenceJobSummary
import aws.sdk.kotlin.services.personalize.model.BatchSegmentJobSummary
import aws.sdk.kotlin.services.personalize.model.CampaignSummary
import aws.sdk.kotlin.services.personalize.model.DatasetExportJobSummary
import aws.sdk.kotlin.services.personalize.model.DatasetGroupSummary
import aws.sdk.kotlin.services.personalize.model.DatasetImportJobSummary
import aws.sdk.kotlin.services.personalize.model.DatasetSchemaSummary
import aws.sdk.kotlin.services.personalize.model.DatasetSummary
import aws.sdk.kotlin.services.personalize.model.EventTrackerSummary
import aws.sdk.kotlin.services.personalize.model.FilterSummary
import aws.sdk.kotlin.services.personalize.model.ListBatchInferenceJobsRequest
import aws.sdk.kotlin.services.personalize.model.ListBatchInferenceJobsResponse
import aws.sdk.kotlin.services.personalize.model.ListBatchSegmentJobsRequest
import aws.sdk.kotlin.services.personalize.model.ListBatchSegmentJobsResponse
import aws.sdk.kotlin.services.personalize.model.ListCampaignsRequest
import aws.sdk.kotlin.services.personalize.model.ListCampaignsResponse
import aws.sdk.kotlin.services.personalize.model.ListDatasetExportJobsRequest
import aws.sdk.kotlin.services.personalize.model.ListDatasetExportJobsResponse
import aws.sdk.kotlin.services.personalize.model.ListDatasetGroupsRequest
import aws.sdk.kotlin.services.personalize.model.ListDatasetGroupsResponse
import aws.sdk.kotlin.services.personalize.model.ListDatasetImportJobsRequest
import aws.sdk.kotlin.services.personalize.model.ListDatasetImportJobsResponse
import aws.sdk.kotlin.services.personalize.model.ListDatasetsRequest
import aws.sdk.kotlin.services.personalize.model.ListDatasetsResponse
import aws.sdk.kotlin.services.personalize.model.ListEventTrackersRequest
import aws.sdk.kotlin.services.personalize.model.ListEventTrackersResponse
import aws.sdk.kotlin.services.personalize.model.ListFiltersRequest
import aws.sdk.kotlin.services.personalize.model.ListFiltersResponse
import aws.sdk.kotlin.services.personalize.model.ListRecipesRequest
import aws.sdk.kotlin.services.personalize.model.ListRecipesResponse
import aws.sdk.kotlin.services.personalize.model.ListRecommendersRequest
import aws.sdk.kotlin.services.personalize.model.ListRecommendersResponse
import aws.sdk.kotlin.services.personalize.model.ListSchemasRequest
import aws.sdk.kotlin.services.personalize.model.ListSchemasResponse
import aws.sdk.kotlin.services.personalize.model.ListSolutionVersionsRequest
import aws.sdk.kotlin.services.personalize.model.ListSolutionVersionsResponse
import aws.sdk.kotlin.services.personalize.model.ListSolutionsRequest
import aws.sdk.kotlin.services.personalize.model.ListSolutionsResponse
import aws.sdk.kotlin.services.personalize.model.RecipeSummary
import aws.sdk.kotlin.services.personalize.model.RecommenderSummary
import aws.sdk.kotlin.services.personalize.model.SolutionSummary
import aws.sdk.kotlin.services.personalize.model.SolutionVersionSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListBatchInferenceJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBatchInferenceJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBatchInferenceJobsResponse]
 */
fun PersonalizeClient.listBatchInferenceJobsPaginated(initialRequest: ListBatchInferenceJobsRequest): Flow<ListBatchInferenceJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBatchInferenceJobsPaginated.listBatchInferenceJobs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListBatchInferenceJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBatchInferenceJobsResponse]
 */
fun PersonalizeClient.listBatchInferenceJobsPaginated(block: ListBatchInferenceJobsRequest.Builder.() -> Unit): Flow<ListBatchInferenceJobsResponse> =
    listBatchInferenceJobsPaginated(ListBatchInferenceJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBatchInferenceJobsPaginated]
 * to access the nested member [BatchInferenceJobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BatchInferenceJobSummary]
 */
@JvmName("listBatchInferenceJobsResponseBatchInferenceJobSummary")
fun Flow<ListBatchInferenceJobsResponse>.batchInferenceJobs(): Flow<BatchInferenceJobSummary> =
    transform() { response ->
        response.batchInferenceJobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListBatchSegmentJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBatchSegmentJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBatchSegmentJobsResponse]
 */
fun PersonalizeClient.listBatchSegmentJobsPaginated(initialRequest: ListBatchSegmentJobsRequest): Flow<ListBatchSegmentJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBatchSegmentJobsPaginated.listBatchSegmentJobs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListBatchSegmentJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBatchSegmentJobsResponse]
 */
fun PersonalizeClient.listBatchSegmentJobsPaginated(block: ListBatchSegmentJobsRequest.Builder.() -> Unit): Flow<ListBatchSegmentJobsResponse> =
    listBatchSegmentJobsPaginated(ListBatchSegmentJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBatchSegmentJobsPaginated]
 * to access the nested member [BatchSegmentJobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BatchSegmentJobSummary]
 */
@JvmName("listBatchSegmentJobsResponseBatchSegmentJobSummary")
fun Flow<ListBatchSegmentJobsResponse>.batchSegmentJobs(): Flow<BatchSegmentJobSummary> =
    transform() { response ->
        response.batchSegmentJobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCampaignsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCampaignsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCampaignsResponse]
 */
fun PersonalizeClient.listCampaignsPaginated(initialRequest: ListCampaignsRequest): Flow<ListCampaignsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCampaignsPaginated.listCampaigns(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListCampaignsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCampaignsResponse]
 */
fun PersonalizeClient.listCampaignsPaginated(block: ListCampaignsRequest.Builder.() -> Unit): Flow<ListCampaignsResponse> =
    listCampaignsPaginated(ListCampaignsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCampaignsPaginated]
 * to access the nested member [CampaignSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CampaignSummary]
 */
@JvmName("listCampaignsResponseCampaignSummary")
fun Flow<ListCampaignsResponse>.campaigns(): Flow<CampaignSummary> =
    transform() { response ->
        response.campaigns?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDatasetExportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDatasetExportJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetExportJobsResponse]
 */
fun PersonalizeClient.listDatasetExportJobsPaginated(initialRequest: ListDatasetExportJobsRequest): Flow<ListDatasetExportJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDatasetExportJobsPaginated.listDatasetExportJobs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDatasetExportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetExportJobsResponse]
 */
fun PersonalizeClient.listDatasetExportJobsPaginated(block: ListDatasetExportJobsRequest.Builder.() -> Unit): Flow<ListDatasetExportJobsResponse> =
    listDatasetExportJobsPaginated(ListDatasetExportJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDatasetExportJobsPaginated]
 * to access the nested member [DatasetExportJobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DatasetExportJobSummary]
 */
@JvmName("listDatasetExportJobsResponseDatasetExportJobSummary")
fun Flow<ListDatasetExportJobsResponse>.datasetExportJobs(): Flow<DatasetExportJobSummary> =
    transform() { response ->
        response.datasetExportJobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDatasetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDatasetGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetGroupsResponse]
 */
fun PersonalizeClient.listDatasetGroupsPaginated(initialRequest: ListDatasetGroupsRequest): Flow<ListDatasetGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDatasetGroupsPaginated.listDatasetGroups(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDatasetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetGroupsResponse]
 */
fun PersonalizeClient.listDatasetGroupsPaginated(block: ListDatasetGroupsRequest.Builder.() -> Unit): Flow<ListDatasetGroupsResponse> =
    listDatasetGroupsPaginated(ListDatasetGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDatasetGroupsPaginated]
 * to access the nested member [DatasetGroupSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DatasetGroupSummary]
 */
@JvmName("listDatasetGroupsResponseDatasetGroupSummary")
fun Flow<ListDatasetGroupsResponse>.datasetGroups(): Flow<DatasetGroupSummary> =
    transform() { response ->
        response.datasetGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDatasetImportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDatasetImportJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetImportJobsResponse]
 */
fun PersonalizeClient.listDatasetImportJobsPaginated(initialRequest: ListDatasetImportJobsRequest): Flow<ListDatasetImportJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDatasetImportJobsPaginated.listDatasetImportJobs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDatasetImportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetImportJobsResponse]
 */
fun PersonalizeClient.listDatasetImportJobsPaginated(block: ListDatasetImportJobsRequest.Builder.() -> Unit): Flow<ListDatasetImportJobsResponse> =
    listDatasetImportJobsPaginated(ListDatasetImportJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDatasetImportJobsPaginated]
 * to access the nested member [DatasetImportJobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DatasetImportJobSummary]
 */
@JvmName("listDatasetImportJobsResponseDatasetImportJobSummary")
fun Flow<ListDatasetImportJobsResponse>.datasetImportJobs(): Flow<DatasetImportJobSummary> =
    transform() { response ->
        response.datasetImportJobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDatasetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDatasetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetsResponse]
 */
fun PersonalizeClient.listDatasetsPaginated(initialRequest: ListDatasetsRequest): Flow<ListDatasetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDatasetsPaginated.listDatasets(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDatasetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetsResponse]
 */
fun PersonalizeClient.listDatasetsPaginated(block: ListDatasetsRequest.Builder.() -> Unit): Flow<ListDatasetsResponse> =
    listDatasetsPaginated(ListDatasetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDatasetsPaginated]
 * to access the nested member [DatasetSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DatasetSummary]
 */
@JvmName("listDatasetsResponseDatasetSummary")
fun Flow<ListDatasetsResponse>.datasets(): Flow<DatasetSummary> =
    transform() { response ->
        response.datasets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEventTrackersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEventTrackersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventTrackersResponse]
 */
fun PersonalizeClient.listEventTrackersPaginated(initialRequest: ListEventTrackersRequest): Flow<ListEventTrackersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEventTrackersPaginated.listEventTrackers(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListEventTrackersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventTrackersResponse]
 */
fun PersonalizeClient.listEventTrackersPaginated(block: ListEventTrackersRequest.Builder.() -> Unit): Flow<ListEventTrackersResponse> =
    listEventTrackersPaginated(ListEventTrackersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEventTrackersPaginated]
 * to access the nested member [EventTrackerSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EventTrackerSummary]
 */
@JvmName("listEventTrackersResponseEventTrackerSummary")
fun Flow<ListEventTrackersResponse>.eventTrackers(): Flow<EventTrackerSummary> =
    transform() { response ->
        response.eventTrackers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFiltersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFiltersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFiltersResponse]
 */
fun PersonalizeClient.listFiltersPaginated(initialRequest: ListFiltersRequest): Flow<ListFiltersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFiltersPaginated.listFilters(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFiltersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFiltersResponse]
 */
fun PersonalizeClient.listFiltersPaginated(block: ListFiltersRequest.Builder.() -> Unit): Flow<ListFiltersResponse> =
    listFiltersPaginated(ListFiltersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFiltersPaginated]
 * to access the nested member [FilterSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FilterSummary]
 */
@JvmName("listFiltersResponseFilterSummary")
fun Flow<ListFiltersResponse>.filters(): Flow<FilterSummary> =
    transform() { response ->
        response.filters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRecipesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRecipesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecipesResponse]
 */
fun PersonalizeClient.listRecipesPaginated(initialRequest: ListRecipesRequest): Flow<ListRecipesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRecipesPaginated.listRecipes(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRecipesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecipesResponse]
 */
fun PersonalizeClient.listRecipesPaginated(block: ListRecipesRequest.Builder.() -> Unit): Flow<ListRecipesResponse> =
    listRecipesPaginated(ListRecipesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRecipesPaginated]
 * to access the nested member [RecipeSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RecipeSummary]
 */
@JvmName("listRecipesResponseRecipeSummary")
fun Flow<ListRecipesResponse>.recipes(): Flow<RecipeSummary> =
    transform() { response ->
        response.recipes?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRecommendersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRecommendersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecommendersResponse]
 */
fun PersonalizeClient.listRecommendersPaginated(initialRequest: ListRecommendersRequest): Flow<ListRecommendersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRecommendersPaginated.listRecommenders(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRecommendersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecommendersResponse]
 */
fun PersonalizeClient.listRecommendersPaginated(block: ListRecommendersRequest.Builder.() -> Unit): Flow<ListRecommendersResponse> =
    listRecommendersPaginated(ListRecommendersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRecommendersPaginated]
 * to access the nested member [RecommenderSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RecommenderSummary]
 */
@JvmName("listRecommendersResponseRecommenderSummary")
fun Flow<ListRecommendersResponse>.recommenders(): Flow<RecommenderSummary> =
    transform() { response ->
        response.recommenders?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSchemasResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSchemasRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSchemasResponse]
 */
fun PersonalizeClient.listSchemasPaginated(initialRequest: ListSchemasRequest): Flow<ListSchemasResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSchemasPaginated.listSchemas(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListSchemasResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSchemasResponse]
 */
fun PersonalizeClient.listSchemasPaginated(block: ListSchemasRequest.Builder.() -> Unit): Flow<ListSchemasResponse> =
    listSchemasPaginated(ListSchemasRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSchemasPaginated]
 * to access the nested member [DatasetSchemaSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DatasetSchemaSummary]
 */
@JvmName("listSchemasResponseDatasetSchemaSummary")
fun Flow<ListSchemasResponse>.schemas(): Flow<DatasetSchemaSummary> =
    transform() { response ->
        response.schemas?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSolutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSolutionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSolutionsResponse]
 */
fun PersonalizeClient.listSolutionsPaginated(initialRequest: ListSolutionsRequest): Flow<ListSolutionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSolutionsPaginated.listSolutions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListSolutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSolutionsResponse]
 */
fun PersonalizeClient.listSolutionsPaginated(block: ListSolutionsRequest.Builder.() -> Unit): Flow<ListSolutionsResponse> =
    listSolutionsPaginated(ListSolutionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSolutionsPaginated]
 * to access the nested member [SolutionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SolutionSummary]
 */
@JvmName("listSolutionsResponseSolutionSummary")
fun Flow<ListSolutionsResponse>.solutions(): Flow<SolutionSummary> =
    transform() { response ->
        response.solutions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSolutionVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSolutionVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSolutionVersionsResponse]
 */
fun PersonalizeClient.listSolutionVersionsPaginated(initialRequest: ListSolutionVersionsRequest): Flow<ListSolutionVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSolutionVersionsPaginated.listSolutionVersions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListSolutionVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSolutionVersionsResponse]
 */
fun PersonalizeClient.listSolutionVersionsPaginated(block: ListSolutionVersionsRequest.Builder.() -> Unit): Flow<ListSolutionVersionsResponse> =
    listSolutionVersionsPaginated(ListSolutionVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSolutionVersionsPaginated]
 * to access the nested member [SolutionVersionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SolutionVersionSummary]
 */
@JvmName("listSolutionVersionsResponseSolutionVersionSummary")
fun Flow<ListSolutionVersionsResponse>.solutionVersions(): Flow<SolutionVersionSummary> =
    transform() { response ->
        response.solutionVersions?.forEach {
            emit(it)
        }
    }
