// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalizeruntime

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.personalizeruntime.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.personalizeruntime.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 *
 */
interface PersonalizeRuntimeClient : SdkClient {

    override val serviceName: String
        get() = "Personalize Runtime"
    /**
     * PersonalizeRuntimeClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): PersonalizeRuntimeClient {
            val config = Config.Builder().apply(block).build()
            return DefaultPersonalizeRuntimeClient(config)
        }

        operator fun invoke(config: Config): PersonalizeRuntimeClient = DefaultPersonalizeRuntimeClient(config)

        /**
         * Construct a [PersonalizeRuntimeClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): PersonalizeRuntimeClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultPersonalizeRuntimeClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Re-ranks a list of recommended items for the given user. The first item in the list is
     * deemed the most likely item to be of interest to the user.
     *
     * The solution backing the campaign must have been created using a recipe of type
     * PERSONALIZED_RANKING.
     */
    suspend fun getPersonalizedRanking(input: GetPersonalizedRankingRequest): GetPersonalizedRankingResponse

    /**
     * Re-ranks a list of recommended items for the given user. The first item in the list is
     * deemed the most likely item to be of interest to the user.
     *
     * The solution backing the campaign must have been created using a recipe of type
     * PERSONALIZED_RANKING.
     */
    suspend fun getPersonalizedRanking(block: GetPersonalizedRankingRequest.Builder.() -> Unit) = getPersonalizedRanking(GetPersonalizedRankingRequest.Builder().apply(block).build())

    /**
     * Returns a list of recommended items. For campaigns, the campaign's Amazon Resource Name (ARN) is required and the required user and item input depends on the recipe type used to
     * create the solution backing the campaign as follows:
     *
     *
     * USER_PERSONALIZATION - userId required, itemId not used
     *
     * RELATED_ITEMS - itemId required, userId not used
     *
     *
     * Campaigns that are backed by a solution created using a recipe of type
     * PERSONALIZED_RANKING use the  API.
     *
     * For recommenders, the recommender's ARN is required and the required item and user input depends on the use case (domain-based recipe) backing the recommender.
     * For information on use case requirements see <a href="https://docs.aws.amazon.com/personalize/latest/dg/domain-use-cases.html">Choosing recommender use cases.
     */
    suspend fun getRecommendations(input: GetRecommendationsRequest): GetRecommendationsResponse

    /**
     * Returns a list of recommended items. For campaigns, the campaign's Amazon Resource Name (ARN) is required and the required user and item input depends on the recipe type used to
     * create the solution backing the campaign as follows:
     *
     *
     * USER_PERSONALIZATION - userId required, itemId not used
     *
     * RELATED_ITEMS - itemId required, userId not used
     *
     *
     * Campaigns that are backed by a solution created using a recipe of type
     * PERSONALIZED_RANKING use the  API.
     *
     * For recommenders, the recommender's ARN is required and the required item and user input depends on the use case (domain-based recipe) backing the recommender.
     * For information on use case requirements see <a href="https://docs.aws.amazon.com/personalize/latest/dg/domain-use-cases.html">Choosing recommender use cases.
     */
    suspend fun getRecommendations(block: GetRecommendationsRequest.Builder.() -> Unit) = getRecommendations(GetRecommendationsRequest.Builder().apply(block).build())
}
