// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalizeruntime.model



class GetRecommendationsRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the campaign to use for getting recommendations.
     */
    val campaignArn: kotlin.String? = builder.campaignArn
    /**
     * The contextual metadata to use when getting recommendations. Contextual metadata includes
     * any interaction information that might be relevant when getting a user's recommendations, such
     * as the user's current location or device type.
     */
    val context: Map<String, String>? = builder.context
    /**
     * The ARN of the filter to apply to the returned recommendations. For more information, see
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering Recommendations.
     * When using this parameter, be sure the filter resource is ACTIVE.
     */
    val filterArn: kotlin.String? = builder.filterArn
    /**
     * The values to use when filtering recommendations. For each placeholder parameter in your filter expression, provide the parameter name (in matching case)
     * as a key and the filter value(s) as the corresponding value. Separate multiple values for one parameter with a comma.
     *
     * For filter expressions that use an INCLUDE element to include items,
     * you must provide values for all parameters that are defined in the expression. For
     * filters with expressions that use an EXCLUDE element to exclude items, you
     * can omit the filter-values.In this case, Amazon Personalize doesn't use that portion of
     * the expression to filter recommendations.
     * For more information, see
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering Recommendations.
     */
    val filterValues: Map<String, String>? = builder.filterValues
    /**
     * The item ID to provide recommendations for.
     * Required for RELATED_ITEMS recipe type.
     */
    val itemId: kotlin.String? = builder.itemId
    /**
     * The number of results to return. The default is 25. The maximum is 500.
     */
    val numResults: kotlin.Int = builder.numResults
    /**
     * The Amazon Resource Name (ARN) of the recommender to use to get recommendations. Provide a recommender ARN if you
     * created a Domain dataset group with a recommender for a domain use case.
     */
    val recommenderArn: kotlin.String? = builder.recommenderArn
    /**
     * The user ID to provide recommendations for.
     * Required for USER_PERSONALIZATION recipe type.
     */
    val userId: kotlin.String? = builder.userId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalizeruntime.model.GetRecommendationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetRecommendationsRequest(")
        append("campaignArn=$campaignArn,")
        append("context=$context,")
        append("filterArn=$filterArn,")
        append("filterValues=$filterValues,")
        append("itemId=$itemId,")
        append("numResults=$numResults,")
        append("recommenderArn=$recommenderArn,")
        append("userId=$userId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = campaignArn?.hashCode() ?: 0
        result = 31 * result + (context?.hashCode() ?: 0)
        result = 31 * result + (filterArn?.hashCode() ?: 0)
        result = 31 * result + (filterValues?.hashCode() ?: 0)
        result = 31 * result + (itemId?.hashCode() ?: 0)
        result = 31 * result + (numResults)
        result = 31 * result + (recommenderArn?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetRecommendationsRequest

        if (campaignArn != other.campaignArn) return false
        if (context != other.context) return false
        if (filterArn != other.filterArn) return false
        if (filterValues != other.filterValues) return false
        if (itemId != other.itemId) return false
        if (numResults != other.numResults) return false
        if (recommenderArn != other.recommenderArn) return false
        if (userId != other.userId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalizeruntime.model.GetRecommendationsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the campaign to use for getting recommendations.
         */
        var campaignArn: kotlin.String? = null
        /**
         * The contextual metadata to use when getting recommendations. Contextual metadata includes
         * any interaction information that might be relevant when getting a user's recommendations, such
         * as the user's current location or device type.
         */
        var context: Map<String, String>? = null
        /**
         * The ARN of the filter to apply to the returned recommendations. For more information, see
         * <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering Recommendations.
         * When using this parameter, be sure the filter resource is ACTIVE.
         */
        var filterArn: kotlin.String? = null
        /**
         * The values to use when filtering recommendations. For each placeholder parameter in your filter expression, provide the parameter name (in matching case)
         * as a key and the filter value(s) as the corresponding value. Separate multiple values for one parameter with a comma.
         *
         * For filter expressions that use an INCLUDE element to include items,
         * you must provide values for all parameters that are defined in the expression. For
         * filters with expressions that use an EXCLUDE element to exclude items, you
         * can omit the filter-values.In this case, Amazon Personalize doesn't use that portion of
         * the expression to filter recommendations.
         * For more information, see
         * <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering Recommendations.
         */
        var filterValues: Map<String, String>? = null
        /**
         * The item ID to provide recommendations for.
         * Required for RELATED_ITEMS recipe type.
         */
        var itemId: kotlin.String? = null
        /**
         * The number of results to return. The default is 25. The maximum is 500.
         */
        var numResults: kotlin.Int = 0
        /**
         * The Amazon Resource Name (ARN) of the recommender to use to get recommendations. Provide a recommender ARN if you
         * created a Domain dataset group with a recommender for a domain use case.
         */
        var recommenderArn: kotlin.String? = null
        /**
         * The user ID to provide recommendations for.
         * Required for USER_PERSONALIZATION recipe type.
         */
        var userId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalizeruntime.model.GetRecommendationsRequest) : this() {
            this.campaignArn = x.campaignArn
            this.context = x.context
            this.filterArn = x.filterArn
            this.filterValues = x.filterValues
            this.itemId = x.itemId
            this.numResults = x.numResults
            this.recommenderArn = x.recommenderArn
            this.userId = x.userId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalizeruntime.model.GetRecommendationsRequest = GetRecommendationsRequest(this)
    }
}
