// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalizeruntime

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.personalizeruntime.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.personalizeruntime.endpoints.EndpointProvider
import aws.sdk.kotlin.services.personalizeruntime.model.*
import aws.sdk.kotlin.services.personalizeruntime.model.GetPersonalizedRankingRequest
import aws.sdk.kotlin.services.personalizeruntime.model.GetPersonalizedRankingResponse
import aws.sdk.kotlin.services.personalizeruntime.model.GetRecommendationsRequest
import aws.sdk.kotlin.services.personalizeruntime.model.GetRecommendationsResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig

/**
 *
 */
public interface PersonalizeRuntimeClient : SdkClient {

    override val serviceName: String
        get() = "Personalize Runtime"
    /**
     * PersonalizeRuntimeClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): PersonalizeRuntimeClient {
            val config = Config.Builder().apply(block).build()
            return DefaultPersonalizeRuntimeClient(config)
        }

        public operator fun invoke(config: Config): PersonalizeRuntimeClient = DefaultPersonalizeRuntimeClient(config)

        /**
         * Construct a [PersonalizeRuntimeClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): PersonalizeRuntimeClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultPersonalizeRuntimeClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "Personalize Runtime")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null
            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null
            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null
            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false
            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Re-ranks a list of recommended items for the given user. The first item in the list is deemed the most likely item to be of interest to the user.
     *
     * The solution backing the campaign must have been created using a recipe of type PERSONALIZED_RANKING.
     */
    public suspend fun getPersonalizedRanking(input: GetPersonalizedRankingRequest): GetPersonalizedRankingResponse

    /**
     * Returns a list of recommended items. For campaigns, the campaign's Amazon Resource Name (ARN) is required and the required user and item input depends on the recipe type used to create the solution backing the campaign as follows:
     * + USER_PERSONALIZATION - `userId` required, `itemId` not used
     * + RELATED_ITEMS - `itemId` required, `userId` not used
     *
     * Campaigns that are backed by a solution created using a recipe of type PERSONALIZED_RANKING use the API.
     *
     *  For recommenders, the recommender's ARN is required and the required item and user input depends on the use case (domain-based recipe) backing the recommender. For information on use case requirements see [Choosing recommender use cases](https://docs.aws.amazon.com/personalize/latest/dg/domain-use-cases.html).
     */
    public suspend fun getRecommendations(input: GetRecommendationsRequest = GetRecommendationsRequest {}): GetRecommendationsResponse
}

/**
 * Re-ranks a list of recommended items for the given user. The first item in the list is deemed the most likely item to be of interest to the user.
 *
 * The solution backing the campaign must have been created using a recipe of type PERSONALIZED_RANKING.
 */
public suspend inline fun PersonalizeRuntimeClient.getPersonalizedRanking(crossinline block: GetPersonalizedRankingRequest.Builder.() -> Unit): GetPersonalizedRankingResponse = getPersonalizedRanking(GetPersonalizedRankingRequest.Builder().apply(block).build())

/**
 * Returns a list of recommended items. For campaigns, the campaign's Amazon Resource Name (ARN) is required and the required user and item input depends on the recipe type used to create the solution backing the campaign as follows:
 * + USER_PERSONALIZATION - `userId` required, `itemId` not used
 * + RELATED_ITEMS - `itemId` required, `userId` not used
 *
 * Campaigns that are backed by a solution created using a recipe of type PERSONALIZED_RANKING use the API.
 *
 *  For recommenders, the recommender's ARN is required and the required item and user input depends on the use case (domain-based recipe) backing the recommender. For information on use case requirements see [Choosing recommender use cases](https://docs.aws.amazon.com/personalize/latest/dg/domain-use-cases.html).
 */
public suspend inline fun PersonalizeRuntimeClient.getRecommendations(crossinline block: GetRecommendationsRequest.Builder.() -> Unit): GetRecommendationsResponse = getRecommendations(GetRecommendationsRequest.Builder().apply(block).build())
