// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalizeruntime.model



public class GetPersonalizedRankingRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the campaign to use for generating the personalized ranking.
     */
    public val campaignArn: kotlin.String? = builder.campaignArn
    /**
     * The contextual metadata to use when getting recommendations. Contextual metadata includes any interaction information that might be relevant when getting a user's recommendations, such as the user's current location or device type.
     */
    public val context: Map<String, String>? = builder.context
    /**
     * The Amazon Resource Name (ARN) of a filter you created to include items or exclude items from recommendations for a given user. For more information, see [Filtering Recommendations](https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
     */
    public val filterArn: kotlin.String? = builder.filterArn
    /**
     * The values to use when filtering recommendations. For each placeholder parameter in your filter expression, provide the parameter name (in matching case) as a key and the filter value(s) as the corresponding value. Separate multiple values for one parameter with a comma.
     *
     * For filter expressions that use an `INCLUDE` element to include items, you must provide values for all parameters that are defined in the expression. For filters with expressions that use an `EXCLUDE` element to exclude items, you can omit the `filter-values`.In this case, Amazon Personalize doesn't use that portion of the expression to filter recommendations.
     *
     * For more information, see [Filtering Recommendations](https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
     */
    public val filterValues: Map<String, String>? = builder.filterValues
    /**
     * A list of items (by `itemId`) to rank. If an item was not included in the training dataset, the item is appended to the end of the reranked list. The maximum is 500.
     */
    public val inputList: List<String>? = builder.inputList
    /**
     * The user for which you want the campaign to provide a personalized ranking.
     */
    public val userId: kotlin.String? = builder.userId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalizeruntime.model.GetPersonalizedRankingRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetPersonalizedRankingRequest(")
        append("campaignArn=$campaignArn,")
        append("context=$context,")
        append("filterArn=$filterArn,")
        append("filterValues=$filterValues,")
        append("inputList=$inputList,")
        append("userId=$userId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = campaignArn?.hashCode() ?: 0
        result = 31 * result + (context?.hashCode() ?: 0)
        result = 31 * result + (filterArn?.hashCode() ?: 0)
        result = 31 * result + (filterValues?.hashCode() ?: 0)
        result = 31 * result + (inputList?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetPersonalizedRankingRequest

        if (campaignArn != other.campaignArn) return false
        if (context != other.context) return false
        if (filterArn != other.filterArn) return false
        if (filterValues != other.filterValues) return false
        if (inputList != other.inputList) return false
        if (userId != other.userId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalizeruntime.model.GetPersonalizedRankingRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the campaign to use for generating the personalized ranking.
         */
        public var campaignArn: kotlin.String? = null
        /**
         * The contextual metadata to use when getting recommendations. Contextual metadata includes any interaction information that might be relevant when getting a user's recommendations, such as the user's current location or device type.
         */
        public var context: Map<String, String>? = null
        /**
         * The Amazon Resource Name (ARN) of a filter you created to include items or exclude items from recommendations for a given user. For more information, see [Filtering Recommendations](https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
         */
        public var filterArn: kotlin.String? = null
        /**
         * The values to use when filtering recommendations. For each placeholder parameter in your filter expression, provide the parameter name (in matching case) as a key and the filter value(s) as the corresponding value. Separate multiple values for one parameter with a comma.
         *
         * For filter expressions that use an `INCLUDE` element to include items, you must provide values for all parameters that are defined in the expression. For filters with expressions that use an `EXCLUDE` element to exclude items, you can omit the `filter-values`.In this case, Amazon Personalize doesn't use that portion of the expression to filter recommendations.
         *
         * For more information, see [Filtering Recommendations](https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
         */
        public var filterValues: Map<String, String>? = null
        /**
         * A list of items (by `itemId`) to rank. If an item was not included in the training dataset, the item is appended to the end of the reranked list. The maximum is 500.
         */
        public var inputList: List<String>? = null
        /**
         * The user for which you want the campaign to provide a personalized ranking.
         */
        public var userId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalizeruntime.model.GetPersonalizedRankingRequest) : this() {
            this.campaignArn = x.campaignArn
            this.context = x.context
            this.filterArn = x.filterArn
            this.filterValues = x.filterValues
            this.inputList = x.inputList
            this.userId = x.userId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalizeruntime.model.GetPersonalizedRankingRequest = GetPersonalizedRankingRequest(this)
    }
}
