// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalizeruntime.model



/**
 * Contains information on a promotion. A promotion defines additional business rules that apply to a configurable subset of recommended items.
 */
public class Promotion private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the filter used by the promotion. This filter defines the criteria for promoted items. For more information, see [Promotion filters](https://docs.aws.amazon.com/personalize/latest/dg/promoting-items.html#promotion-filters).
     */
    public val filterArn: kotlin.String? = builder.filterArn
    /**
     * The values to use when promoting items. For each placeholder parameter in your promotion's filter expression, provide the parameter name (in matching case) as a key and the filter value(s) as the corresponding value. Separate multiple values for one parameter with a comma.
     *
     * For filter expressions that use an `INCLUDE` element to include items, you must provide values for all parameters that are defined in the expression. For filters with expressions that use an `EXCLUDE` element to exclude items, you can omit the `filter-values`. In this case, Amazon Personalize doesn't use that portion of the expression to filter recommendations.
     *
     * For more information on creating filters, see [Filtering recommendations and user segments](https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
     */
    public val filterValues: Map<String, String>? = builder.filterValues
    /**
     * The name of the promotion.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The percentage of recommended items to apply the promotion to.
     */
    public val percentPromotedItems: kotlin.Int = builder.percentPromotedItems

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalizeruntime.model.Promotion = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Promotion(")
        append("filterArn=$filterArn,")
        append("filterValues=$filterValues,")
        append("name=$name,")
        append("percentPromotedItems=$percentPromotedItems")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filterArn?.hashCode() ?: 0
        result = 31 * result + (filterValues?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (percentPromotedItems)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Promotion

        if (filterArn != other.filterArn) return false
        if (filterValues != other.filterValues) return false
        if (name != other.name) return false
        if (percentPromotedItems != other.percentPromotedItems) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalizeruntime.model.Promotion = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the filter used by the promotion. This filter defines the criteria for promoted items. For more information, see [Promotion filters](https://docs.aws.amazon.com/personalize/latest/dg/promoting-items.html#promotion-filters).
         */
        public var filterArn: kotlin.String? = null
        /**
         * The values to use when promoting items. For each placeholder parameter in your promotion's filter expression, provide the parameter name (in matching case) as a key and the filter value(s) as the corresponding value. Separate multiple values for one parameter with a comma.
         *
         * For filter expressions that use an `INCLUDE` element to include items, you must provide values for all parameters that are defined in the expression. For filters with expressions that use an `EXCLUDE` element to exclude items, you can omit the `filter-values`. In this case, Amazon Personalize doesn't use that portion of the expression to filter recommendations.
         *
         * For more information on creating filters, see [Filtering recommendations and user segments](https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
         */
        public var filterValues: Map<String, String>? = null
        /**
         * The name of the promotion.
         */
        public var name: kotlin.String? = null
        /**
         * The percentage of recommended items to apply the promotion to.
         */
        public var percentPromotedItems: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalizeruntime.model.Promotion) : this() {
            this.filterArn = x.filterArn
            this.filterValues = x.filterValues
            this.name = x.name
            this.percentPromotedItems = x.percentPromotedItems
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalizeruntime.model.Promotion = Promotion(this)
    }
}
