// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalizeruntime.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.personalizeruntime.model.GetRecommendationsResponse
import aws.sdk.kotlin.services.personalizeruntime.model.PersonalizeRuntimeException
import aws.sdk.kotlin.services.personalizeruntime.model.PredictedItem
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetRecommendationsOperationDeserializer: HttpDeserialize<GetRecommendationsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetRecommendationsResponse {
        if (!response.status.isSuccess()) {
            throwGetRecommendationsError(context, response)
        }
        val builder = GetRecommendationsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetRecommendationsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetRecommendationsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw PersonalizeRuntimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> PersonalizeRuntimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRecommendationsOperationBody(builder: GetRecommendationsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ITEMLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("itemList"))
    val RECOMMENDATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("recommendationId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ITEMLIST_DESCRIPTOR)
        field(RECOMMENDATIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ITEMLIST_DESCRIPTOR.index -> builder.itemList =
                    deserializer.deserializeList(ITEMLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<PredictedItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePredictedItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RECOMMENDATIONID_DESCRIPTOR.index -> builder.recommendationId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
