// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pi

import aws.sdk.kotlin.runtime.auth.signing.AwsSigV4SigningMiddleware
import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.pi.model.*
import aws.sdk.kotlin.services.pi.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.middleware.Retry
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "PI"
const val ServiceApiVersion: String = "2018-02-27"
const val SdkVersion: String = "0.13.0-beta"

internal class DefaultPiClient(override val config: PiClient.Config) : PiClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * For a specific time period, retrieve the top N dimension keys for a metric.
     *
     *
     * Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements,
     * only the first 500 bytes are returned.
     */
    override suspend fun describeDimensionKeys(input: DescribeDimensionKeysRequest): DescribeDimensionKeysResponse {
        val op = SdkHttpOperation.build<DescribeDimensionKeysRequest, DescribeDimensionKeysResponse> {
            serializer = DescribeDimensionKeysOperationSerializer()
            deserializer = DescribeDimensionKeysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDimensionKeys"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PerformanceInsightsv20180227", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "pi"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get the attributes of the specified dimension group for a DB instance or data source.
     * For example, if you specify a SQL ID, GetDimensionKeyDetails retrieves
     * the full text of the dimension db.sql.statementcassociated with this ID.
     * This operation is useful because GetResourceMetrics and DescribeDimensionKeys
     * don't support retrieval of large SQL statement text.
     */
    override suspend fun getDimensionKeyDetails(input: GetDimensionKeyDetailsRequest): GetDimensionKeyDetailsResponse {
        val op = SdkHttpOperation.build<GetDimensionKeyDetailsRequest, GetDimensionKeyDetailsResponse> {
            serializer = GetDimensionKeyDetailsOperationSerializer()
            deserializer = GetDimensionKeyDetailsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDimensionKeyDetails"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PerformanceInsightsv20180227", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "pi"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve the metadata for different features. For example, the metadata might indicate
     * that a feature is turned on or off on a specific DB instance.
     */
    override suspend fun getResourceMetadata(input: GetResourceMetadataRequest): GetResourceMetadataResponse {
        val op = SdkHttpOperation.build<GetResourceMetadataRequest, GetResourceMetadataResponse> {
            serializer = GetResourceMetadataOperationSerializer()
            deserializer = GetResourceMetadataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetResourceMetadata"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PerformanceInsightsv20180227", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "pi"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve Performance Insights metrics for a set of data sources, over a time period. You can provide
     * specific dimension groups and dimensions, and provide aggregation and filtering criteria for
     * each group.
     *
     * Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements,
     * only the first 500 bytes are returned.
     */
    override suspend fun getResourceMetrics(input: GetResourceMetricsRequest): GetResourceMetricsResponse {
        val op = SdkHttpOperation.build<GetResourceMetricsRequest, GetResourceMetricsResponse> {
            serializer = GetResourceMetricsOperationSerializer()
            deserializer = GetResourceMetricsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetResourceMetrics"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PerformanceInsightsv20180227", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "pi"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve the dimensions that can be queried for each specified metric type on a specified DB instance.
     */
    override suspend fun listAvailableResourceDimensions(input: ListAvailableResourceDimensionsRequest): ListAvailableResourceDimensionsResponse {
        val op = SdkHttpOperation.build<ListAvailableResourceDimensionsRequest, ListAvailableResourceDimensionsResponse> {
            serializer = ListAvailableResourceDimensionsOperationSerializer()
            deserializer = ListAvailableResourceDimensionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAvailableResourceDimensions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PerformanceInsightsv20180227", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "pi"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve metrics of the specified types that can be queried for a specified DB instance.
     */
    override suspend fun listAvailableResourceMetrics(input: ListAvailableResourceMetricsRequest): ListAvailableResourceMetricsResponse {
        val op = SdkHttpOperation.build<ListAvailableResourceMetricsRequest, ListAvailableResourceMetricsResponse> {
            serializer = ListAvailableResourceMetricsOperationSerializer()
            deserializer = ListAvailableResourceMetricsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAvailableResourceMetrics"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PerformanceInsightsv20180227", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "pi"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
