// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pi

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.pi.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.pi.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.delay.StandardRetryTokenBucketOptions

/**
 * <fullname>Amazon RDS Performance Insights</fullname>
 *
 * Amazon RDS Performance Insights enables you to monitor and explore different dimensions of database load based on
 * data captured from a running DB instance. The guide provides detailed information about Performance Insights
 * data types, parameters and errors.
 *
 *
 * When Performance Insights is enabled, the Amazon RDS Performance Insights API provides visibility into the performance of your DB instance.
 * Amazon CloudWatch provides the authoritative source for Amazon Web Services service-vended monitoring metrics.
 * Performance Insights offers a domain-specific view of DB load.
 *
 * DB load is measured as average active sessions. Performance Insights provides the data to API consumers as a two-dimensional
 * time-series dataset. The time dimension provides DB load data for each time point in the
 * queried time range. Each time point decomposes overall load in relation to the requested dimensions,
 * measured at that time point. Examples include SQL, Wait event, User, and Host.
 *
 *
 *
 *
 * To learn more about Performance Insights and Amazon Aurora DB instances, go to the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights.html"> Amazon Aurora User Guide.
 *
 * To learn more about Performance Insights and Amazon RDS DB instances, go to the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Amazon RDS User Guide.
 */
interface PiClient : SdkClient {

    override val serviceName: String
        get() = "PI"
    /**
     * PiClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): PiClient {
            val config = Config.Builder().apply(block).build()
            return DefaultPiClient(config)
        }

        operator fun invoke(config: Config): PiClient = DefaultPiClient(config)

        /**
         * Construct a [PiClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): PiClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultPiClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * For a specific time period, retrieve the top N dimension keys for a metric.
     *
     *
     * Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements,
     * only the first 500 bytes are returned.
     */
    suspend fun describeDimensionKeys(input: DescribeDimensionKeysRequest): DescribeDimensionKeysResponse

    /**
     * For a specific time period, retrieve the top N dimension keys for a metric.
     *
     *
     * Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements,
     * only the first 500 bytes are returned.
     */
    suspend fun describeDimensionKeys(block: DescribeDimensionKeysRequest.Builder.() -> Unit) = describeDimensionKeys(DescribeDimensionKeysRequest.Builder().apply(block).build())

    /**
     * Get the attributes of the specified dimension group for a DB instance or data source.
     * For example, if you specify a SQL ID, GetDimensionKeyDetails retrieves
     * the full text of the dimension db.sql.statementcassociated with this ID.
     * This operation is useful because GetResourceMetrics and DescribeDimensionKeys
     * don't support retrieval of large SQL statement text.
     */
    suspend fun getDimensionKeyDetails(input: GetDimensionKeyDetailsRequest): GetDimensionKeyDetailsResponse

    /**
     * Get the attributes of the specified dimension group for a DB instance or data source.
     * For example, if you specify a SQL ID, GetDimensionKeyDetails retrieves
     * the full text of the dimension db.sql.statementcassociated with this ID.
     * This operation is useful because GetResourceMetrics and DescribeDimensionKeys
     * don't support retrieval of large SQL statement text.
     */
    suspend fun getDimensionKeyDetails(block: GetDimensionKeyDetailsRequest.Builder.() -> Unit) = getDimensionKeyDetails(GetDimensionKeyDetailsRequest.Builder().apply(block).build())

    /**
     * Retrieve the metadata for different features. For example, the metadata might indicate
     * that a feature is turned on or off on a specific DB instance.
     */
    suspend fun getResourceMetadata(input: GetResourceMetadataRequest): GetResourceMetadataResponse

    /**
     * Retrieve the metadata for different features. For example, the metadata might indicate
     * that a feature is turned on or off on a specific DB instance.
     */
    suspend fun getResourceMetadata(block: GetResourceMetadataRequest.Builder.() -> Unit) = getResourceMetadata(GetResourceMetadataRequest.Builder().apply(block).build())

    /**
     * Retrieve Performance Insights metrics for a set of data sources, over a time period. You can provide
     * specific dimension groups and dimensions, and provide aggregation and filtering criteria for
     * each group.
     *
     * Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements,
     * only the first 500 bytes are returned.
     */
    suspend fun getResourceMetrics(input: GetResourceMetricsRequest): GetResourceMetricsResponse

    /**
     * Retrieve Performance Insights metrics for a set of data sources, over a time period. You can provide
     * specific dimension groups and dimensions, and provide aggregation and filtering criteria for
     * each group.
     *
     * Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements,
     * only the first 500 bytes are returned.
     */
    suspend fun getResourceMetrics(block: GetResourceMetricsRequest.Builder.() -> Unit) = getResourceMetrics(GetResourceMetricsRequest.Builder().apply(block).build())

    /**
     * Retrieve the dimensions that can be queried for each specified metric type on a specified DB instance.
     */
    suspend fun listAvailableResourceDimensions(input: ListAvailableResourceDimensionsRequest): ListAvailableResourceDimensionsResponse

    /**
     * Retrieve the dimensions that can be queried for each specified metric type on a specified DB instance.
     */
    suspend fun listAvailableResourceDimensions(block: ListAvailableResourceDimensionsRequest.Builder.() -> Unit) = listAvailableResourceDimensions(ListAvailableResourceDimensionsRequest.Builder().apply(block).build())

    /**
     * Retrieve metrics of the specified types that can be queried for a specified DB instance.
     */
    suspend fun listAvailableResourceMetrics(input: ListAvailableResourceMetricsRequest): ListAvailableResourceMetricsResponse

    /**
     * Retrieve metrics of the specified types that can be queried for a specified DB instance.
     */
    suspend fun listAvailableResourceMetrics(block: ListAvailableResourceMetricsRequest.Builder.() -> Unit) = listAvailableResourceMetrics(ListAvailableResourceMetricsRequest.Builder().apply(block).build())
}
