// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pi.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeDimensionKeysRequest private constructor(builder: Builder) {
    /**
     * Additional metrics for the top N dimension keys.
     * If the specified dimension group in the GroupBy parameter is db.sql_tokenized, you can
     * specify per-SQL metrics to get the values for the top N SQL digests. The response syntax is
     * "AdditionalMetrics" : { "string" : "string" }.
     */
    val additionalMetrics: List<String>? = builder.additionalMetrics
    /**
     * The date and time specifying the end of the requested time series data. The value specified is
     * exclusive, which means that data points less than (but not equal to) EndTime are
     * returned.
     * The value for EndTime must be later than the value for
     * StartTime.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * One or more filters to apply in the request. Restrictions:
     *
     *
     * Any number of filters by the same dimension, as specified in the GroupBy or
     * Partition parameters.
     *
     * A single filter for any other dimension in this dimension group.
     */
    val filter: Map<String, String>? = builder.filter
    /**
     * A specification for how to aggregate the data points from a query result. You must specify
     * a valid dimension group. Performance Insights returns all dimensions within this group, unless you provide
     * the names of specific dimensions within this group. You can also request that Performance Insights return
     * a limited number of values for a dimension.
     */
    val groupBy: aws.sdk.kotlin.services.pi.model.DimensionGroup? = builder.groupBy
    /**
     * An immutable, Amazon Web Services Region-unique identifier for a data source. Performance Insights gathers metrics from
     * this data source.
     * To use an Amazon RDS instance as a data source, you specify its DbiResourceId value.
     * For example, specify db-FAIHNTYBKTGAUSUZQYPDS2GW4A.
     */
    val identifier: kotlin.String? = builder.identifier
    /**
     * The maximum number of items to return in the response. If more items exist than the
     * specified MaxRecords value, a pagination token is included in the response
     * so that the remaining results can be retrieved.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The name of a Performance Insights metric to be measured.
     * Valid values for Metric are:
     *
     *
     *
     *
     * db.load.avg - a scaled representation of the number of active sessions for the database engine.
     *
     *
     * db.sampledload.avg - the raw number of active sessions for the database engine.
     *
     *
     * If the number of active sessions is less than an internal Performance Insights threshold, db.load.avg
     * and db.sampledload.avg are the same value. If the number of active sessions is greater than
     * the internal threshold, Performance Insights samples the active sessions, with db.load.avg
     * showing the scaled values, db.sampledload.avg showing the raw values, and
     * db.sampledload.avg less than db.load.avg. For most use cases, you can
     * query db.load.avg only.
     */
    val metric: kotlin.String? = builder.metric
    /**
     * An optional pagination token provided by a previous request. If this parameter is specified,
     * the response includes only records beyond the token, up to the value specified by MaxRecords.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * For each dimension specified in GroupBy, specify a secondary dimension
     * to further subdivide the partition keys in the response.
     */
    val partitionBy: aws.sdk.kotlin.services.pi.model.DimensionGroup? = builder.partitionBy
    /**
     * The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short as
     * one second, or as long as one day (86400 seconds). Valid values are:
     *
     *
     *
     *
     * 1 (one second)
     *
     *
     * 60 (one minute)
     *
     *
     * 300 (five minutes)
     *
     *
     * 3600 (one hour)
     *
     *
     * 86400 (twenty-four hours)
     *
     *
     *
     * If you don't specify PeriodInSeconds, then Performance Insights chooses a value for you, with a
     * goal of returning roughly 100-200 data points in the response.
     */
    val periodInSeconds: kotlin.Int? = builder.periodInSeconds
    /**
     * The Amazon Web Services service for which Performance Insights will return metrics. The only valid value for
     * ServiceType is RDS.
     */
    val serviceType: aws.sdk.kotlin.services.pi.model.ServiceType? = builder.serviceType
    /**
     * The date and time specifying the beginning of the requested time series data. You must specify a
     * StartTime within the past 7 days. The value specified is inclusive,
     * which means that data points equal to or greater than StartTime are returned.
     *
     * The value for StartTime must be earlier than the value for EndTime.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pi.model.DescribeDimensionKeysRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDimensionKeysRequest(")
        append("additionalMetrics=$additionalMetrics,")
        append("endTime=$endTime,")
        append("filter=$filter,")
        append("groupBy=$groupBy,")
        append("identifier=$identifier,")
        append("maxResults=$maxResults,")
        append("metric=$metric,")
        append("nextToken=$nextToken,")
        append("partitionBy=$partitionBy,")
        append("periodInSeconds=$periodInSeconds,")
        append("serviceType=$serviceType,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalMetrics?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (groupBy?.hashCode() ?: 0)
        result = 31 * result + (identifier?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (metric?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (partitionBy?.hashCode() ?: 0)
        result = 31 * result + (periodInSeconds ?: 0)
        result = 31 * result + (serviceType?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDimensionKeysRequest

        if (additionalMetrics != other.additionalMetrics) return false
        if (endTime != other.endTime) return false
        if (filter != other.filter) return false
        if (groupBy != other.groupBy) return false
        if (identifier != other.identifier) return false
        if (maxResults != other.maxResults) return false
        if (metric != other.metric) return false
        if (nextToken != other.nextToken) return false
        if (partitionBy != other.partitionBy) return false
        if (periodInSeconds != other.periodInSeconds) return false
        if (serviceType != other.serviceType) return false
        if (startTime != other.startTime) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pi.model.DescribeDimensionKeysRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Additional metrics for the top N dimension keys.
         * If the specified dimension group in the GroupBy parameter is db.sql_tokenized, you can
         * specify per-SQL metrics to get the values for the top N SQL digests. The response syntax is
         * "AdditionalMetrics" : { "string" : "string" }.
         */
        var additionalMetrics: List<String>? = null
        /**
         * The date and time specifying the end of the requested time series data. The value specified is
         * exclusive, which means that data points less than (but not equal to) EndTime are
         * returned.
         * The value for EndTime must be later than the value for
         * StartTime.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * One or more filters to apply in the request. Restrictions:
         *
         *
         * Any number of filters by the same dimension, as specified in the GroupBy or
         * Partition parameters.
         *
         * A single filter for any other dimension in this dimension group.
         */
        var filter: Map<String, String>? = null
        /**
         * A specification for how to aggregate the data points from a query result. You must specify
         * a valid dimension group. Performance Insights returns all dimensions within this group, unless you provide
         * the names of specific dimensions within this group. You can also request that Performance Insights return
         * a limited number of values for a dimension.
         */
        var groupBy: aws.sdk.kotlin.services.pi.model.DimensionGroup? = null
        /**
         * An immutable, Amazon Web Services Region-unique identifier for a data source. Performance Insights gathers metrics from
         * this data source.
         * To use an Amazon RDS instance as a data source, you specify its DbiResourceId value.
         * For example, specify db-FAIHNTYBKTGAUSUZQYPDS2GW4A.
         */
        var identifier: kotlin.String? = null
        /**
         * The maximum number of items to return in the response. If more items exist than the
         * specified MaxRecords value, a pagination token is included in the response
         * so that the remaining results can be retrieved.
         */
        var maxResults: kotlin.Int? = null
        /**
         * The name of a Performance Insights metric to be measured.
         * Valid values for Metric are:
         *
         *
         *
         *
         * db.load.avg - a scaled representation of the number of active sessions for the database engine.
         *
         *
         * db.sampledload.avg - the raw number of active sessions for the database engine.
         *
         *
         * If the number of active sessions is less than an internal Performance Insights threshold, db.load.avg
         * and db.sampledload.avg are the same value. If the number of active sessions is greater than
         * the internal threshold, Performance Insights samples the active sessions, with db.load.avg
         * showing the scaled values, db.sampledload.avg showing the raw values, and
         * db.sampledload.avg less than db.load.avg. For most use cases, you can
         * query db.load.avg only.
         */
        var metric: kotlin.String? = null
        /**
         * An optional pagination token provided by a previous request. If this parameter is specified,
         * the response includes only records beyond the token, up to the value specified by MaxRecords.
         */
        var nextToken: kotlin.String? = null
        /**
         * For each dimension specified in GroupBy, specify a secondary dimension
         * to further subdivide the partition keys in the response.
         */
        var partitionBy: aws.sdk.kotlin.services.pi.model.DimensionGroup? = null
        /**
         * The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short as
         * one second, or as long as one day (86400 seconds). Valid values are:
         *
         *
         *
         *
         * 1 (one second)
         *
         *
         * 60 (one minute)
         *
         *
         * 300 (five minutes)
         *
         *
         * 3600 (one hour)
         *
         *
         * 86400 (twenty-four hours)
         *
         *
         *
         * If you don't specify PeriodInSeconds, then Performance Insights chooses a value for you, with a
         * goal of returning roughly 100-200 data points in the response.
         */
        var periodInSeconds: kotlin.Int? = null
        /**
         * The Amazon Web Services service for which Performance Insights will return metrics. The only valid value for
         * ServiceType is RDS.
         */
        var serviceType: aws.sdk.kotlin.services.pi.model.ServiceType? = null
        /**
         * The date and time specifying the beginning of the requested time series data. You must specify a
         * StartTime within the past 7 days. The value specified is inclusive,
         * which means that data points equal to or greater than StartTime are returned.
         *
         * The value for StartTime must be earlier than the value for EndTime.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pi.model.DescribeDimensionKeysRequest) : this() {
            this.additionalMetrics = x.additionalMetrics
            this.endTime = x.endTime
            this.filter = x.filter
            this.groupBy = x.groupBy
            this.identifier = x.identifier
            this.maxResults = x.maxResults
            this.metric = x.metric
            this.nextToken = x.nextToken
            this.partitionBy = x.partitionBy
            this.periodInSeconds = x.periodInSeconds
            this.serviceType = x.serviceType
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pi.model.DescribeDimensionKeysRequest = DescribeDimensionKeysRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.pi.model.DimensionGroup] inside the given [block]
         */
        fun groupBy(block: aws.sdk.kotlin.services.pi.model.DimensionGroup.Builder.() -> kotlin.Unit) {
            this.groupBy = aws.sdk.kotlin.services.pi.model.DimensionGroup.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pi.model.DimensionGroup] inside the given [block]
         */
        fun partitionBy(block: aws.sdk.kotlin.services.pi.model.DimensionGroup.Builder.() -> kotlin.Unit) {
            this.partitionBy = aws.sdk.kotlin.services.pi.model.DimensionGroup.invoke(block)
        }
    }
}
