// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pi.model



/**
 * A logical grouping of Performance Insights metrics for a related subject area. For example, the
 * db.sql dimension group consists of the following dimensions:
 * db.sql.id, db.sql.db_id, db.sql.statement, and
 * db.sql.tokenized_id.
 *
 * Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements,
 * only the first 500 bytes are returned.
 */
class DimensionGroup private constructor(builder: Builder) {
    /**
     * A list of specific dimensions from a dimension group. If this parameter is not present,
     * then it signifies that all of the dimensions in the group were requested, or are present in
     * the response.
     * Valid values for elements in the Dimensions array are:
     *
     *
     *
     *
     * db.application.name - The name of the application that is connected to the database (only
     * Aurora PostgreSQL and RDS PostgreSQL)
     *
     *
     * db.host.id - The host ID of the connected client (all engines)
     *
     *
     * db.host.name - The host name of the connected client (all engines)
     *
     *
     * db.name - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon RDS
     * PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)
     *
     *
     * db.session_type.name - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)
     *
     *
     * db.sql.id - The SQL ID generated by Performance Insights (all engines)
     *
     *
     * db.sql.db_id - The SQL ID generated by the database (all engines)
     *
     *
     * db.sql.statement - The SQL text that is being executed (all engines)
     *
     *
     * db.sql.tokenized_id
     *
     *
     *
     * db.sql_tokenized.id - The SQL digest ID generated by Performance Insights (all engines)
     *
     *
     * db.sql_tokenized.db_id - SQL digest ID generated by the database (all engines)
     *
     *
     * db.sql_tokenized.statement - The SQL digest text (all engines)
     *
     *
     * db.user.id - The ID of the user logged in to the database (all engines)
     *
     *
     * db.user.name - The name of the user logged in to the database (all engines)
     *
     *
     * db.wait_event.name - The event for which the backend is waiting (all engines)
     *
     *
     * db.wait_event.type - The type of event for which the backend is waiting (all engines)
     *
     *
     * db.wait_event_type.name - The name of the event type for which the backend is waiting (all
     * engines)
     */
    val dimensions: List<String>? = builder.dimensions
    /**
     * The name of the dimension group.  Valid values are:
     *
     *
     *
     *
     * db - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon RDS PostgreSQL,
     * Aurora MySQL, Amazon RDS MySQL, and MariaDB)
     *
     *
     * db.application - The name of the application that is connected to the database (only Aurora
     * PostgreSQL and RDS PostgreSQL)
     *
     *
     * db.host - The host name of the connected client (all engines)
     *
     *
     * db.session_type - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)
     *
     *
     * db.sql - The SQL that is currently executing (all engines)
     *
     *
     * db.sql_tokenized - The SQL digest (all engines)
     *
     *
     * db.wait_event - The event for which the database backend is waiting  (all engines)
     *
     *
     * db.wait_event_type - The type of event for which the database backend is waiting (all engines)
     *
     *
     * db.user - The user logged in to the database (all engines)
     */
    val group: kotlin.String? = builder.group
    /**
     * The maximum number of items to fetch for this dimension group.
     */
    val limit: kotlin.Int? = builder.limit

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pi.model.DimensionGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DimensionGroup(")
        append("dimensions=$dimensions,")
        append("group=$group,")
        append("limit=$limit)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dimensions?.hashCode() ?: 0
        result = 31 * result + (group?.hashCode() ?: 0)
        result = 31 * result + (limit ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DimensionGroup

        if (dimensions != other.dimensions) return false
        if (group != other.group) return false
        if (limit != other.limit) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pi.model.DimensionGroup = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of specific dimensions from a dimension group. If this parameter is not present,
         * then it signifies that all of the dimensions in the group were requested, or are present in
         * the response.
         * Valid values for elements in the Dimensions array are:
         *
         *
         *
         *
         * db.application.name - The name of the application that is connected to the database (only
         * Aurora PostgreSQL and RDS PostgreSQL)
         *
         *
         * db.host.id - The host ID of the connected client (all engines)
         *
         *
         * db.host.name - The host name of the connected client (all engines)
         *
         *
         * db.name - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon RDS
         * PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)
         *
         *
         * db.session_type.name - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)
         *
         *
         * db.sql.id - The SQL ID generated by Performance Insights (all engines)
         *
         *
         * db.sql.db_id - The SQL ID generated by the database (all engines)
         *
         *
         * db.sql.statement - The SQL text that is being executed (all engines)
         *
         *
         * db.sql.tokenized_id
         *
         *
         *
         * db.sql_tokenized.id - The SQL digest ID generated by Performance Insights (all engines)
         *
         *
         * db.sql_tokenized.db_id - SQL digest ID generated by the database (all engines)
         *
         *
         * db.sql_tokenized.statement - The SQL digest text (all engines)
         *
         *
         * db.user.id - The ID of the user logged in to the database (all engines)
         *
         *
         * db.user.name - The name of the user logged in to the database (all engines)
         *
         *
         * db.wait_event.name - The event for which the backend is waiting (all engines)
         *
         *
         * db.wait_event.type - The type of event for which the backend is waiting (all engines)
         *
         *
         * db.wait_event_type.name - The name of the event type for which the backend is waiting (all
         * engines)
         */
        var dimensions: List<String>? = null
        /**
         * The name of the dimension group.  Valid values are:
         *
         *
         *
         *
         * db - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon RDS PostgreSQL,
         * Aurora MySQL, Amazon RDS MySQL, and MariaDB)
         *
         *
         * db.application - The name of the application that is connected to the database (only Aurora
         * PostgreSQL and RDS PostgreSQL)
         *
         *
         * db.host - The host name of the connected client (all engines)
         *
         *
         * db.session_type - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)
         *
         *
         * db.sql - The SQL that is currently executing (all engines)
         *
         *
         * db.sql_tokenized - The SQL digest (all engines)
         *
         *
         * db.wait_event - The event for which the database backend is waiting  (all engines)
         *
         *
         * db.wait_event_type - The type of event for which the database backend is waiting (all engines)
         *
         *
         * db.user - The user logged in to the database (all engines)
         */
        var group: kotlin.String? = null
        /**
         * The maximum number of items to fetch for this dimension group.
         */
        var limit: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pi.model.DimensionGroup) : this() {
            this.dimensions = x.dimensions
            this.group = x.group
            this.limit = x.limit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pi.model.DimensionGroup = DimensionGroup(this)
    }
}
