// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pi.model

import aws.smithy.kotlin.runtime.time.Instant

class GetResourceMetricsRequest private constructor(builder: Builder) {
    /**
     * The date and time specifying the end of the requested time series data.  The value specified is
     * exclusive - data points less than (but not equal to) EndTime will be returned.
     * The value for EndTime must be later than the value for StartTime.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * An immutable, Amazon Web Services Region-unique identifier for a data source. Performance Insights gathers metrics from
     * this data source.
     * To use a DB instance as a data source, specify its DbiResourceId value. For example, specify
     * db-FAIHNTYBKTGAUSUZQYPDS2GW4A.
     */
    val identifier: kotlin.String? = builder.identifier
    /**
     * The maximum number of items to return in the response.
     * If more items exist than the specified MaxRecords value, a pagination
     * token is included in the response so that the remaining
     * results can be retrieved.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * An array of one or more queries to perform. Each query must specify a Performance Insights metric, and
     * can optionally specify aggregation and filtering criteria.
     */
    val metricQueries: List<MetricQuery>? = builder.metricQueries
    /**
     * An optional pagination token provided by a previous request. If
     * this parameter is specified, the response includes only records beyond the token, up to the
     * value specified by MaxRecords.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short as
     * one second, or as long as one day (86400 seconds).  Valid values are:
     *
     *
     *
     *
     * 1 (one second)
     *
     *
     * 60 (one minute)
     *
     *
     * 300 (five minutes)
     *
     *
     * 3600 (one hour)
     *
     *
     * 86400 (twenty-four hours)
     *
     *
     *
     * If you don't specify PeriodInSeconds, then Performance Insights will choose a value for
     * you, with a goal of returning roughly 100-200 data points in the response.
     */
    val periodInSeconds: kotlin.Int? = builder.periodInSeconds
    /**
     * The Amazon Web Services service for which Performance Insights returns metrics. The only valid value for ServiceType is
     * RDS.
     */
    val serviceType: aws.sdk.kotlin.services.pi.model.ServiceType? = builder.serviceType
    /**
     * The date and time specifying the beginning of the requested time series data. You can't
     * specify a StartTime that's earlier than 7 days ago. The value specified is
     * inclusive - data points equal to or greater than StartTime
     * will be returned.
     * The value for StartTime must be earlier than the value for EndTime.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pi.model.GetResourceMetricsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetResourceMetricsRequest(")
        append("endTime=$endTime,")
        append("identifier=$identifier,")
        append("maxResults=$maxResults,")
        append("metricQueries=$metricQueries,")
        append("nextToken=$nextToken,")
        append("periodInSeconds=$periodInSeconds,")
        append("serviceType=$serviceType,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (identifier?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (metricQueries?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (periodInSeconds ?: 0)
        result = 31 * result + (serviceType?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetResourceMetricsRequest

        if (endTime != other.endTime) return false
        if (identifier != other.identifier) return false
        if (maxResults != other.maxResults) return false
        if (metricQueries != other.metricQueries) return false
        if (nextToken != other.nextToken) return false
        if (periodInSeconds != other.periodInSeconds) return false
        if (serviceType != other.serviceType) return false
        if (startTime != other.startTime) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pi.model.GetResourceMetricsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time specifying the end of the requested time series data.  The value specified is
         * exclusive - data points less than (but not equal to) EndTime will be returned.
         * The value for EndTime must be later than the value for StartTime.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An immutable, Amazon Web Services Region-unique identifier for a data source. Performance Insights gathers metrics from
         * this data source.
         * To use a DB instance as a data source, specify its DbiResourceId value. For example, specify
         * db-FAIHNTYBKTGAUSUZQYPDS2GW4A.
         */
        var identifier: kotlin.String? = null
        /**
         * The maximum number of items to return in the response.
         * If more items exist than the specified MaxRecords value, a pagination
         * token is included in the response so that the remaining
         * results can be retrieved.
         */
        var maxResults: kotlin.Int? = null
        /**
         * An array of one or more queries to perform. Each query must specify a Performance Insights metric, and
         * can optionally specify aggregation and filtering criteria.
         */
        var metricQueries: List<MetricQuery>? = null
        /**
         * An optional pagination token provided by a previous request. If
         * this parameter is specified, the response includes only records beyond the token, up to the
         * value specified by MaxRecords.
         */
        var nextToken: kotlin.String? = null
        /**
         * The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short as
         * one second, or as long as one day (86400 seconds).  Valid values are:
         *
         *
         *
         *
         * 1 (one second)
         *
         *
         * 60 (one minute)
         *
         *
         * 300 (five minutes)
         *
         *
         * 3600 (one hour)
         *
         *
         * 86400 (twenty-four hours)
         *
         *
         *
         * If you don't specify PeriodInSeconds, then Performance Insights will choose a value for
         * you, with a goal of returning roughly 100-200 data points in the response.
         */
        var periodInSeconds: kotlin.Int? = null
        /**
         * The Amazon Web Services service for which Performance Insights returns metrics. The only valid value for ServiceType is
         * RDS.
         */
        var serviceType: aws.sdk.kotlin.services.pi.model.ServiceType? = null
        /**
         * The date and time specifying the beginning of the requested time series data. You can't
         * specify a StartTime that's earlier than 7 days ago. The value specified is
         * inclusive - data points equal to or greater than StartTime
         * will be returned.
         * The value for StartTime must be earlier than the value for EndTime.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pi.model.GetResourceMetricsRequest) : this() {
            this.endTime = x.endTime
            this.identifier = x.identifier
            this.maxResults = x.maxResults
            this.metricQueries = x.metricQueries
            this.nextToken = x.nextToken
            this.periodInSeconds = x.periodInSeconds
            this.serviceType = x.serviceType
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pi.model.GetResourceMetricsRequest = GetResourceMetricsRequest(this)
    }
}
