// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pi.model



/**
 * A single query to be processed. You must provide the metric to query. If no other
 * parameters are specified, Performance Insights returns all data points for the specified metric. Optionally, you can
 * request that the data points be aggregated by dimension group (GroupBy), and return only
 * those data points that match your criteria (Filter).
 */
class MetricQuery private constructor(builder: Builder) {
    /**
     * One or more filters to apply in the request.  Restrictions:
     *
     *
     * Any number of filters by the same dimension, as specified in the GroupBy parameter.
     *
     * A single filter for any other dimension in this dimension group.
     */
    val filter: Map<String, String>? = builder.filter
    /**
     * A specification for how to aggregate the data points from a query result. You must
     * specify a valid dimension group.  Performance Insights will return all of the dimensions within that group,
     * unless you provide the names of specific dimensions within that group. You can also request
     * that Performance Insights return a limited number of values for a dimension.
     */
    val groupBy: aws.sdk.kotlin.services.pi.model.DimensionGroup? = builder.groupBy
    /**
     * The name of a Performance Insights metric to be measured.
     * Valid values for Metric are:
     *
     *
     *
     *
     * db.load.avg - a scaled representation of the number of active sessions
     * for the database engine.
     *
     *
     * db.sampledload.avg - the raw number of active sessions for the
     * database engine.
     *
     *
     * If the number of active sessions is less than an internal Performance Insights threshold, db.load.avg and db.sampledload.avg
     * are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with db.load.avg
     * showing the scaled values, db.sampledload.avg showing the raw values, and db.sampledload.avg less than db.load.avg.
     * For most use cases, you can query db.load.avg only.
     */
    val metric: kotlin.String? = builder.metric

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pi.model.MetricQuery = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetricQuery(")
        append("filter=$filter,")
        append("groupBy=$groupBy,")
        append("metric=$metric)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filter?.hashCode() ?: 0
        result = 31 * result + (groupBy?.hashCode() ?: 0)
        result = 31 * result + (metric?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetricQuery

        if (filter != other.filter) return false
        if (groupBy != other.groupBy) return false
        if (metric != other.metric) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pi.model.MetricQuery = Builder(this).apply(block).build()

    class Builder {
        /**
         * One or more filters to apply in the request.  Restrictions:
         *
         *
         * Any number of filters by the same dimension, as specified in the GroupBy parameter.
         *
         * A single filter for any other dimension in this dimension group.
         */
        var filter: Map<String, String>? = null
        /**
         * A specification for how to aggregate the data points from a query result. You must
         * specify a valid dimension group.  Performance Insights will return all of the dimensions within that group,
         * unless you provide the names of specific dimensions within that group. You can also request
         * that Performance Insights return a limited number of values for a dimension.
         */
        var groupBy: aws.sdk.kotlin.services.pi.model.DimensionGroup? = null
        /**
         * The name of a Performance Insights metric to be measured.
         * Valid values for Metric are:
         *
         *
         *
         *
         * db.load.avg - a scaled representation of the number of active sessions
         * for the database engine.
         *
         *
         * db.sampledload.avg - the raw number of active sessions for the
         * database engine.
         *
         *
         * If the number of active sessions is less than an internal Performance Insights threshold, db.load.avg and db.sampledload.avg
         * are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with db.load.avg
         * showing the scaled values, db.sampledload.avg showing the raw values, and db.sampledload.avg less than db.load.avg.
         * For most use cases, you can query db.load.avg only.
         */
        var metric: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pi.model.MetricQuery) : this() {
            this.filter = x.filter
            this.groupBy = x.groupBy
            this.metric = x.metric
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pi.model.MetricQuery = MetricQuery(this)

        /**
         * construct an [aws.sdk.kotlin.services.pi.model.DimensionGroup] inside the given [block]
         */
        fun groupBy(block: aws.sdk.kotlin.services.pi.model.DimensionGroup.Builder.() -> kotlin.Unit) {
            this.groupBy = aws.sdk.kotlin.services.pi.model.DimensionGroup.invoke(block)
        }
    }
}
