// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pi.model



/**
 * An object describing a Performance Insights metric and one or more dimensions for that metric.
 */
class ResponseResourceMetricKey private constructor(builder: Builder) {
    /**
     * The valid dimensions for the metric.
     */
    val dimensions: Map<String, String>? = builder.dimensions
    /**
     * The name of a Performance Insights metric to be measured.
     * Valid values for Metric are:
     *
     *
     *
     *
     * db.load.avg - a scaled representation of the number of active sessions
     * for the database engine.
     *
     *
     * db.sampledload.avg - the raw number of active sessions for the
     * database engine.
     *
     *
     * If the number of active sessions is less than an internal Performance Insights threshold, db.load.avg and
     * db.sampledload.avg are the same value. If the number of active sessions is greater than the
     * internal threshold, Performance Insights samples the active sessions, with db.load.avg showing the scaled values,
     * db.sampledload.avg showing the raw values, and db.sampledload.avg less
     * than db.load.avg. For most use cases, you can query db.load.avg only.
     */
    val metric: kotlin.String? = builder.metric

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pi.model.ResponseResourceMetricKey = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResponseResourceMetricKey(")
        append("dimensions=$dimensions,")
        append("metric=$metric)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dimensions?.hashCode() ?: 0
        result = 31 * result + (metric?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResponseResourceMetricKey

        if (dimensions != other.dimensions) return false
        if (metric != other.metric) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pi.model.ResponseResourceMetricKey = Builder(this).apply(block).build()

    class Builder {
        /**
         * The valid dimensions for the metric.
         */
        var dimensions: Map<String, String>? = null
        /**
         * The name of a Performance Insights metric to be measured.
         * Valid values for Metric are:
         *
         *
         *
         *
         * db.load.avg - a scaled representation of the number of active sessions
         * for the database engine.
         *
         *
         * db.sampledload.avg - the raw number of active sessions for the
         * database engine.
         *
         *
         * If the number of active sessions is less than an internal Performance Insights threshold, db.load.avg and
         * db.sampledload.avg are the same value. If the number of active sessions is greater than the
         * internal threshold, Performance Insights samples the active sessions, with db.load.avg showing the scaled values,
         * db.sampledload.avg showing the raw values, and db.sampledload.avg less
         * than db.load.avg. For most use cases, you can query db.load.avg only.
         */
        var metric: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pi.model.ResponseResourceMetricKey) : this() {
            this.dimensions = x.dimensions
            this.metric = x.metric
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pi.model.ResponseResourceMetricKey = ResponseResourceMetricKey(this)
    }
}
